<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BarcodeInfo StructType
 * @subpackage Structs
 */
class BarcodeInfo extends AbstractStructBase
{
    /**
     * The ShipmentIdentificationNumberBarcodeContent
     * Meta information extracted from the WSDL
     * - base: xsd:base64Binary
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentIdentificationNumberBarcodeContent;
    /**
     * The TrackingNumberBarcodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_TrackingNumberBarcodes
     */
    public $TrackingNumberBarcodes;
    /**
     * The OriginDestinationServiceTypeBarcodeContent
     * Meta information extracted from the WSDL
     * - base: xsd:base64Binary
     * - minOccurs: 0
     * @var string
     */
    public $OriginDestinationServiceTypeBarcodeContent;
    /**
     * The DHLRoutingBarcodeContent
     * Meta information extracted from the WSDL
     * - base: xsd:base64Binary
     * - minOccurs: 0
     * @var string
     */
    public $DHLRoutingBarcodeContent;
    /**
     * Constructor method for BarcodeInfo
     * @uses BarcodeInfo::setShipmentIdentificationNumberBarcodeContent()
     * @uses BarcodeInfo::setTrackingNumberBarcodes()
     * @uses BarcodeInfo::setOriginDestinationServiceTypeBarcodeContent()
     * @uses BarcodeInfo::setDHLRoutingBarcodeContent()
     * @param string $shipmentIdentificationNumberBarcodeContent
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_TrackingNumberBarcodes $trackingNumberBarcodes
     * @param string $originDestinationServiceTypeBarcodeContent
     * @param string $dHLRoutingBarcodeContent
     */
    public function __construct($shipmentIdentificationNumberBarcodeContent = null, \App\Delivery\Dhl\StructType\DocTypeRef_TrackingNumberBarcodes $trackingNumberBarcodes = null, $originDestinationServiceTypeBarcodeContent = null, $dHLRoutingBarcodeContent = null)
    {
        $this
            ->setShipmentIdentificationNumberBarcodeContent($shipmentIdentificationNumberBarcodeContent)
            ->setTrackingNumberBarcodes($trackingNumberBarcodes)
            ->setOriginDestinationServiceTypeBarcodeContent($originDestinationServiceTypeBarcodeContent)
            ->setDHLRoutingBarcodeContent($dHLRoutingBarcodeContent);
    }
    /**
     * Get ShipmentIdentificationNumberBarcodeContent value
     * @return string|null
     */
    public function getShipmentIdentificationNumberBarcodeContent()
    {
        return $this->ShipmentIdentificationNumberBarcodeContent;
    }
    /**
     * Set ShipmentIdentificationNumberBarcodeContent value
     * @param string $shipmentIdentificationNumberBarcodeContent
     * @return \App\Delivery\Dhl\StructType\BarcodeInfo
     */
    public function setShipmentIdentificationNumberBarcodeContent($shipmentIdentificationNumberBarcodeContent = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentIdentificationNumberBarcodeContent) && !is_string($shipmentIdentificationNumberBarcodeContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentIdentificationNumberBarcodeContent, true), gettype($shipmentIdentificationNumberBarcodeContent)), __LINE__);
        }
        $this->ShipmentIdentificationNumberBarcodeContent = $shipmentIdentificationNumberBarcodeContent;
        return $this;
    }
    /**
     * Get TrackingNumberBarcodes value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_TrackingNumberBarcodes|null
     */
    public function getTrackingNumberBarcodes()
    {
        return $this->TrackingNumberBarcodes;
    }
    /**
     * Set TrackingNumberBarcodes value
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_TrackingNumberBarcodes $trackingNumberBarcodes
     * @return \App\Delivery\Dhl\StructType\BarcodeInfo
     */
    public function setTrackingNumberBarcodes(\App\Delivery\Dhl\StructType\DocTypeRef_TrackingNumberBarcodes $trackingNumberBarcodes = null)
    {
        $this->TrackingNumberBarcodes = $trackingNumberBarcodes;
        return $this;
    }
    /**
     * Get OriginDestinationServiceTypeBarcodeContent value
     * @return string|null
     */
    public function getOriginDestinationServiceTypeBarcodeContent()
    {
        return $this->OriginDestinationServiceTypeBarcodeContent;
    }
    /**
     * Set OriginDestinationServiceTypeBarcodeContent value
     * @param string $originDestinationServiceTypeBarcodeContent
     * @return \App\Delivery\Dhl\StructType\BarcodeInfo
     */
    public function setOriginDestinationServiceTypeBarcodeContent($originDestinationServiceTypeBarcodeContent = null)
    {
        // validation for constraint: string
        if (!is_null($originDestinationServiceTypeBarcodeContent) && !is_string($originDestinationServiceTypeBarcodeContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originDestinationServiceTypeBarcodeContent, true), gettype($originDestinationServiceTypeBarcodeContent)), __LINE__);
        }
        $this->OriginDestinationServiceTypeBarcodeContent = $originDestinationServiceTypeBarcodeContent;
        return $this;
    }
    /**
     * Get DHLRoutingBarcodeContent value
     * @return string|null
     */
    public function getDHLRoutingBarcodeContent()
    {
        return $this->DHLRoutingBarcodeContent;
    }
    /**
     * Set DHLRoutingBarcodeContent value
     * @param string $dHLRoutingBarcodeContent
     * @return \App\Delivery\Dhl\StructType\BarcodeInfo
     */
    public function setDHLRoutingBarcodeContent($dHLRoutingBarcodeContent = null)
    {
        // validation for constraint: string
        if (!is_null($dHLRoutingBarcodeContent) && !is_string($dHLRoutingBarcodeContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dHLRoutingBarcodeContent, true), gettype($dHLRoutingBarcodeContent)), __LINE__);
        }
        $this->DHLRoutingBarcodeContent = $dHLRoutingBarcodeContent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Delivery\Dhl\StructType\BarcodeInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
