<?php

namespace App\Delivery\Dhl\EnumType;

/**
 * This class stands for LogoImageFormat EnumType
 * Meta information extracted from the WSDL
 * - documentation: Customer Logo Image Format
 * @subpackage Enumerations
 */
class LogoImageFormat
{
    /**
     * Constant for value 'PNG'
     * @return string 'PNG'
     */
    const VALUE_PNG = 'PNG';
    /**
     * Constant for value 'GIF'
     * @return string 'GIF'
     */
    const VALUE_GIF = 'GIF';
    /**
     * Constant for value 'JPEG'
     * @return string 'JPEG'
     */
    const VALUE_JPEG = 'JPEG';
    /**
     * Constant for value 'JPG'
     * @return string 'JPG'
     */
    const VALUE_JPG = 'JPG';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PNG
     * @uses self::VALUE_GIF
     * @uses self::VALUE_JPEG
     * @uses self::VALUE_JPG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PNG,
            self::VALUE_GIF,
            self::VALUE_JPEG,
            self::VALUE_JPG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
