<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageReferenceType StructType
 * Meta information extracted from the WSDL
 * - documentation: To support multiple piece reference
 * @subpackage Structs
 */
class PackageReferenceType extends AbstractStructBase
{
    /**
     * The PackageReference
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 35
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $PackageReference;
    /**
     * The PackageReferenceType
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 2
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $PackageReferenceType;
    /**
     * Constructor method for PackageReferenceType
     * @uses PackageReferenceType::setPackageReference()
     * @uses PackageReferenceType::setPackageReferenceType()
     * @param string $packageReference
     * @param string $packageReferenceType
     */
    public function __construct($packageReference = null, $packageReferenceType = null)
    {
        $this
            ->setPackageReference($packageReference)
            ->setPackageReferenceType($packageReferenceType);
    }
    /**
     * Get PackageReference value
     * @return string|null
     */
    public function getPackageReference()
    {
        return $this->PackageReference;
    }
    /**
     * Set PackageReference value
     * @param string $packageReference
     * @return \App\Delivery\Dhl\StructType\PackageReferenceType
     */
    public function setPackageReference($packageReference = null)
    {
        // validation for constraint: string
        if (!is_null($packageReference) && !is_string($packageReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageReference, true), gettype($packageReference)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($packageReference) && mb_strlen($packageReference) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($packageReference)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($packageReference) && mb_strlen($packageReference) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($packageReference)), __LINE__);
        }
        $this->PackageReference = $packageReference;
        return $this;
    }
    /**
     * Get PackageReferenceType value
     * @return string|null
     */
    public function getPackageReferenceType()
    {
        return $this->PackageReferenceType;
    }
    /**
     * Set PackageReferenceType value
     * @param string $packageReferenceType
     * @return \App\Delivery\Dhl\StructType\PackageReferenceType
     */
    public function setPackageReferenceType($packageReferenceType = null)
    {
        // validation for constraint: string
        if (!is_null($packageReferenceType) && !is_string($packageReferenceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageReferenceType, true), gettype($packageReferenceType)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($packageReferenceType) && mb_strlen($packageReferenceType) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($packageReferenceType)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($packageReferenceType) && mb_strlen($packageReferenceType) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($packageReferenceType)), __LINE__);
        }
        $this->PackageReferenceType = $packageReferenceType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Delivery\Dhl\StructType\PackageReferenceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
