<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeRate StructType
 * @subpackage Structs
 */
class ExchangeRate extends AbstractStructBase
{
    /**
     * The Rate
     * Meta information extracted from the WSDL
     * - documentation: Rate of the currency exchange
     * @var string
     */
    public $Rate;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - documentation: The currency code
     * @var string
     */
    public $Currency;
    /**
     * The BaseCurrency
     * Meta information extracted from the WSDL
     * - documentation: The currency code of the base currency is either USD or EUR
     * @var string
     */
    public $BaseCurrency;
    /**
     * Constructor method for ExchangeRate
     * @uses ExchangeRate::setRate()
     * @uses ExchangeRate::setCurrency()
     * @uses ExchangeRate::setBaseCurrency()
     * @param string $rate
     * @param string $currency
     * @param string $baseCurrency
     */
    public function __construct($rate = null, $currency = null, $baseCurrency = null)
    {
        $this
            ->setRate($rate)
            ->setCurrency($currency)
            ->setBaseCurrency($baseCurrency);
    }
    /**
     * Get Rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param string $rate
     * @return \App\Delivery\Dhl\StructType\ExchangeRate
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \App\Delivery\Dhl\StructType\ExchangeRate
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get BaseCurrency value
     * @return string|null
     */
    public function getBaseCurrency()
    {
        return $this->BaseCurrency;
    }
    /**
     * Set BaseCurrency value
     * @param string $baseCurrency
     * @return \App\Delivery\Dhl\StructType\ExchangeRate
     */
    public function setBaseCurrency($baseCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($baseCurrency) && !is_string($baseCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseCurrency, true), gettype($baseCurrency)), __LINE__);
        }
        $this->BaseCurrency = $baseCurrency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Delivery\Dhl\StructType\ExchangeRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
