<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_PackageResultType StructType
 * @subpackage Structs
 */
class DocTypeRef_PackageResultType extends AbstractStructBase
{
    /**
     * The TrackingNumber
     * Meta information extracted from the WSDL
     * - documentation: This field contains a unique number for the individual package.
     * - base: xsd:token
     * - maxLength: 35
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $TrackingNumber;
    /**
     * The VolumetricWeight
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $VolumetricWeight;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxInclusive: 999
     * - minInclusive: 1
     * @var int
     */
    public $number;
    /**
     * Constructor method for docTypeRef_PackageResultType
     * @uses DocTypeRef_PackageResultType::setTrackingNumber()
     * @uses DocTypeRef_PackageResultType::setVolumetricWeight()
     * @uses DocTypeRef_PackageResultType::setNumber()
     * @param string $trackingNumber
     * @param float $volumetricWeight
     * @param int $number
     */
    public function __construct($trackingNumber = null, $volumetricWeight = null, $number = null)
    {
        $this
            ->setTrackingNumber($trackingNumber)
            ->setVolumetricWeight($volumetricWeight)
            ->setNumber($number);
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_PackageResultType
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($trackingNumber) && mb_strlen($trackingNumber) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($trackingNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($trackingNumber) && mb_strlen($trackingNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get VolumetricWeight value
     * @return float|null
     */
    public function getVolumetricWeight()
    {
        return $this->VolumetricWeight;
    }
    /**
     * Set VolumetricWeight value
     * @param float $volumetricWeight
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_PackageResultType
     */
    public function setVolumetricWeight($volumetricWeight = null)
    {
        // validation for constraint: float
        if (!is_null($volumetricWeight) && !(is_float($volumetricWeight) || is_numeric($volumetricWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volumetricWeight, true), gettype($volumetricWeight)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($volumetricWeight) && mb_strlen(mb_substr($volumetricWeight, mb_strpos($volumetricWeight, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($volumetricWeight, true), mb_strlen(mb_substr($volumetricWeight, mb_strpos($volumetricWeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($volumetricWeight) && mb_strlen(preg_replace('/(\D)/', '', $volumetricWeight)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($volumetricWeight, true), mb_strlen(preg_replace('/(\D)/', '', $volumetricWeight))), __LINE__);
        }
        $this->VolumetricWeight = $volumetricWeight;
        return $this;
    }
    /**
     * Get number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param int $number
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_PackageResultType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($number) && $number > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($number, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($number) && $number < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($number, true)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_PackageResultType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
