<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExportLineItemType StructType
 * @subpackage Structs
 */
class ExportLineItemType extends AbstractStructBase
{
    /**
     * The CommodityCode
     * Meta information extracted from the WSDL
     * - documentation: Commodity code for the shipment at item line level | Commodity codes for shipment type
     * - base: xsd:string
     * - maxLength: 20
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommodityCode;
    /**
     * The ECCN
     * Meta information extracted from the WSDL
     * - documentation: ECCN (Export Control Classification Number) info | "ECCN"
     * - base: xsd:string
     * - maxLength: 30
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $ECCN;
    /**
     * The ExportReasonType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExportReasonType;
    /**
     * The ItemNumber
     * Meta information extracted from the WSDL
     * - documentation: Serial number for the items | Export line item number
     * - base: xsd:positiveInteger
     * - minInclusive: 1
     * @var int
     */
    public $ItemNumber;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: Number of pieces of a particular line item
     * - base: xsd:integer
     * - maxInclusive: 1000000000
     * - minInclusive: 1
     * @var int
     */
    public $Quantity;
    /**
     * The QuantityUnitOfMeasurement
     * @var string
     */
    public $QuantityUnitOfMeasurement;
    /**
     * The ItemDescription
     * Meta information extracted from the WSDL
     * - documentation: The description of the line item | Export line item description
     * - base: xsd:string
     * - maxLength: 170
     * @var string
     */
    public $ItemDescription;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - documentation: Monetary value of each line item
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - totalDigits: 18
     * - whiteSpace: collapse
     * @var float
     */
    public $UnitPrice;
    /**
     * The NetWeight
     * Meta information extracted from the WSDL
     * - documentation: Net weight of the line item
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - totalDigits: 12
     * - whiteSpace: collapse
     * @var float
     */
    public $NetWeight;
    /**
     * The GrossWeight
     * Meta information extracted from the WSDL
     * - documentation: Gross weight of the line item
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - totalDigits: 12
     * - whiteSpace: collapse
     * @var float
     */
    public $GrossWeight;
    /**
     * The ManufacturingCountryCode
     * Meta information extracted from the WSDL
     * - documentation: Manufacturing ISO country code | ISO 2 character codes of the Shipper/Recipient country
     * - base: xsd:string
     * - maxLength: 2
     * - minLength: 2
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $ManufacturingCountryCode;
    /**
     * The TaxesPaid
     * Meta information extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $TaxesPaid;
    /**
     * Constructor method for ExportLineItemType
     * @uses ExportLineItemType::setCommodityCode()
     * @uses ExportLineItemType::setECCN()
     * @uses ExportLineItemType::setExportReasonType()
     * @uses ExportLineItemType::setItemNumber()
     * @uses ExportLineItemType::setQuantity()
     * @uses ExportLineItemType::setQuantityUnitOfMeasurement()
     * @uses ExportLineItemType::setItemDescription()
     * @uses ExportLineItemType::setUnitPrice()
     * @uses ExportLineItemType::setNetWeight()
     * @uses ExportLineItemType::setGrossWeight()
     * @uses ExportLineItemType::setManufacturingCountryCode()
     * @uses ExportLineItemType::setTaxesPaid()
     * @param string $commodityCode
     * @param string $eCCN
     * @param string $exportReasonType
     * @param int $itemNumber
     * @param int $quantity
     * @param string $quantityUnitOfMeasurement
     * @param string $itemDescription
     * @param float $unitPrice
     * @param float $netWeight
     * @param float $grossWeight
     * @param string $manufacturingCountryCode
     * @param string $taxesPaid
     */
    public function __construct($commodityCode = null, $eCCN = null, $exportReasonType = null, $itemNumber = null, $quantity = null, $quantityUnitOfMeasurement = null, $itemDescription = null, $unitPrice = null, $netWeight = null, $grossWeight = null, $manufacturingCountryCode = null, $taxesPaid = 'N')
    {
        $this
            ->setCommodityCode($commodityCode)
            ->setECCN($eCCN)
            ->setExportReasonType($exportReasonType)
            ->setItemNumber($itemNumber)
            ->setQuantity($quantity)
            ->setQuantityUnitOfMeasurement($quantityUnitOfMeasurement)
            ->setItemDescription($itemDescription)
            ->setUnitPrice($unitPrice)
            ->setNetWeight($netWeight)
            ->setGrossWeight($grossWeight)
            ->setManufacturingCountryCode($manufacturingCountryCode)
            ->setTaxesPaid($taxesPaid);
    }
    /**
     * Get CommodityCode value
     * @return string|null
     */
    public function getCommodityCode()
    {
        return $this->CommodityCode;
    }
    /**
     * Set CommodityCode value
     * @param string $commodityCode
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setCommodityCode($commodityCode = null)
    {
        // validation for constraint: string
        if (!is_null($commodityCode) && !is_string($commodityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commodityCode, true), gettype($commodityCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($commodityCode) && mb_strlen($commodityCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($commodityCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($commodityCode) && mb_strlen($commodityCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($commodityCode)), __LINE__);
        }
        $this->CommodityCode = $commodityCode;
        return $this;
    }
    /**
     * Get ECCN value
     * @return string|null
     */
    public function getECCN()
    {
        return $this->ECCN;
    }
    /**
     * Set ECCN value
     * @param string $eCCN
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setECCN($eCCN = null)
    {
        // validation for constraint: string
        if (!is_null($eCCN) && !is_string($eCCN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCCN, true), gettype($eCCN)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($eCCN) && mb_strlen($eCCN) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($eCCN)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($eCCN) && mb_strlen($eCCN) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($eCCN)), __LINE__);
        }
        $this->ECCN = $eCCN;
        return $this;
    }
    /**
     * Get ExportReasonType value
     * @return string|null
     */
    public function getExportReasonType()
    {
        return $this->ExportReasonType;
    }
    /**
     * Set ExportReasonType value
     * @uses \App\Delivery\Dhl\EnumType\ExportReasonType::valueIsValid()
     * @uses \App\Delivery\Dhl\EnumType\ExportReasonType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $exportReasonType
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setExportReasonType($exportReasonType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Delivery\Dhl\EnumType\ExportReasonType::valueIsValid($exportReasonType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Delivery\Dhl\EnumType\ExportReasonType', is_array($exportReasonType) ? implode(', ', $exportReasonType) : var_export($exportReasonType, true), implode(', ', \App\Delivery\Dhl\EnumType\ExportReasonType::getValidValues())), __LINE__);
        }
        $this->ExportReasonType = $exportReasonType;
        return $this;
    }
    /**
     * Get ItemNumber value
     * @return int|null
     */
    public function getItemNumber()
    {
        return $this->ItemNumber;
    }
    /**
     * Set ItemNumber value
     * @param int $itemNumber
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setItemNumber($itemNumber = null)
    {
        // validation for constraint: int
        if (!is_null($itemNumber) && !(is_int($itemNumber) || ctype_digit($itemNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemNumber, true), gettype($itemNumber)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($itemNumber) && $itemNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($itemNumber, true)), __LINE__);
        }
        $this->ItemNumber = $itemNumber;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: maxInclusive(1000000000)
        if (!is_null($quantity) && $quantity > 1000000000) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 1000000000', var_export($quantity, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($quantity) && $quantity < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($quantity, true)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get QuantityUnitOfMeasurement value
     * @return string|null
     */
    public function getQuantityUnitOfMeasurement()
    {
        return $this->QuantityUnitOfMeasurement;
    }
    /**
     * Set QuantityUnitOfMeasurement value
     * @uses \App\Delivery\Dhl\EnumType\QuantityUnitOfMeasurement::valueIsValid()
     * @uses \App\Delivery\Dhl\EnumType\QuantityUnitOfMeasurement::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quantityUnitOfMeasurement
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setQuantityUnitOfMeasurement($quantityUnitOfMeasurement = null)
    {
        // validation for constraint: enumeration
        if (!\App\Delivery\Dhl\EnumType\QuantityUnitOfMeasurement::valueIsValid($quantityUnitOfMeasurement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Delivery\Dhl\EnumType\QuantityUnitOfMeasurement', is_array($quantityUnitOfMeasurement) ? implode(', ', $quantityUnitOfMeasurement) : var_export($quantityUnitOfMeasurement, true), implode(', ', \App\Delivery\Dhl\EnumType\QuantityUnitOfMeasurement::getValidValues())), __LINE__);
        }
        $this->QuantityUnitOfMeasurement = $quantityUnitOfMeasurement;
        return $this;
    }
    /**
     * Get ItemDescription value
     * @return string|null
     */
    public function getItemDescription()
    {
        return $this->ItemDescription;
    }
    /**
     * Set ItemDescription value
     * @param string $itemDescription
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setItemDescription($itemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescription) && !is_string($itemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDescription, true), gettype($itemDescription)), __LINE__);
        }
        // validation for constraint: maxLength(170)
        if (!is_null($itemDescription) && mb_strlen($itemDescription) > 170) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 170', mb_strlen($itemDescription)), __LINE__);
        }
        $this->ItemDescription = $itemDescription;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return float|null
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param float $unitPrice
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($unitPrice) && mb_strlen(mb_substr($unitPrice, mb_strpos($unitPrice, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($unitPrice, true), mb_strlen(mb_substr($unitPrice, mb_strpos($unitPrice, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($unitPrice) && mb_strlen(preg_replace('/(\D)/', '', $unitPrice)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($unitPrice, true), mb_strlen(preg_replace('/(\D)/', '', $unitPrice))), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get NetWeight value
     * @return float|null
     */
    public function getNetWeight()
    {
        return $this->NetWeight;
    }
    /**
     * Set NetWeight value
     * @param float $netWeight
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setNetWeight($netWeight = null)
    {
        // validation for constraint: float
        if (!is_null($netWeight) && !(is_float($netWeight) || is_numeric($netWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netWeight, true), gettype($netWeight)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($netWeight) && mb_strlen(mb_substr($netWeight, mb_strpos($netWeight, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($netWeight, true), mb_strlen(mb_substr($netWeight, mb_strpos($netWeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($netWeight) && mb_strlen(preg_replace('/(\D)/', '', $netWeight)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($netWeight, true), mb_strlen(preg_replace('/(\D)/', '', $netWeight))), __LINE__);
        }
        $this->NetWeight = $netWeight;
        return $this;
    }
    /**
     * Get GrossWeight value
     * @return float|null
     */
    public function getGrossWeight()
    {
        return $this->GrossWeight;
    }
    /**
     * Set GrossWeight value
     * @param float $grossWeight
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setGrossWeight($grossWeight = null)
    {
        // validation for constraint: float
        if (!is_null($grossWeight) && !(is_float($grossWeight) || is_numeric($grossWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossWeight, true), gettype($grossWeight)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($grossWeight) && mb_strlen(mb_substr($grossWeight, mb_strpos($grossWeight, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($grossWeight, true), mb_strlen(mb_substr($grossWeight, mb_strpos($grossWeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($grossWeight) && mb_strlen(preg_replace('/(\D)/', '', $grossWeight)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($grossWeight, true), mb_strlen(preg_replace('/(\D)/', '', $grossWeight))), __LINE__);
        }
        $this->GrossWeight = $grossWeight;
        return $this;
    }
    /**
     * Get ManufacturingCountryCode value
     * @return string|null
     */
    public function getManufacturingCountryCode()
    {
        return $this->ManufacturingCountryCode;
    }
    /**
     * Set ManufacturingCountryCode value
     * @param string $manufacturingCountryCode
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setManufacturingCountryCode($manufacturingCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturingCountryCode) && !is_string($manufacturingCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturingCountryCode, true), gettype($manufacturingCountryCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($manufacturingCountryCode) && mb_strlen($manufacturingCountryCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($manufacturingCountryCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($manufacturingCountryCode) && mb_strlen($manufacturingCountryCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($manufacturingCountryCode)), __LINE__);
        }
        $this->ManufacturingCountryCode = $manufacturingCountryCode;
        return $this;
    }
    /**
     * Get TaxesPaid value
     * @return string|null
     */
    public function getTaxesPaid()
    {
        return $this->TaxesPaid;
    }
    /**
     * Set TaxesPaid value
     * @uses \App\Delivery\Dhl\EnumType\TaxesPaid::valueIsValid()
     * @uses \App\Delivery\Dhl\EnumType\TaxesPaid::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxesPaid
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public function setTaxesPaid($taxesPaid = 'N')
    {
        // validation for constraint: enumeration
        if (!\App\Delivery\Dhl\EnumType\TaxesPaid::valueIsValid($taxesPaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Delivery\Dhl\EnumType\TaxesPaid', is_array($taxesPaid) ? implode(', ', $taxesPaid) : var_export($taxesPaid, true), implode(', ', \App\Delivery\Dhl\EnumType\TaxesPaid::getValidValues())), __LINE__);
        }
        $this->TaxesPaid = $taxesPaid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Delivery\Dhl\StructType\ExportLineItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
