<?php

namespace App\Delivery\Dhl\EnumType;

/**
 * This class stands for DropOffType2 EnumType
 * @subpackage Enumerations
 */
class DropOffType2
{
    /**
     * Constant for value 'REGULAR_PICKUP'
     * @return string 'REGULAR_PICKUP'
     */
    const VALUE_REGULAR_PICKUP = 'REGULAR_PICKUP';
    /**
     * Constant for value 'REQUEST_COURIER'
     * @return string 'REQUEST_COURIER'
     */
    const VALUE_REQUEST_COURIER = 'REQUEST_COURIER';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REGULAR_PICKUP
     * @uses self::VALUE_REQUEST_COURIER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REGULAR_PICKUP,
            self::VALUE_REQUEST_COURIER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
