<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_RegistrationNumber StructType
 * @subpackage Structs
 */
class DocTypeRef_RegistrationNumber extends AbstractStructBase
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: Registration Number
     * - base: xsd:token
     * - maxLength: 20
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $Number;
    /**
     * The NumberTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Type of the registration number. Pleasae refer to the developer guide for valid type of registration number
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $NumberTypeCode;
    /**
     * The NumberIssuerCountryCode
     * Meta information extracted from the WSDL
     * - documentation: ISO 2 character code of the country where the Registration Number has been issued by
     * - base: xsd:token
     * - maxLength: 2
     * - minLength: 2
     * - whiteSpace: collapse
     * @var string
     */
    public $NumberIssuerCountryCode;
    /**
     * Constructor method for docTypeRef_RegistrationNumber
     * @uses DocTypeRef_RegistrationNumber::setNumber()
     * @uses DocTypeRef_RegistrationNumber::setNumberTypeCode()
     * @uses DocTypeRef_RegistrationNumber::setNumberIssuerCountryCode()
     * @param string $number
     * @param string $numberTypeCode
     * @param string $numberIssuerCountryCode
     */
    public function __construct($number = null, $numberTypeCode = null, $numberIssuerCountryCode = null)
    {
        $this
            ->setNumber($number)
            ->setNumberTypeCode($numberTypeCode)
            ->setNumberIssuerCountryCode($numberIssuerCountryCode);
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RegistrationNumber
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($number) && mb_strlen($number) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($number)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($number) && mb_strlen($number) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get NumberTypeCode value
     * @return string|null
     */
    public function getNumberTypeCode()
    {
        return $this->NumberTypeCode;
    }
    /**
     * Set NumberTypeCode value
     * @param string $numberTypeCode
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RegistrationNumber
     */
    public function setNumberTypeCode($numberTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($numberTypeCode) && !is_string($numberTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberTypeCode, true), gettype($numberTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($numberTypeCode) && mb_strlen($numberTypeCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($numberTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($numberTypeCode) && mb_strlen($numberTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($numberTypeCode)), __LINE__);
        }
        $this->NumberTypeCode = $numberTypeCode;
        return $this;
    }
    /**
     * Get NumberIssuerCountryCode value
     * @return string|null
     */
    public function getNumberIssuerCountryCode()
    {
        return $this->NumberIssuerCountryCode;
    }
    /**
     * Set NumberIssuerCountryCode value
     * @param string $numberIssuerCountryCode
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RegistrationNumber
     */
    public function setNumberIssuerCountryCode($numberIssuerCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($numberIssuerCountryCode) && !is_string($numberIssuerCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberIssuerCountryCode, true), gettype($numberIssuerCountryCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($numberIssuerCountryCode) && mb_strlen($numberIssuerCountryCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($numberIssuerCountryCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($numberIssuerCountryCode) && mb_strlen($numberIssuerCountryCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($numberIssuerCountryCode)), __LINE__);
        }
        $this->NumberIssuerCountryCode = $numberIssuerCountryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RegistrationNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
