<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_DestinationServiceAreaType StructType
 * @subpackage Structs
 */
class DocTypeRef_DestinationServiceAreaType extends AbstractStructBase
{
    /**
     * The FacilityCode
     * Meta information extracted from the WSDL
     * - documentation: The DHL Facility Code for the Destination
     * - base: xsd:token
     * - maxLength: 3
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $FacilityCode;
    /**
     * The ServiceAreaCode
     * Meta information extracted from the WSDL
     * - documentation: The DHL Service Area Code for the destination of the Shipment
     * - base: xsd:token
     * - maxLength: 3
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $ServiceAreaCode;
    /**
     * The InboundSortCode
     * Meta information extracted from the WSDL
     * - documentation: Inbound Sort Code of Destination
     * - base: xsd:token
     * - maxLength: 4
     * - minLength: 1
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $InboundSortCode;
    /**
     * Constructor method for docTypeRef_DestinationServiceAreaType
     * @uses DocTypeRef_DestinationServiceAreaType::setFacilityCode()
     * @uses DocTypeRef_DestinationServiceAreaType::setServiceAreaCode()
     * @uses DocTypeRef_DestinationServiceAreaType::setInboundSortCode()
     * @param string $facilityCode
     * @param string $serviceAreaCode
     * @param string $inboundSortCode
     */
    public function __construct($facilityCode = null, $serviceAreaCode = null, $inboundSortCode = null)
    {
        $this
            ->setFacilityCode($facilityCode)
            ->setServiceAreaCode($serviceAreaCode)
            ->setInboundSortCode($inboundSortCode);
    }
    /**
     * Get FacilityCode value
     * @return string|null
     */
    public function getFacilityCode()
    {
        return $this->FacilityCode;
    }
    /**
     * Set FacilityCode value
     * @param string $facilityCode
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DestinationServiceAreaType
     */
    public function setFacilityCode($facilityCode = null)
    {
        // validation for constraint: string
        if (!is_null($facilityCode) && !is_string($facilityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facilityCode, true), gettype($facilityCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($facilityCode) && mb_strlen($facilityCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($facilityCode)), __LINE__);
        }
        $this->FacilityCode = $facilityCode;
        return $this;
    }
    /**
     * Get ServiceAreaCode value
     * @return string|null
     */
    public function getServiceAreaCode()
    {
        return $this->ServiceAreaCode;
    }
    /**
     * Set ServiceAreaCode value
     * @param string $serviceAreaCode
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DestinationServiceAreaType
     */
    public function setServiceAreaCode($serviceAreaCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceAreaCode) && !is_string($serviceAreaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceAreaCode, true), gettype($serviceAreaCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($serviceAreaCode) && mb_strlen($serviceAreaCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($serviceAreaCode)), __LINE__);
        }
        $this->ServiceAreaCode = $serviceAreaCode;
        return $this;
    }
    /**
     * Get InboundSortCode value
     * @return string|null
     */
    public function getInboundSortCode()
    {
        return $this->InboundSortCode;
    }
    /**
     * Set InboundSortCode value
     * @param string $inboundSortCode
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DestinationServiceAreaType
     */
    public function setInboundSortCode($inboundSortCode = null)
    {
        // validation for constraint: string
        if (!is_null($inboundSortCode) && !is_string($inboundSortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inboundSortCode, true), gettype($inboundSortCode)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($inboundSortCode) && mb_strlen($inboundSortCode) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($inboundSortCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inboundSortCode) && mb_strlen($inboundSortCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inboundSortCode)), __LINE__);
        }
        $this->InboundSortCode = $inboundSortCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DestinationServiceAreaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
