<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalQuantityDefinitionType StructType
 * @subpackage Structs
 */
class AdditionalQuantityDefinitionType extends AbstractStructBase
{
    /**
     * The AdditionalQuantity
     * Meta information extracted from the WSDL
     * - documentation: An Item's additional quantity value: example is percent of alcohol
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - totalDigits: 12
     * @var float
     */
    public $AdditionalQuantity;
    /**
     * The AdditionalQuantityType
     * Meta information extracted from the WSDL
     * - documentation: Item additional quantity value UOM: example PFL=percent of alcohol
     * - base: xsd:string
     * - maxLength: 3
     * - minLength: 2
     * @var string
     */
    public $AdditionalQuantityType;
    /**
     * Constructor method for AdditionalQuantityDefinitionType
     * @uses AdditionalQuantityDefinitionType::setAdditionalQuantity()
     * @uses AdditionalQuantityDefinitionType::setAdditionalQuantityType()
     * @param float $additionalQuantity
     * @param string $additionalQuantityType
     */
    public function __construct($additionalQuantity = null, $additionalQuantityType = null)
    {
        $this
            ->setAdditionalQuantity($additionalQuantity)
            ->setAdditionalQuantityType($additionalQuantityType);
    }
    /**
     * Get AdditionalQuantity value
     * @return float|null
     */
    public function getAdditionalQuantity()
    {
        return $this->AdditionalQuantity;
    }
    /**
     * Set AdditionalQuantity value
     * @param float $additionalQuantity
     * @return \App\Delivery\Dhl\StructType\AdditionalQuantityDefinitionType
     */
    public function setAdditionalQuantity($additionalQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($additionalQuantity) && !(is_float($additionalQuantity) || is_numeric($additionalQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($additionalQuantity, true), gettype($additionalQuantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($additionalQuantity) && mb_strlen(mb_substr($additionalQuantity, mb_strpos($additionalQuantity, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($additionalQuantity, true), mb_strlen(mb_substr($additionalQuantity, mb_strpos($additionalQuantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($additionalQuantity) && mb_strlen(preg_replace('/(\D)/', '', $additionalQuantity)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($additionalQuantity, true), mb_strlen(preg_replace('/(\D)/', '', $additionalQuantity))), __LINE__);
        }
        $this->AdditionalQuantity = $additionalQuantity;
        return $this;
    }
    /**
     * Get AdditionalQuantityType value
     * @return string|null
     */
    public function getAdditionalQuantityType()
    {
        return $this->AdditionalQuantityType;
    }
    /**
     * Set AdditionalQuantityType value
     * @param string $additionalQuantityType
     * @return \App\Delivery\Dhl\StructType\AdditionalQuantityDefinitionType
     */
    public function setAdditionalQuantityType($additionalQuantityType = null)
    {
        // validation for constraint: string
        if (!is_null($additionalQuantityType) && !is_string($additionalQuantityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalQuantityType, true), gettype($additionalQuantityType)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($additionalQuantityType) && mb_strlen($additionalQuantityType) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($additionalQuantityType)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($additionalQuantityType) && mb_strlen($additionalQuantityType) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($additionalQuantityType)), __LINE__);
        }
        $this->AdditionalQuantityType = $additionalQuantityType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Delivery\Dhl\StructType\AdditionalQuantityDefinitionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
