<?php

namespace App\Delivery\Dhl\EnumType;

/**
 * This class stands for NetworkTypeCode2 EnumType
 * @subpackage Enumerations
 */
class NetworkTypeCode2
{
    /**
     * Constant for value 'AL'
     * @return string 'AL'
     */
    const VALUE_AL = 'AL';
    /**
     * Constant for value 'DD'
     * @return string 'DD'
     */
    const VALUE_DD = 'DD';
    /**
     * Constant for value 'TD'
     * @return string 'TD'
     */
    const VALUE_TD = 'TD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AL
     * @uses self::VALUE_DD
     * @uses self::VALUE_TD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AL,
            self::VALUE_DD,
            self::VALUE_TD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
