<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExportDeclaration StructType
 * @subpackage Structs
 */
class ExportDeclaration extends AbstractStructBase
{
    /**
     * The DestinationPort
     * Meta information extracted from the WSDL
     * - documentation: Destination port details
     * - minOccurs: 0
     * @var string
     */
    public $DestinationPort;
    /**
     * The ExporterCode
     * Meta information extracted from the WSDL
     * - documentation: Exporter Code
     * - minOccurs: 0
     * @var string
     */
    public $ExporterCode;
    /**
     * The ExporterID
     * Meta information extracted from the WSDL
     * - documentation: Exporter ID
     * - minOccurs: 0
     * @var string
     */
    public $ExporterID;
    /**
     * The ExportLicense
     * Meta information extracted from the WSDL
     * - documentation: Export license info | Export License
     * - base: xsd:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $ExportLicense;
    /**
     * The ExportLineItems
     * Meta information extracted from the WSDL
     * - documentation: Specifics about each of the export line item
     * @var \App\Delivery\Dhl\StructType\ExportLineItems
     */
    public $ExportLineItems;
    /**
     * The ExportReason
     * Meta information extracted from the WSDL
     * - documentation: Export Reason
     * - base: xsd:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $ExportReason;
    /**
     * The ImportLicense
     * Meta information extracted from the WSDL
     * - documentation: Consignee import license | "Import License"
     * - base: xsd:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $ImportLicense;
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - documentation: The date component must be in the format: YYYY-MM-DD. This field is mandatory when RequestCommercialInvoice = Y
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceDate;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - documentation: Invoice number. This field is mandatory when RequestCommercialInvoice = Y.
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The InvoiceDeclarationTexts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\InvoiceDeclarationTexts
     */
    public $InvoiceDeclarationTexts;
    /**
     * The InvoiceSignatureDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\InvoiceSignatureDetails
     */
    public $InvoiceSignatureDetails;
    /**
     * The OtherCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\OtherCharges
     */
    public $OtherCharges;
    /**
     * The PackageMarks
     * Meta information extracted from the WSDL
     * - documentation: Package marks
     * - minOccurs: 0
     * @var string
     */
    public $PackageMarks;
    /**
     * The PayerGSTVAT
     * Meta information extracted from the WSDL
     * - documentation: Payer GST VAT details
     * - minOccurs: 0
     * @var string
     */
    public $PayerGSTVAT;
    /**
     * The RecipientReference
     * Meta information extracted from the WSDL
     * - documentation: Recipient reference
     * - minOccurs: 0
     * @var string
     */
    public $RecipientReference;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\Remarks
     */
    public $Remarks;
    /**
     * The TermsOfPayment
     * Meta information extracted from the WSDL
     * - documentation: Terms of payment
     * - minOccurs: 0
     * @var string
     */
    public $TermsOfPayment;
    /**
     * Constructor method for ExportDeclaration
     * @uses ExportDeclaration::setDestinationPort()
     * @uses ExportDeclaration::setExporterCode()
     * @uses ExportDeclaration::setExporterID()
     * @uses ExportDeclaration::setExportLicense()
     * @uses ExportDeclaration::setExportLineItems()
     * @uses ExportDeclaration::setExportReason()
     * @uses ExportDeclaration::setImportLicense()
     * @uses ExportDeclaration::setInvoiceDate()
     * @uses ExportDeclaration::setInvoiceNumber()
     * @uses ExportDeclaration::setInvoiceDeclarationTexts()
     * @uses ExportDeclaration::setInvoiceSignatureDetails()
     * @uses ExportDeclaration::setOtherCharges()
     * @uses ExportDeclaration::setPackageMarks()
     * @uses ExportDeclaration::setPayerGSTVAT()
     * @uses ExportDeclaration::setRecipientReference()
     * @uses ExportDeclaration::setRemarks()
     * @uses ExportDeclaration::setTermsOfPayment()
     * @param string $destinationPort
     * @param string $exporterCode
     * @param string $exporterID
     * @param string $exportLicense
     * @param \App\Delivery\Dhl\StructType\ExportLineItems $exportLineItems
     * @param string $exportReason
     * @param string $importLicense
     * @param string $invoiceDate
     * @param string $invoiceNumber
     * @param \App\Delivery\Dhl\StructType\InvoiceDeclarationTexts $invoiceDeclarationTexts
     * @param \App\Delivery\Dhl\StructType\InvoiceSignatureDetails $invoiceSignatureDetails
     * @param \App\Delivery\Dhl\StructType\OtherCharges $otherCharges
     * @param string $packageMarks
     * @param string $payerGSTVAT
     * @param string $recipientReference
     * @param \App\Delivery\Dhl\StructType\Remarks $remarks
     * @param string $termsOfPayment
     */
    public function __construct($destinationPort = null, $exporterCode = null, $exporterID = null, $exportLicense = null, \App\Delivery\Dhl\StructType\ExportLineItems $exportLineItems = null, $exportReason = null, $importLicense = null, $invoiceDate = null, $invoiceNumber = null, \App\Delivery\Dhl\StructType\InvoiceDeclarationTexts $invoiceDeclarationTexts = null, \App\Delivery\Dhl\StructType\InvoiceSignatureDetails $invoiceSignatureDetails = null, \App\Delivery\Dhl\StructType\OtherCharges $otherCharges = null, $packageMarks = null, $payerGSTVAT = null, $recipientReference = null, \App\Delivery\Dhl\StructType\Remarks $remarks = null, $termsOfPayment = null)
    {
        $this
            ->setDestinationPort($destinationPort)
            ->setExporterCode($exporterCode)
            ->setExporterID($exporterID)
            ->setExportLicense($exportLicense)
            ->setExportLineItems($exportLineItems)
            ->setExportReason($exportReason)
            ->setImportLicense($importLicense)
            ->setInvoiceDate($invoiceDate)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceDeclarationTexts($invoiceDeclarationTexts)
            ->setInvoiceSignatureDetails($invoiceSignatureDetails)
            ->setOtherCharges($otherCharges)
            ->setPackageMarks($packageMarks)
            ->setPayerGSTVAT($payerGSTVAT)
            ->setRecipientReference($recipientReference)
            ->setRemarks($remarks)
            ->setTermsOfPayment($termsOfPayment);
    }
    /**
     * Get DestinationPort value
     * @return string|null
     */
    public function getDestinationPort()
    {
        return $this->DestinationPort;
    }
    /**
     * Set DestinationPort value
     * @param string $destinationPort
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setDestinationPort($destinationPort = null)
    {
        // validation for constraint: string
        if (!is_null($destinationPort) && !is_string($destinationPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationPort, true), gettype($destinationPort)), __LINE__);
        }
        $this->DestinationPort = $destinationPort;
        return $this;
    }
    /**
     * Get ExporterCode value
     * @return string|null
     */
    public function getExporterCode()
    {
        return $this->ExporterCode;
    }
    /**
     * Set ExporterCode value
     * @param string $exporterCode
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setExporterCode($exporterCode = null)
    {
        // validation for constraint: string
        if (!is_null($exporterCode) && !is_string($exporterCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exporterCode, true), gettype($exporterCode)), __LINE__);
        }
        $this->ExporterCode = $exporterCode;
        return $this;
    }
    /**
     * Get ExporterID value
     * @return string|null
     */
    public function getExporterID()
    {
        return $this->ExporterID;
    }
    /**
     * Set ExporterID value
     * @param string $exporterID
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setExporterID($exporterID = null)
    {
        // validation for constraint: string
        if (!is_null($exporterID) && !is_string($exporterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exporterID, true), gettype($exporterID)), __LINE__);
        }
        $this->ExporterID = $exporterID;
        return $this;
    }
    /**
     * Get ExportLicense value
     * @return string|null
     */
    public function getExportLicense()
    {
        return $this->ExportLicense;
    }
    /**
     * Set ExportLicense value
     * @param string $exportLicense
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setExportLicense($exportLicense = null)
    {
        // validation for constraint: string
        if (!is_null($exportLicense) && !is_string($exportLicense)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportLicense, true), gettype($exportLicense)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($exportLicense) && mb_strlen($exportLicense) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($exportLicense)), __LINE__);
        }
        $this->ExportLicense = $exportLicense;
        return $this;
    }
    /**
     * Get ExportLineItems value
     * @return \App\Delivery\Dhl\StructType\ExportLineItems|null
     */
    public function getExportLineItems()
    {
        return $this->ExportLineItems;
    }
    /**
     * Set ExportLineItems value
     * @param \App\Delivery\Dhl\StructType\ExportLineItems $exportLineItems
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setExportLineItems(\App\Delivery\Dhl\StructType\ExportLineItems $exportLineItems = null)
    {
        $this->ExportLineItems = $exportLineItems;
        return $this;
    }
    /**
     * Get ExportReason value
     * @return string|null
     */
    public function getExportReason()
    {
        return $this->ExportReason;
    }
    /**
     * Set ExportReason value
     * @param string $exportReason
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setExportReason($exportReason = null)
    {
        // validation for constraint: string
        if (!is_null($exportReason) && !is_string($exportReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportReason, true), gettype($exportReason)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($exportReason) && mb_strlen($exportReason) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($exportReason)), __LINE__);
        }
        $this->ExportReason = $exportReason;
        return $this;
    }
    /**
     * Get ImportLicense value
     * @return string|null
     */
    public function getImportLicense()
    {
        return $this->ImportLicense;
    }
    /**
     * Set ImportLicense value
     * @param string $importLicense
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setImportLicense($importLicense = null)
    {
        // validation for constraint: string
        if (!is_null($importLicense) && !is_string($importLicense)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importLicense, true), gettype($importLicense)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($importLicense) && mb_strlen($importLicense) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($importLicense)), __LINE__);
        }
        $this->ImportLicense = $importLicense;
        return $this;
    }
    /**
     * Get InvoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get InvoiceDeclarationTexts value
     * @return \App\Delivery\Dhl\StructType\InvoiceDeclarationTexts|null
     */
    public function getInvoiceDeclarationTexts()
    {
        return $this->InvoiceDeclarationTexts;
    }
    /**
     * Set InvoiceDeclarationTexts value
     * @param \App\Delivery\Dhl\StructType\InvoiceDeclarationTexts $invoiceDeclarationTexts
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setInvoiceDeclarationTexts(\App\Delivery\Dhl\StructType\InvoiceDeclarationTexts $invoiceDeclarationTexts = null)
    {
        $this->InvoiceDeclarationTexts = $invoiceDeclarationTexts;
        return $this;
    }
    /**
     * Get InvoiceSignatureDetails value
     * @return \App\Delivery\Dhl\StructType\InvoiceSignatureDetails|null
     */
    public function getInvoiceSignatureDetails()
    {
        return $this->InvoiceSignatureDetails;
    }
    /**
     * Set InvoiceSignatureDetails value
     * @param \App\Delivery\Dhl\StructType\InvoiceSignatureDetails $invoiceSignatureDetails
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setInvoiceSignatureDetails(\App\Delivery\Dhl\StructType\InvoiceSignatureDetails $invoiceSignatureDetails = null)
    {
        $this->InvoiceSignatureDetails = $invoiceSignatureDetails;
        return $this;
    }
    /**
     * Get OtherCharges value
     * @return \App\Delivery\Dhl\StructType\OtherCharges|null
     */
    public function getOtherCharges()
    {
        return $this->OtherCharges;
    }
    /**
     * Set OtherCharges value
     * @param \App\Delivery\Dhl\StructType\OtherCharges $otherCharges
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setOtherCharges(\App\Delivery\Dhl\StructType\OtherCharges $otherCharges = null)
    {
        $this->OtherCharges = $otherCharges;
        return $this;
    }
    /**
     * Get PackageMarks value
     * @return string|null
     */
    public function getPackageMarks()
    {
        return $this->PackageMarks;
    }
    /**
     * Set PackageMarks value
     * @param string $packageMarks
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setPackageMarks($packageMarks = null)
    {
        // validation for constraint: string
        if (!is_null($packageMarks) && !is_string($packageMarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageMarks, true), gettype($packageMarks)), __LINE__);
        }
        $this->PackageMarks = $packageMarks;
        return $this;
    }
    /**
     * Get PayerGSTVAT value
     * @return string|null
     */
    public function getPayerGSTVAT()
    {
        return $this->PayerGSTVAT;
    }
    /**
     * Set PayerGSTVAT value
     * @param string $payerGSTVAT
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setPayerGSTVAT($payerGSTVAT = null)
    {
        // validation for constraint: string
        if (!is_null($payerGSTVAT) && !is_string($payerGSTVAT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerGSTVAT, true), gettype($payerGSTVAT)), __LINE__);
        }
        $this->PayerGSTVAT = $payerGSTVAT;
        return $this;
    }
    /**
     * Get RecipientReference value
     * @return string|null
     */
    public function getRecipientReference()
    {
        return $this->RecipientReference;
    }
    /**
     * Set RecipientReference value
     * @param string $recipientReference
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setRecipientReference($recipientReference = null)
    {
        // validation for constraint: string
        if (!is_null($recipientReference) && !is_string($recipientReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipientReference, true), gettype($recipientReference)), __LINE__);
        }
        $this->RecipientReference = $recipientReference;
        return $this;
    }
    /**
     * Get Remarks value
     * @return \App\Delivery\Dhl\StructType\Remarks|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param \App\Delivery\Dhl\StructType\Remarks $remarks
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setRemarks(\App\Delivery\Dhl\StructType\Remarks $remarks = null)
    {
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get TermsOfPayment value
     * @return string|null
     */
    public function getTermsOfPayment()
    {
        return $this->TermsOfPayment;
    }
    /**
     * Set TermsOfPayment value
     * @param string $termsOfPayment
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setTermsOfPayment($termsOfPayment = null)
    {
        // validation for constraint: string
        if (!is_null($termsOfPayment) && !is_string($termsOfPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($termsOfPayment, true), gettype($termsOfPayment)), __LINE__);
        }
        $this->TermsOfPayment = $termsOfPayment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
