<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_DimensionsType StructType
 * @subpackage Structs
 */
class DocTypeRef_DimensionsType extends AbstractStructBase
{
    /**
     * The Length
     * Meta informations extracted from the WSDL
     * - documentation: Length of the piece listed
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - totalDigits: 7
     * - whiteSpace: collapse
     * @var float
     */
    public $Length;
    /**
     * The Width
     * Meta informations extracted from the WSDL
     * - documentation: Width of the piece listed
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - totalDigits: 7
     * - whiteSpace: collapse
     * @var float
     */
    public $Width;
    /**
     * The Height
     * Meta informations extracted from the WSDL
     * - documentation: Height of the piece listed
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - totalDigits: 7
     * - whiteSpace: collapse
     * @var float
     */
    public $Height;
    /**
     * Constructor method for docTypeRef_DimensionsType
     * @uses DocTypeRef_DimensionsType::setLength()
     * @uses DocTypeRef_DimensionsType::setWidth()
     * @uses DocTypeRef_DimensionsType::setHeight()
     * @param float $length
     * @param float $width
     * @param float $height
     */
    public function __construct($length = null, $width = null, $height = null)
    {
        $this
            ->setLength($length)
            ->setWidth($width)
            ->setHeight($height);
    }
    /**
     * Get Length value
     * @return float|null
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param float $length
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DimensionsType
     */
    public function setLength($length = null)
    {
        // validation for constraint: float
        if (!is_null($length) && !(is_float($length) || is_numeric($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($length) && mb_strlen(mb_substr($length, mb_strpos($length, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($length, true), mb_strlen(mb_substr($length, mb_strpos($length, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($length) && mb_strlen(preg_replace('/(\D)/', '', $length)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($length, true), mb_strlen(preg_replace('/(\D)/', '', $length))), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param float $width
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DimensionsType
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($width) && mb_strlen(mb_substr($width, mb_strpos($width, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($width, true), mb_strlen(mb_substr($width, mb_strpos($width, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($width) && mb_strlen(preg_replace('/(\D)/', '', $width)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($width, true), mb_strlen(preg_replace('/(\D)/', '', $width))), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param float $height
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DimensionsType
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($height) && mb_strlen(mb_substr($height, mb_strpos($height, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($height, true), mb_strlen(mb_substr($height, mb_strpos($height, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($height) && mb_strlen(preg_replace('/(\D)/', '', $height)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($height, true), mb_strlen(preg_replace('/(\D)/', '', $height))), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DimensionsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
