<?php

namespace App\Delivery\Dhl\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteShipmentRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_DeleteRequestType $parameters
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DeleteResponseType|bool
     */
    public function deleteShipmentRequest(\App\Delivery\Dhl\StructType\DocTypeRef_DeleteRequestType $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->deleteShipmentRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DeleteResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
