<?php

namespace App\Delivery\Dhl\EnumType;

/**
 * This class stands for MerchantSelectedCarrierName2 EnumType
 * @subpackage Enumerations
 */
class MerchantSelectedCarrierName2
{
    /**
     * Constant for value 'DHL'
     * @return string 'DHL'
     */
    const VALUE_DHL = 'DHL';
    /**
     * Constant for value 'UPS'
     * @return string 'UPS'
     */
    const VALUE_UPS = 'UPS';
    /**
     * Constant for value 'FEDEX'
     * @return string 'FEDEX'
     */
    const VALUE_FEDEX = 'FEDEX';
    /**
     * Constant for value 'TNT'
     * @return string 'TNT'
     */
    const VALUE_TNT = 'TNT';
    /**
     * Constant for value 'POST'
     * @return string 'POST'
     */
    const VALUE_POST = 'POST';
    /**
     * Constant for value 'OTHERS'
     * @return string 'OTHERS'
     */
    const VALUE_OTHERS = 'OTHERS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DHL
     * @uses self::VALUE_UPS
     * @uses self::VALUE_FEDEX
     * @uses self::VALUE_TNT
     * @uses self::VALUE_POST
     * @uses self::VALUE_OTHERS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DHL,
            self::VALUE_UPS,
            self::VALUE_FEDEX,
            self::VALUE_TNT,
            self::VALUE_POST,
            self::VALUE_OTHERS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
