<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_RequestedPackagesType2 StructType
 * @subpackage Structs
 */
class DocTypeRef_RequestedPackagesType2 extends AbstractStructBase
{
    /**
     * The Weight
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_WeightType
     */
    public $Weight;
    /**
     * The Dimensions
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_DimensionsType2
     */
    public $Dimensions;
    /**
     * The PackageTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Global package type. Please contact your DHL Express representative if you wish to use a DHL specific package otherwise ignore this element. You may refer to the developer guide for the valid values for PackageTypeCode
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 3
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $PackageTypeCode;
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - base: xsd:int
     * - maxInclusive: 999
     * - minInclusive: 1
     * - whiteSpace: collapse
     * @var int
     */
    public $number;
    /**
     * Constructor method for docTypeRef_RequestedPackagesType2
     * @uses DocTypeRef_RequestedPackagesType2::setWeight()
     * @uses DocTypeRef_RequestedPackagesType2::setDimensions()
     * @uses DocTypeRef_RequestedPackagesType2::setPackageTypeCode()
     * @uses DocTypeRef_RequestedPackagesType2::setNumber()
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_WeightType $weight
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_DimensionsType2 $dimensions
     * @param string $packageTypeCode
     * @param int $number
     */
    public function __construct(\App\Delivery\Dhl\StructType\DocTypeRef_WeightType $weight = null, \App\Delivery\Dhl\StructType\DocTypeRef_DimensionsType2 $dimensions = null, $packageTypeCode = null, $number = null)
    {
        $this
            ->setWeight($weight)
            ->setDimensions($dimensions)
            ->setPackageTypeCode($packageTypeCode)
            ->setNumber($number);
    }
    /**
     * Get Weight value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_WeightType|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_WeightType $weight
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedPackagesType2
     */
    public function setWeight(\App\Delivery\Dhl\StructType\DocTypeRef_WeightType $weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Dimensions value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DimensionsType2|null
     */
    public function getDimensions()
    {
        return $this->Dimensions;
    }
    /**
     * Set Dimensions value
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_DimensionsType2 $dimensions
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedPackagesType2
     */
    public function setDimensions(\App\Delivery\Dhl\StructType\DocTypeRef_DimensionsType2 $dimensions = null)
    {
        $this->Dimensions = $dimensions;
        return $this;
    }
    /**
     * Get PackageTypeCode value
     * @return string|null
     */
    public function getPackageTypeCode()
    {
        return $this->PackageTypeCode;
    }
    /**
     * Set PackageTypeCode value
     * @param string $packageTypeCode
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedPackagesType2
     */
    public function setPackageTypeCode($packageTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($packageTypeCode) && !is_string($packageTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageTypeCode, true), gettype($packageTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($packageTypeCode) && mb_strlen($packageTypeCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($packageTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($packageTypeCode) && mb_strlen($packageTypeCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($packageTypeCode)), __LINE__);
        }
        $this->PackageTypeCode = $packageTypeCode;
        return $this;
    }
    /**
     * Get number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param int $number
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedPackagesType2
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($number) && $number > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($number, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($number) && $number < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($number, true)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedPackagesType2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
