<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_NotificationType StructType
 * @subpackage Structs
 */
class DocTypeRef_NotificationType extends AbstractStructBase
{
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - whiteSpace: collapse
     * @var string
     */
    public $Message;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - base: xsd:nonNegativeInteger
     * - totalDigits: 6
     * - whiteSpace: collapse
     * @var int
     */
    public $code;
    /**
     * Constructor method for docTypeRef_NotificationType
     * @uses DocTypeRef_NotificationType::setMessage()
     * @uses DocTypeRef_NotificationType::setCode()
     * @param string $message
     * @param int $code
     */
    public function __construct($message = null, $code = null)
    {
        $this
            ->setMessage($message)
            ->setCode($code);
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_NotificationType
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param int $code
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_NotificationType
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($code) && mb_strlen(preg_replace('/(\D)/', '', $code)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($code, true), mb_strlen(preg_replace('/(\D)/', '', $code))), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_NotificationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
