<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_AddressType2 StructType
 * @subpackage Structs
 */
class DocTypeRef_AddressType2 extends AbstractStructBase
{
    /**
     * The StreetLines
     * Meta informations extracted from the WSDL
     * - documentation: The shipper/recipient's street address.
     * - base: xsd:token
     * - maxLength: 45
     * - minLength: 1
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $StreetLines;
    /**
     * The StreetLines2
     * Meta informations extracted from the WSDL
     * - documentation: Additional shipper/recipient address information, preferably room or floor.
     * - base: xsd:token
     * - maxLength: 45
     * - minLength: 1
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $StreetLines2;
    /**
     * The StreetLines3
     * Meta informations extracted from the WSDL
     * - documentation: Additional shipper address information, preferably department name.
     * - base: xsd:token
     * - maxLength: 45
     * - minLength: 1
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $StreetLines3;
    /**
     * The StreetName
     * Meta informations extracted from the WSDL
     * - documentation: The shipper/recipient's street name.
     * - base: xsd:token
     * - maxLength: 35
     * - minLength: 1
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $StreetName;
    /**
     * The StreetNumber
     * Meta informations extracted from the WSDL
     * - documentation: The shipper/recipient's street number.
     * - base: xsd:token
     * - maxLength: 15
     * - minLength: 1
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $StreetNumber;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - documentation: The shipper/recipient city name
     * - base: xsd:token
     * - maxLength: 45
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $City;
    /**
     * The CityDistrict
     * Meta informations extracted from the WSDL
     * - documentation: The shipper/recipient city district/county name
     * - base: xsd:token
     * - maxLength: 45
     * - minLength: 1
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $CityDistrict;
    /**
     * The StateOrProvinceCode
     * Meta informations extracted from the WSDL
     * - documentation: 2 letter state code for the USA only
     * - minOccurs: 0
     * @var string
     */
    public $StateOrProvinceCode;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - documentation: The shipper/recipient postal code
     * - base: xsd:token
     * - maxLength: 12
     * - minLength: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $PostalCode;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - base: s1:CountryCode2
     * - maxLength: 2
     * - minLength: 2
     * - whiteSpace: collapse
     * @var string
     */
    public $CountryCode;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_ContactType
     */
    public $Contact;
    /**
     * Constructor method for docTypeRef_AddressType2
     * @uses DocTypeRef_AddressType2::setStreetLines()
     * @uses DocTypeRef_AddressType2::setStreetLines2()
     * @uses DocTypeRef_AddressType2::setStreetLines3()
     * @uses DocTypeRef_AddressType2::setStreetName()
     * @uses DocTypeRef_AddressType2::setStreetNumber()
     * @uses DocTypeRef_AddressType2::setCity()
     * @uses DocTypeRef_AddressType2::setCityDistrict()
     * @uses DocTypeRef_AddressType2::setStateOrProvinceCode()
     * @uses DocTypeRef_AddressType2::setPostalCode()
     * @uses DocTypeRef_AddressType2::setCountryCode()
     * @uses DocTypeRef_AddressType2::setContact()
     * @param string $streetLines
     * @param string $streetLines2
     * @param string $streetLines3
     * @param string $streetName
     * @param string $streetNumber
     * @param string $city
     * @param string $cityDistrict
     * @param string $stateOrProvinceCode
     * @param string $postalCode
     * @param string $countryCode
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_ContactType $contact
     */
    public function __construct($streetLines = null, $streetLines2 = null, $streetLines3 = null, $streetName = null, $streetNumber = null, $city = null, $cityDistrict = null, $stateOrProvinceCode = null, $postalCode = null, $countryCode = null, \App\Delivery\Dhl\StructType\DocTypeRef_ContactType $contact = null)
    {
        $this
            ->setStreetLines($streetLines)
            ->setStreetLines2($streetLines2)
            ->setStreetLines3($streetLines3)
            ->setStreetName($streetName)
            ->setStreetNumber($streetNumber)
            ->setCity($city)
            ->setCityDistrict($cityDistrict)
            ->setStateOrProvinceCode($stateOrProvinceCode)
            ->setPostalCode($postalCode)
            ->setCountryCode($countryCode)
            ->setContact($contact);
    }
    /**
     * Get StreetLines value
     * @return string|null
     */
    public function getStreetLines()
    {
        return $this->StreetLines;
    }
    /**
     * Set StreetLines value
     * @param string $streetLines
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_AddressType2
     */
    public function setStreetLines($streetLines = null)
    {
        // validation for constraint: string
        if (!is_null($streetLines) && !is_string($streetLines)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetLines, true), gettype($streetLines)), __LINE__);
        }
        // validation for constraint: maxLength(45)
        if (!is_null($streetLines) && mb_strlen($streetLines) > 45) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 45', mb_strlen($streetLines)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($streetLines) && mb_strlen($streetLines) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($streetLines)), __LINE__);
        }
        $this->StreetLines = $streetLines;
        return $this;
    }
    /**
     * Get StreetLines2 value
     * @return string|null
     */
    public function getStreetLines2()
    {
        return $this->StreetLines2;
    }
    /**
     * Set StreetLines2 value
     * @param string $streetLines2
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_AddressType2
     */
    public function setStreetLines2($streetLines2 = null)
    {
        // validation for constraint: string
        if (!is_null($streetLines2) && !is_string($streetLines2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetLines2, true), gettype($streetLines2)), __LINE__);
        }
        // validation for constraint: maxLength(45)
        if (!is_null($streetLines2) && mb_strlen($streetLines2) > 45) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 45', mb_strlen($streetLines2)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($streetLines2) && mb_strlen($streetLines2) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($streetLines2)), __LINE__);
        }
        $this->StreetLines2 = $streetLines2;
        return $this;
    }
    /**
     * Get StreetLines3 value
     * @return string|null
     */
    public function getStreetLines3()
    {
        return $this->StreetLines3;
    }
    /**
     * Set StreetLines3 value
     * @param string $streetLines3
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_AddressType2
     */
    public function setStreetLines3($streetLines3 = null)
    {
        // validation for constraint: string
        if (!is_null($streetLines3) && !is_string($streetLines3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetLines3, true), gettype($streetLines3)), __LINE__);
        }
        // validation for constraint: maxLength(45)
        if (!is_null($streetLines3) && mb_strlen($streetLines3) > 45) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 45', mb_strlen($streetLines3)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($streetLines3) && mb_strlen($streetLines3) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($streetLines3)), __LINE__);
        }
        $this->StreetLines3 = $streetLines3;
        return $this;
    }
    /**
     * Get StreetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->StreetName;
    }
    /**
     * Set StreetName value
     * @param string $streetName
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_AddressType2
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetName, true), gettype($streetName)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($streetName) && mb_strlen($streetName) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($streetName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($streetName) && mb_strlen($streetName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($streetName)), __LINE__);
        }
        $this->StreetName = $streetName;
        return $this;
    }
    /**
     * Get StreetNumber value
     * @return string|null
     */
    public function getStreetNumber()
    {
        return $this->StreetNumber;
    }
    /**
     * Set StreetNumber value
     * @param string $streetNumber
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_AddressType2
     */
    public function setStreetNumber($streetNumber = null)
    {
        // validation for constraint: string
        if (!is_null($streetNumber) && !is_string($streetNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetNumber, true), gettype($streetNumber)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($streetNumber) && mb_strlen($streetNumber) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($streetNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($streetNumber) && mb_strlen($streetNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($streetNumber)), __LINE__);
        }
        $this->StreetNumber = $streetNumber;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_AddressType2
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(45)
        if (!is_null($city) && mb_strlen($city) > 45) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 45', mb_strlen($city)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($city) && mb_strlen($city) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get CityDistrict value
     * @return string|null
     */
    public function getCityDistrict()
    {
        return $this->CityDistrict;
    }
    /**
     * Set CityDistrict value
     * @param string $cityDistrict
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_AddressType2
     */
    public function setCityDistrict($cityDistrict = null)
    {
        // validation for constraint: string
        if (!is_null($cityDistrict) && !is_string($cityDistrict)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityDistrict, true), gettype($cityDistrict)), __LINE__);
        }
        // validation for constraint: maxLength(45)
        if (!is_null($cityDistrict) && mb_strlen($cityDistrict) > 45) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 45', mb_strlen($cityDistrict)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($cityDistrict) && mb_strlen($cityDistrict) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($cityDistrict)), __LINE__);
        }
        $this->CityDistrict = $cityDistrict;
        return $this;
    }
    /**
     * Get StateOrProvinceCode value
     * @return string|null
     */
    public function getStateOrProvinceCode()
    {
        return $this->StateOrProvinceCode;
    }
    /**
     * Set StateOrProvinceCode value
     * @param string $stateOrProvinceCode
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_AddressType2
     */
    public function setStateOrProvinceCode($stateOrProvinceCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateOrProvinceCode) && !is_string($stateOrProvinceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateOrProvinceCode, true), gettype($stateOrProvinceCode)), __LINE__);
        }
        $this->StateOrProvinceCode = $stateOrProvinceCode;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_AddressType2
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($postalCode) && mb_strlen($postalCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($postalCode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($postalCode) && mb_strlen($postalCode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_AddressType2
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($countryCode) && mb_strlen($countryCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($countryCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($countryCode) && mb_strlen($countryCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get Contact value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ContactType|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_ContactType $contact
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_AddressType2
     */
    public function setContact(\App\Delivery\Dhl\StructType\DocTypeRef_ContactType $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_AddressType2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
