<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_ShipmentInfoType StructType
 * @subpackage Structs
 */
class DocTypeRef_ShipmentInfoType extends AbstractStructBase
{
    /**
     * The DropOffType
     * @var string
     */
    public $DropOffType;
    /**
     * The ServiceType
     * Meta informations extracted from the WSDL
     * - documentation: The shipping product requested for this shipment, corresponding to the DHL Global Product codes. | Optional DHL service - global code
     * @var string
     */
    public $ServiceType;
    /**
     * The LocalServiceType
     * Meta informations extracted from the WSDL
     * - documentation: DHL “local / country specific” Product Code used to ship the items. Important when shipping domestic products – please consult your DHL Express IT consultant if needed. | Local Product Code | Optional DHL local product code
     * - minOccurs: 0
     * @var string
     */
    public $LocalServiceType;
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - documentation: The customer account to be used as payer in the request. If the 'Account' tag is used then there is no need to populate the Billing section further down below in this table as the 'Account' tag will override any other accounts
     * entered.
     * - base: xsd:string
     * - maxLength: 12
     * - minLength: 0
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $Account;
    /**
     * The Billing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\Billing
     */
    public $Billing;
    /**
     * The SpecialServices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\Services
     */
    public $SpecialServices;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - documentation: The currency of the monetary values presented in the request.
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 3
     * - whiteSpace: collapse
     * @var string
     */
    public $Currency;
    /**
     * The UnitOfMeasurement
     * Meta informations extracted from the WSDL
     * - documentation: SI=the preferred system of weights and measures for Italian trade and commerce; SU=the preferred system of weights and measures for U.S. trade and commerce; Weight unit: if Type is SI it can be KG (kilograms), if Type is SU it can be
     * LB (pounds). Dimention unit: if Type is SI it can be CM, if Type is SU it can be IN (inch)
     * @var string
     */
    public $UnitOfMeasurement;
    /**
     * The ShipmentIdentificationNumber
     * Meta informations extracted from the WSDL
     * - documentation: The shipment identification number does not need to be transmitted in the request as the operation will assign a new number and return it in the response. Only used when UseOwnShipmentdentificationNumber set to Y and this feature
     * enabled within customer profile.
     * - base: xsd:token
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $ShipmentIdentificationNumber;
    /**
     * The UseOwnShipmentIdentificationNumber
     * Meta informations extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $UseOwnShipmentIdentificationNumber;
    /**
     * The LabelType
     * Meta informations extracted from the WSDL
     * - documentation: The label type used in the operation. Valid enumeration; PDF ZPL EPL LP2
     * - minOccurs: 0
     * @var string
     */
    public $LabelType;
    /**
     * The LabelTemplate
     * Meta informations extracted from the WSDL
     * - documentation: Any valid DHL Express label template (please contact your DHL Express IT representative for a list of labels) – If this node is left blank then the default DHL ecommerce label template will be used. Possible values;
     * ECOM26_84_A4_001 (default) ECOM26_84_001 ECOM_TC_A4 ECOM26_A6_002 ECOM26_84CI_001 ECOM_A4_RU_002 ECOM26_A6_002 ECOM26_84CI_002 ECOM26_84CI_003
     * - base: xsd:token
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $LabelTemplate;
    /**
     * The ArchiveLabelTemplate
     * Meta informations extracted from the WSDL
     * - documentation: Any valid DHL Express archive label template (please contact your DHL Express IT representative for a list of labels) – If this node is left blank then the default DHL ecommerce label template will be used. Possible values;
     * ARCH_8X4_A4_002 ARCH_8X4 ARCH_6X4 ARCH_A4_RU_002
     * - base: xsd:token
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $ArchiveLabelTemplate;
    /**
     * The CustomsInvoiceTemplate
     * Meta informations extracted from the WSDL
     * - documentation: Custom invoice template name. Possible values; COMMERCIAL_INVOICE_03
     * - base: xsd:token
     * - maxLength: 25
     * - minOccurs: 0
     * @var string
     */
    public $CustomsInvoiceTemplate;
    /**
     * The ShipmentReceiptTemplate
     * Meta informations extracted from the WSDL
     * - documentation: Shipment receipt template name. Possible value; SHIP_RECPT_A4_RU_002
     * - base: xsd:token
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentReceiptTemplate;
    /**
     * The PaperlessTradeEnabled
     * Meta informations extracted from the WSDL
     * - documentation: Possible values (case sensitive): - true - false - 0 - 1
     * - minOccurs: 0
     * @var bool
     */
    public $PaperlessTradeEnabled;
    /**
     * The PaperlessTradeImage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaperlessTradeImage;
    /**
     * The DocumentImages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\DocumentImages
     */
    public $DocumentImages;
    /**
     * The LabelOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\LabelOptions
     */
    public $LabelOptions;
    /**
     * The ShipmentReferences
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\ShipmentReferences
     */
    public $ShipmentReferences;
    /**
     * The ParentShipmentIdentificationNumber
     * Meta informations extracted from the WSDL
     * - documentation: Parent (Mother) Shipment ID number used for Break Bulk Shipments (BBX)
     * - base: xsd:token
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $ParentShipmentIdentificationNumber;
    /**
     * The RequestTransliterateResponse
     * Meta informations extracted from the WSDL
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $RequestTransliterateResponse;
    /**
     * The RequestAdditionalInformation
     * Meta informations extracted from the WSDL
     * - documentation: This field is to have additional information in the shipment response. The default value is N, the response message will return as per request message. No additional field is included
     * - default: N
     * - minOccurs: 0
     * @var string
     */
    public $RequestAdditionalInformation;
    /**
     * Constructor method for docTypeRef_ShipmentInfoType
     * @uses DocTypeRef_ShipmentInfoType::setDropOffType()
     * @uses DocTypeRef_ShipmentInfoType::setServiceType()
     * @uses DocTypeRef_ShipmentInfoType::setLocalServiceType()
     * @uses DocTypeRef_ShipmentInfoType::setAccount()
     * @uses DocTypeRef_ShipmentInfoType::setBilling()
     * @uses DocTypeRef_ShipmentInfoType::setSpecialServices()
     * @uses DocTypeRef_ShipmentInfoType::setCurrency()
     * @uses DocTypeRef_ShipmentInfoType::setUnitOfMeasurement()
     * @uses DocTypeRef_ShipmentInfoType::setShipmentIdentificationNumber()
     * @uses DocTypeRef_ShipmentInfoType::setUseOwnShipmentIdentificationNumber()
     * @uses DocTypeRef_ShipmentInfoType::setLabelType()
     * @uses DocTypeRef_ShipmentInfoType::setLabelTemplate()
     * @uses DocTypeRef_ShipmentInfoType::setArchiveLabelTemplate()
     * @uses DocTypeRef_ShipmentInfoType::setCustomsInvoiceTemplate()
     * @uses DocTypeRef_ShipmentInfoType::setShipmentReceiptTemplate()
     * @uses DocTypeRef_ShipmentInfoType::setPaperlessTradeEnabled()
     * @uses DocTypeRef_ShipmentInfoType::setPaperlessTradeImage()
     * @uses DocTypeRef_ShipmentInfoType::setDocumentImages()
     * @uses DocTypeRef_ShipmentInfoType::setLabelOptions()
     * @uses DocTypeRef_ShipmentInfoType::setShipmentReferences()
     * @uses DocTypeRef_ShipmentInfoType::setParentShipmentIdentificationNumber()
     * @uses DocTypeRef_ShipmentInfoType::setRequestTransliterateResponse()
     * @uses DocTypeRef_ShipmentInfoType::setRequestAdditionalInformation()
     * @param string $dropOffType
     * @param string $serviceType
     * @param string $localServiceType
     * @param string $account
     * @param \App\Delivery\Dhl\StructType\Billing $billing
     * @param \App\Delivery\Dhl\StructType\Services $specialServices
     * @param string $currency
     * @param string $unitOfMeasurement
     * @param string $shipmentIdentificationNumber
     * @param string $useOwnShipmentIdentificationNumber
     * @param string $labelType
     * @param string $labelTemplate
     * @param string $archiveLabelTemplate
     * @param string $customsInvoiceTemplate
     * @param string $shipmentReceiptTemplate
     * @param bool $paperlessTradeEnabled
     * @param string $paperlessTradeImage
     * @param \App\Delivery\Dhl\StructType\DocumentImages $documentImages
     * @param \App\Delivery\Dhl\StructType\LabelOptions $labelOptions
     * @param \App\Delivery\Dhl\StructType\ShipmentReferences $shipmentReferences
     * @param string $parentShipmentIdentificationNumber
     * @param string $requestTransliterateResponse
     * @param string $requestAdditionalInformation
     */
    public function __construct($dropOffType = null, $serviceType = null, $localServiceType = null, $account = null, \App\Delivery\Dhl\StructType\Billing $billing = null, \App\Delivery\Dhl\StructType\Services $specialServices = null, $currency = null, $unitOfMeasurement = null, $shipmentIdentificationNumber = null, $useOwnShipmentIdentificationNumber = 'N', $labelType = null, $labelTemplate = null, $archiveLabelTemplate = null, $customsInvoiceTemplate = null, $shipmentReceiptTemplate = null, $paperlessTradeEnabled = null, $paperlessTradeImage = null, \App\Delivery\Dhl\StructType\DocumentImages $documentImages = null, \App\Delivery\Dhl\StructType\LabelOptions $labelOptions = null, \App\Delivery\Dhl\StructType\ShipmentReferences $shipmentReferences = null, $parentShipmentIdentificationNumber = null, $requestTransliterateResponse = 'N', $requestAdditionalInformation = 'N')
    {
        $this
            ->setDropOffType($dropOffType)
            ->setServiceType($serviceType)
            ->setLocalServiceType($localServiceType)
            ->setAccount($account)
            ->setBilling($billing)
            ->setSpecialServices($specialServices)
            ->setCurrency($currency)
            ->setUnitOfMeasurement($unitOfMeasurement)
            ->setShipmentIdentificationNumber($shipmentIdentificationNumber)
            ->setUseOwnShipmentIdentificationNumber($useOwnShipmentIdentificationNumber)
            ->setLabelType($labelType)
            ->setLabelTemplate($labelTemplate)
            ->setArchiveLabelTemplate($archiveLabelTemplate)
            ->setCustomsInvoiceTemplate($customsInvoiceTemplate)
            ->setShipmentReceiptTemplate($shipmentReceiptTemplate)
            ->setPaperlessTradeEnabled($paperlessTradeEnabled)
            ->setPaperlessTradeImage($paperlessTradeImage)
            ->setDocumentImages($documentImages)
            ->setLabelOptions($labelOptions)
            ->setShipmentReferences($shipmentReferences)
            ->setParentShipmentIdentificationNumber($parentShipmentIdentificationNumber)
            ->setRequestTransliterateResponse($requestTransliterateResponse)
            ->setRequestAdditionalInformation($requestAdditionalInformation);
    }
    /**
     * Get DropOffType value
     * @return string|null
     */
    public function getDropOffType()
    {
        return $this->DropOffType;
    }
    /**
     * Set DropOffType value
     * @uses \App\Delivery\Dhl\EnumType\DropOffType::valueIsValid()
     * @uses \App\Delivery\Dhl\EnumType\DropOffType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dropOffType
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setDropOffType($dropOffType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Delivery\Dhl\EnumType\DropOffType::valueIsValid($dropOffType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Delivery\Dhl\EnumType\DropOffType', is_array($dropOffType) ? implode(', ', $dropOffType) : var_export($dropOffType, true), implode(', ', \App\Delivery\Dhl\EnumType\DropOffType::getValidValues())), __LINE__);
        }
        $this->DropOffType = $dropOffType;
        return $this;
    }
    /**
     * Get ServiceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @param string $serviceType
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceType, true), gettype($serviceType)), __LINE__);
        }
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Get LocalServiceType value
     * @return string|null
     */
    public function getLocalServiceType()
    {
        return $this->LocalServiceType;
    }
    /**
     * Set LocalServiceType value
     * @param string $localServiceType
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setLocalServiceType($localServiceType = null)
    {
        // validation for constraint: string
        if (!is_null($localServiceType) && !is_string($localServiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localServiceType, true), gettype($localServiceType)), __LINE__);
        }
        $this->LocalServiceType = $localServiceType;
        return $this;
    }
    /**
     * Get Account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param string $account
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account, true), gettype($account)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($account) && mb_strlen($account) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($account)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($account) && mb_strlen($account) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($account)), __LINE__);
        }
        $this->Account = $account;
        return $this;
    }
    /**
     * Get Billing value
     * @return \App\Delivery\Dhl\StructType\Billing|null
     */
    public function getBilling()
    {
        return $this->Billing;
    }
    /**
     * Set Billing value
     * @param \App\Delivery\Dhl\StructType\Billing $billing
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setBilling(\App\Delivery\Dhl\StructType\Billing $billing = null)
    {
        $this->Billing = $billing;
        return $this;
    }
    /**
     * Get SpecialServices value
     * @return \App\Delivery\Dhl\StructType\Services|null
     */
    public function getSpecialServices()
    {
        return $this->SpecialServices;
    }
    /**
     * Set SpecialServices value
     * @param \App\Delivery\Dhl\StructType\Services $specialServices
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setSpecialServices(\App\Delivery\Dhl\StructType\Services $specialServices = null)
    {
        $this->SpecialServices = $specialServices;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($currency) && mb_strlen($currency) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($currency)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($currency) && mb_strlen($currency) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get UnitOfMeasurement value
     * @return string|null
     */
    public function getUnitOfMeasurement()
    {
        return $this->UnitOfMeasurement;
    }
    /**
     * Set UnitOfMeasurement value
     * @uses \App\Delivery\Dhl\EnumType\UnitOfMeasurement::valueIsValid()
     * @uses \App\Delivery\Dhl\EnumType\UnitOfMeasurement::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unitOfMeasurement
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setUnitOfMeasurement($unitOfMeasurement = null)
    {
        // validation for constraint: enumeration
        if (!\App\Delivery\Dhl\EnumType\UnitOfMeasurement::valueIsValid($unitOfMeasurement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Delivery\Dhl\EnumType\UnitOfMeasurement', is_array($unitOfMeasurement) ? implode(', ', $unitOfMeasurement) : var_export($unitOfMeasurement, true), implode(', ', \App\Delivery\Dhl\EnumType\UnitOfMeasurement::getValidValues())), __LINE__);
        }
        $this->UnitOfMeasurement = $unitOfMeasurement;
        return $this;
    }
    /**
     * Get ShipmentIdentificationNumber value
     * @return string|null
     */
    public function getShipmentIdentificationNumber()
    {
        return $this->ShipmentIdentificationNumber;
    }
    /**
     * Set ShipmentIdentificationNumber value
     * @param string $shipmentIdentificationNumber
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setShipmentIdentificationNumber($shipmentIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentIdentificationNumber) && !is_string($shipmentIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentIdentificationNumber, true), gettype($shipmentIdentificationNumber)), __LINE__);
        }
        $this->ShipmentIdentificationNumber = $shipmentIdentificationNumber;
        return $this;
    }
    /**
     * Get UseOwnShipmentIdentificationNumber value
     * @return string|null
     */
    public function getUseOwnShipmentIdentificationNumber()
    {
        return $this->UseOwnShipmentIdentificationNumber;
    }
    /**
     * Set UseOwnShipmentIdentificationNumber value
     * @uses \App\Delivery\Dhl\EnumType\UseOwnShipmentIdentificationNumber::valueIsValid()
     * @uses \App\Delivery\Dhl\EnumType\UseOwnShipmentIdentificationNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useOwnShipmentIdentificationNumber
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setUseOwnShipmentIdentificationNumber($useOwnShipmentIdentificationNumber = 'N')
    {
        // validation for constraint: enumeration
        if (!\App\Delivery\Dhl\EnumType\UseOwnShipmentIdentificationNumber::valueIsValid($useOwnShipmentIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Delivery\Dhl\EnumType\UseOwnShipmentIdentificationNumber', is_array($useOwnShipmentIdentificationNumber) ? implode(', ', $useOwnShipmentIdentificationNumber) : var_export($useOwnShipmentIdentificationNumber, true), implode(', ', \App\Delivery\Dhl\EnumType\UseOwnShipmentIdentificationNumber::getValidValues())), __LINE__);
        }
        $this->UseOwnShipmentIdentificationNumber = $useOwnShipmentIdentificationNumber;
        return $this;
    }
    /**
     * Get LabelType value
     * @return string|null
     */
    public function getLabelType()
    {
        return $this->LabelType;
    }
    /**
     * Set LabelType value
     * @uses \App\Delivery\Dhl\EnumType\LabelType::valueIsValid()
     * @uses \App\Delivery\Dhl\EnumType\LabelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $labelType
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setLabelType($labelType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Delivery\Dhl\EnumType\LabelType::valueIsValid($labelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Delivery\Dhl\EnumType\LabelType', is_array($labelType) ? implode(', ', $labelType) : var_export($labelType, true), implode(', ', \App\Delivery\Dhl\EnumType\LabelType::getValidValues())), __LINE__);
        }
        $this->LabelType = $labelType;
        return $this;
    }
    /**
     * Get LabelTemplate value
     * @return string|null
     */
    public function getLabelTemplate()
    {
        return $this->LabelTemplate;
    }
    /**
     * Set LabelTemplate value
     * @param string $labelTemplate
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setLabelTemplate($labelTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($labelTemplate) && !is_string($labelTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelTemplate, true), gettype($labelTemplate)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($labelTemplate) && mb_strlen($labelTemplate) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($labelTemplate)), __LINE__);
        }
        $this->LabelTemplate = $labelTemplate;
        return $this;
    }
    /**
     * Get ArchiveLabelTemplate value
     * @return string|null
     */
    public function getArchiveLabelTemplate()
    {
        return $this->ArchiveLabelTemplate;
    }
    /**
     * Set ArchiveLabelTemplate value
     * @param string $archiveLabelTemplate
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setArchiveLabelTemplate($archiveLabelTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($archiveLabelTemplate) && !is_string($archiveLabelTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($archiveLabelTemplate, true), gettype($archiveLabelTemplate)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($archiveLabelTemplate) && mb_strlen($archiveLabelTemplate) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($archiveLabelTemplate)), __LINE__);
        }
        $this->ArchiveLabelTemplate = $archiveLabelTemplate;
        return $this;
    }
    /**
     * Get CustomsInvoiceTemplate value
     * @return string|null
     */
    public function getCustomsInvoiceTemplate()
    {
        return $this->CustomsInvoiceTemplate;
    }
    /**
     * Set CustomsInvoiceTemplate value
     * @param string $customsInvoiceTemplate
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setCustomsInvoiceTemplate($customsInvoiceTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($customsInvoiceTemplate) && !is_string($customsInvoiceTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsInvoiceTemplate, true), gettype($customsInvoiceTemplate)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($customsInvoiceTemplate) && mb_strlen($customsInvoiceTemplate) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($customsInvoiceTemplate)), __LINE__);
        }
        $this->CustomsInvoiceTemplate = $customsInvoiceTemplate;
        return $this;
    }
    /**
     * Get ShipmentReceiptTemplate value
     * @return string|null
     */
    public function getShipmentReceiptTemplate()
    {
        return $this->ShipmentReceiptTemplate;
    }
    /**
     * Set ShipmentReceiptTemplate value
     * @param string $shipmentReceiptTemplate
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setShipmentReceiptTemplate($shipmentReceiptTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentReceiptTemplate) && !is_string($shipmentReceiptTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentReceiptTemplate, true), gettype($shipmentReceiptTemplate)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($shipmentReceiptTemplate) && mb_strlen($shipmentReceiptTemplate) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($shipmentReceiptTemplate)), __LINE__);
        }
        $this->ShipmentReceiptTemplate = $shipmentReceiptTemplate;
        return $this;
    }
    /**
     * Get PaperlessTradeEnabled value
     * @return bool|null
     */
    public function getPaperlessTradeEnabled()
    {
        return $this->PaperlessTradeEnabled;
    }
    /**
     * Set PaperlessTradeEnabled value
     * @param bool $paperlessTradeEnabled
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setPaperlessTradeEnabled($paperlessTradeEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($paperlessTradeEnabled) && !is_bool($paperlessTradeEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paperlessTradeEnabled, true), gettype($paperlessTradeEnabled)), __LINE__);
        }
        $this->PaperlessTradeEnabled = $paperlessTradeEnabled;
        return $this;
    }
    /**
     * Get PaperlessTradeImage value
     * @return string|null
     */
    public function getPaperlessTradeImage()
    {
        return $this->PaperlessTradeImage;
    }
    /**
     * Set PaperlessTradeImage value
     * @param string $paperlessTradeImage
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setPaperlessTradeImage($paperlessTradeImage = null)
    {
        // validation for constraint: string
        if (!is_null($paperlessTradeImage) && !is_string($paperlessTradeImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paperlessTradeImage, true), gettype($paperlessTradeImage)), __LINE__);
        }
        $this->PaperlessTradeImage = $paperlessTradeImage;
        return $this;
    }
    /**
     * Get DocumentImages value
     * @return \App\Delivery\Dhl\StructType\DocumentImages|null
     */
    public function getDocumentImages()
    {
        return $this->DocumentImages;
    }
    /**
     * Set DocumentImages value
     * @param \App\Delivery\Dhl\StructType\DocumentImages $documentImages
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setDocumentImages(\App\Delivery\Dhl\StructType\DocumentImages $documentImages = null)
    {
        $this->DocumentImages = $documentImages;
        return $this;
    }
    /**
     * Get LabelOptions value
     * @return \App\Delivery\Dhl\StructType\LabelOptions|null
     */
    public function getLabelOptions()
    {
        return $this->LabelOptions;
    }
    /**
     * Set LabelOptions value
     * @param \App\Delivery\Dhl\StructType\LabelOptions $labelOptions
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setLabelOptions(\App\Delivery\Dhl\StructType\LabelOptions $labelOptions = null)
    {
        $this->LabelOptions = $labelOptions;
        return $this;
    }
    /**
     * Get ShipmentReferences value
     * @return \App\Delivery\Dhl\StructType\ShipmentReferences|null
     */
    public function getShipmentReferences()
    {
        return $this->ShipmentReferences;
    }
    /**
     * Set ShipmentReferences value
     * @param \App\Delivery\Dhl\StructType\ShipmentReferences $shipmentReferences
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setShipmentReferences(\App\Delivery\Dhl\StructType\ShipmentReferences $shipmentReferences = null)
    {
        $this->ShipmentReferences = $shipmentReferences;
        return $this;
    }
    /**
     * Get ParentShipmentIdentificationNumber value
     * @return string|null
     */
    public function getParentShipmentIdentificationNumber()
    {
        return $this->ParentShipmentIdentificationNumber;
    }
    /**
     * Set ParentShipmentIdentificationNumber value
     * @param string $parentShipmentIdentificationNumber
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setParentShipmentIdentificationNumber($parentShipmentIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($parentShipmentIdentificationNumber) && !is_string($parentShipmentIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentShipmentIdentificationNumber, true), gettype($parentShipmentIdentificationNumber)), __LINE__);
        }
        $this->ParentShipmentIdentificationNumber = $parentShipmentIdentificationNumber;
        return $this;
    }
    /**
     * Get RequestTransliterateResponse value
     * @return string|null
     */
    public function getRequestTransliterateResponse()
    {
        return $this->RequestTransliterateResponse;
    }
    /**
     * Set RequestTransliterateResponse value
     * @uses \App\Delivery\Dhl\EnumType\RequestTransliterateResponse::valueIsValid()
     * @uses \App\Delivery\Dhl\EnumType\RequestTransliterateResponse::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestTransliterateResponse
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setRequestTransliterateResponse($requestTransliterateResponse = 'N')
    {
        // validation for constraint: enumeration
        if (!\App\Delivery\Dhl\EnumType\RequestTransliterateResponse::valueIsValid($requestTransliterateResponse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Delivery\Dhl\EnumType\RequestTransliterateResponse', is_array($requestTransliterateResponse) ? implode(', ', $requestTransliterateResponse) : var_export($requestTransliterateResponse, true), implode(', ', \App\Delivery\Dhl\EnumType\RequestTransliterateResponse::getValidValues())), __LINE__);
        }
        $this->RequestTransliterateResponse = $requestTransliterateResponse;
        return $this;
    }
    /**
     * Get RequestAdditionalInformation value
     * @return string|null
     */
    public function getRequestAdditionalInformation()
    {
        return $this->RequestAdditionalInformation;
    }
    /**
     * Set RequestAdditionalInformation value
     * @uses \App\Delivery\Dhl\EnumType\RequestAdditionalInformation::valueIsValid()
     * @uses \App\Delivery\Dhl\EnumType\RequestAdditionalInformation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestAdditionalInformation
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public function setRequestAdditionalInformation($requestAdditionalInformation = 'N')
    {
        // validation for constraint: enumeration
        if (!\App\Delivery\Dhl\EnumType\RequestAdditionalInformation::valueIsValid($requestAdditionalInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Delivery\Dhl\EnumType\RequestAdditionalInformation', is_array($requestAdditionalInformation) ? implode(', ', $requestAdditionalInformation) : var_export($requestAdditionalInformation, true), implode(', ', \App\Delivery\Dhl\EnumType\RequestAdditionalInformation::getValidValues())), __LINE__);
        }
        $this->RequestAdditionalInformation = $requestAdditionalInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
