<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_ProcessShipmentRequestType StructType
 * @subpackage Structs
 */
class DocTypeRef_ProcessShipmentRequestType extends AbstractStructBase
{
    /**
     * The MessageId
     * Meta informations extracted from the WSDL
     * - documentation: logging end to end token
     * - base: xsd:string
     * - maxLength: 200
     * - minOccurs: 0
     * @var string
     */
    public $MessageId;
    /**
     * The Request
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\Request
     */
    public $Request;
    /**
     * The ClientDetail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_ClientDetailType2
     */
    public $ClientDetail;
    /**
     * The RequestedShipment
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType
     */
    public $RequestedShipment;
    /**
     * Constructor method for docTypeRef_ProcessShipmentRequestType
     * @uses DocTypeRef_ProcessShipmentRequestType::setMessageId()
     * @uses DocTypeRef_ProcessShipmentRequestType::setRequest()
     * @uses DocTypeRef_ProcessShipmentRequestType::setClientDetail()
     * @uses DocTypeRef_ProcessShipmentRequestType::setRequestedShipment()
     * @param string $messageId
     * @param \App\Delivery\Dhl\StructType\Request $request
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_ClientDetailType2 $clientDetail
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType $requestedShipment
     */
    public function __construct($messageId = null, \App\Delivery\Dhl\StructType\Request $request = null, \App\Delivery\Dhl\StructType\DocTypeRef_ClientDetailType2 $clientDetail = null, \App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType $requestedShipment = null)
    {
        $this
            ->setMessageId($messageId)
            ->setRequest($request)
            ->setClientDetail($clientDetail)
            ->setRequestedShipment($requestedShipment);
    }
    /**
     * Get MessageId value
     * @return string|null
     */
    public function getMessageId()
    {
        return $this->MessageId;
    }
    /**
     * Set MessageId value
     * @param string $messageId
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ProcessShipmentRequestType
     */
    public function setMessageId($messageId = null)
    {
        // validation for constraint: string
        if (!is_null($messageId) && !is_string($messageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageId, true), gettype($messageId)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($messageId) && mb_strlen($messageId) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($messageId)), __LINE__);
        }
        $this->MessageId = $messageId;
        return $this;
    }
    /**
     * Get Request value
     * @return \App\Delivery\Dhl\StructType\Request|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \App\Delivery\Dhl\StructType\Request $request
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ProcessShipmentRequestType
     */
    public function setRequest(\App\Delivery\Dhl\StructType\Request $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get ClientDetail value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ClientDetailType2|null
     */
    public function getClientDetail()
    {
        return $this->ClientDetail;
    }
    /**
     * Set ClientDetail value
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_ClientDetailType2 $clientDetail
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ProcessShipmentRequestType
     */
    public function setClientDetail(\App\Delivery\Dhl\StructType\DocTypeRef_ClientDetailType2 $clientDetail = null)
    {
        $this->ClientDetail = $clientDetail;
        return $this;
    }
    /**
     * Get RequestedShipment value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType|null
     */
    public function getRequestedShipment()
    {
        return $this->RequestedShipment;
    }
    /**
     * Set RequestedShipment value
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType $requestedShipment
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ProcessShipmentRequestType
     */
    public function setRequestedShipment(\App\Delivery\Dhl\StructType\DocTypeRef_RequestedShipmentType $requestedShipment = null)
    {
        $this->RequestedShipment = $requestedShipment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ProcessShipmentRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
