<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_ClientDetailType3 StructType
 * @subpackage Structs
 */
class DocTypeRef_ClientDetailType3 extends AbstractStructBase
{
    /**
     * The sso
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - minLength: 0
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $sso;
    /**
     * The plant
     * Meta informations extracted from the WSDL
     * - base: xsd:token
     * - minLength: 0
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $plant;
    /**
     * Constructor method for docTypeRef_ClientDetailType3
     * @uses DocTypeRef_ClientDetailType3::setSso()
     * @uses DocTypeRef_ClientDetailType3::setPlant()
     * @param string $sso
     * @param string $plant
     */
    public function __construct($sso = null, $plant = null)
    {
        $this
            ->setSso($sso)
            ->setPlant($plant);
    }
    /**
     * Get sso value
     * @return string|null
     */
    public function getSso()
    {
        return $this->sso;
    }
    /**
     * Set sso value
     * @param string $sso
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ClientDetailType3
     */
    public function setSso($sso = null)
    {
        // validation for constraint: string
        if (!is_null($sso) && !is_string($sso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sso, true), gettype($sso)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($sso) && mb_strlen($sso) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($sso)), __LINE__);
        }
        $this->sso = $sso;
        return $this;
    }
    /**
     * Get plant value
     * @return string|null
     */
    public function getPlant()
    {
        return $this->plant;
    }
    /**
     * Set plant value
     * @param string $plant
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ClientDetailType3
     */
    public function setPlant($plant = null)
    {
        // validation for constraint: string
        if (!is_null($plant) && !is_string($plant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plant, true), gettype($plant)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($plant) && mb_strlen($plant) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($plant)), __LINE__);
        }
        $this->plant = $plant;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ClientDetailType3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
