<?php

namespace App\Delivery\Dhl\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getRateRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_RateRequestType $parameters
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RateResponseType|bool
     */
    public function getRateRequest(\App\Delivery\Dhl\StructType\DocTypeRef_RateRequestType $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getRateRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_RateResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
