<?php

namespace App\Delivery\Dhl\EnumType;

/**
 * This class stands for ShipmentTransportationMode2 EnumType
 * @subpackage Enumerations
 */
class ShipmentTransportationMode2
{
    /**
     * Constant for value 'AIR'
     * @return string 'AIR'
     */
    const VALUE_AIR = 'AIR';
    /**
     * Constant for value 'OCEAN'
     * @return string 'OCEAN'
     */
    const VALUE_OCEAN = 'OCEAN';
    /**
     * Constant for value 'GROUND'
     * @return string 'GROUND'
     */
    const VALUE_GROUND = 'GROUND';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AIR
     * @uses self::VALUE_OCEAN
     * @uses self::VALUE_GROUND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AIR,
            self::VALUE_OCEAN,
            self::VALUE_GROUND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
