<?php

namespace App\Delivery\Dhl\EnumType;

/**
 * This class stands for LabelType EnumType
 * @subpackage Enumerations
 */
class LabelType
{
    /**
     * Constant for value 'PDF'
     * @return string 'PDF'
     */
    const VALUE_PDF = 'PDF';
    /**
     * Constant for value 'ZPL'
     * @return string 'ZPL'
     */
    const VALUE_ZPL = 'ZPL';
    /**
     * Constant for value 'EPL'
     * @return string 'EPL'
     */
    const VALUE_EPL = 'EPL';
    /**
     * Constant for value 'LP2'
     * @return string 'LP2'
     */
    const VALUE_LP_2 = 'LP2';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PDF
     * @uses self::VALUE_ZPL
     * @uses self::VALUE_EPL
     * @uses self::VALUE_LP_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PDF,
            self::VALUE_ZPL,
            self::VALUE_EPL,
            self::VALUE_LP_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
