<?php

namespace App\Delivery\Dhl\EnumType;

/**
 * This class stands for ChargeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Amount type code. Possible values: 1) FREIGHT 2) ADDITIONAL_CHARGE 3) INSURANCE
 * @subpackage Enumerations
 */
class ChargeType
{
    /**
     * Constant for value 'FREIGHT'
     * @return string 'FREIGHT'
     */
    const VALUE_FREIGHT = 'FREIGHT';
    /**
     * Constant for value 'ADDITIONAL_CHARGE'
     * @return string 'ADDITIONAL_CHARGE'
     */
    const VALUE_ADDITIONAL_CHARGE = 'ADDITIONAL_CHARGE';
    /**
     * Constant for value 'INSURANCE'
     * @return string 'INSURANCE'
     */
    const VALUE_INSURANCE = 'INSURANCE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FREIGHT
     * @uses self::VALUE_ADDITIONAL_CHARGE
     * @uses self::VALUE_INSURANCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FREIGHT,
            self::VALUE_ADDITIONAL_CHARGE,
            self::VALUE_INSURANCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
