<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_ShipmentDetailType StructType
 * @subpackage Structs
 */
class DocTypeRef_ShipmentDetailType extends AbstractStructBase
{
    /**
     * The Response
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_Response
     */
    public $Response;
    /**
     * The Notification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 999
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_NotificationType2[]
     */
    public $Notification;
    /**
     * The Warning
     * Meta informations extracted from the WSDL
     * - maxOccurs: 999
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_WarningType[]
     */
    public $Warning;
    /**
     * The PackagesResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_PackagesResultsType
     */
    public $PackagesResult;
    /**
     * The LabelImage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2000
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_LabelImageType[]
     */
    public $LabelImage;
    /**
     * The Documents
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_Documents
     */
    public $Documents;
    /**
     * The ShipmentIdentificationNumber
     * Meta informations extracted from the WSDL
     * - documentation: The shipment identification number also named airwaybill (AWB). This number can be used to track the progress of the shipment on the DHL webside.
     * - base: xsd:token
     * - maxLength: 35
     * - minLength: 10
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $ShipmentIdentificationNumber;
    /**
     * The DispatchConfirmationNumber
     * Meta informations extracted from the WSDL
     * - documentation: The booking reference number. This number should be used when interacting with the DHL customer service regarding the pickup process.
     * - minOccurs: 0
     * @var string
     */
    public $DispatchConfirmationNumber;
    /**
     * The OnDemandDeliveryURL
     * Meta informations extracted from the WSDL
     * - documentation: The On Demand Delivery (ODD) URL link
     * - minOccurs: 0
     * @var string
     */
    public $OnDemandDeliveryURL;
    /**
     * The TotalNet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_TotalNet[]
     */
    public $TotalNet;
    /**
     * The AdditionalInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\AdditionalInformation
     */
    public $AdditionalInformation;
    /**
     * Constructor method for docTypeRef_ShipmentDetailType
     * @uses DocTypeRef_ShipmentDetailType::setResponse()
     * @uses DocTypeRef_ShipmentDetailType::setNotification()
     * @uses DocTypeRef_ShipmentDetailType::setWarning()
     * @uses DocTypeRef_ShipmentDetailType::setPackagesResult()
     * @uses DocTypeRef_ShipmentDetailType::setLabelImage()
     * @uses DocTypeRef_ShipmentDetailType::setDocuments()
     * @uses DocTypeRef_ShipmentDetailType::setShipmentIdentificationNumber()
     * @uses DocTypeRef_ShipmentDetailType::setDispatchConfirmationNumber()
     * @uses DocTypeRef_ShipmentDetailType::setOnDemandDeliveryURL()
     * @uses DocTypeRef_ShipmentDetailType::setTotalNet()
     * @uses DocTypeRef_ShipmentDetailType::setAdditionalInformation()
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_Response $response
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_NotificationType2[] $notification
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_WarningType[] $warning
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_PackagesResultsType $packagesResult
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_LabelImageType[] $labelImage
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_Documents $documents
     * @param string $shipmentIdentificationNumber
     * @param string $dispatchConfirmationNumber
     * @param string $onDemandDeliveryURL
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_TotalNet[] $totalNet
     * @param \App\Delivery\Dhl\StructType\AdditionalInformation $additionalInformation
     */
    public function __construct(\App\Delivery\Dhl\StructType\DocTypeRef_Response $response = null, array $notification = array(), array $warning = array(), \App\Delivery\Dhl\StructType\DocTypeRef_PackagesResultsType $packagesResult = null, array $labelImage = array(), \App\Delivery\Dhl\StructType\DocTypeRef_Documents $documents = null, $shipmentIdentificationNumber = null, $dispatchConfirmationNumber = null, $onDemandDeliveryURL = null, array $totalNet = array(), \App\Delivery\Dhl\StructType\AdditionalInformation $additionalInformation = null)
    {
        $this
            ->setResponse($response)
            ->setNotification($notification)
            ->setWarning($warning)
            ->setPackagesResult($packagesResult)
            ->setLabelImage($labelImage)
            ->setDocuments($documents)
            ->setShipmentIdentificationNumber($shipmentIdentificationNumber)
            ->setDispatchConfirmationNumber($dispatchConfirmationNumber)
            ->setOnDemandDeliveryURL($onDemandDeliveryURL)
            ->setTotalNet($totalNet)
            ->setAdditionalInformation($additionalInformation);
    }
    /**
     * Get Response value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_Response|null
     */
    public function getResponse()
    {
        return $this->Response;
    }
    /**
     * Set Response value
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_Response $response
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentDetailType
     */
    public function setResponse(\App\Delivery\Dhl\StructType\DocTypeRef_Response $response = null)
    {
        $this->Response = $response;
        return $this;
    }
    /**
     * Get Notification value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_NotificationType2[]|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }
    /**
     * This method is responsible for validating the values passed to the setNotification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotificationForArrayConstraintsFromSetNotification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docTypeRef_ShipmentDetailTypeNotificationItem) {
            // validation for constraint: itemType
            if (!$docTypeRef_ShipmentDetailTypeNotificationItem instanceof \App\Delivery\Dhl\StructType\DocTypeRef_NotificationType2) {
                $invalidValues[] = is_object($docTypeRef_ShipmentDetailTypeNotificationItem) ? get_class($docTypeRef_ShipmentDetailTypeNotificationItem) : sprintf('%s(%s)', gettype($docTypeRef_ShipmentDetailTypeNotificationItem), var_export($docTypeRef_ShipmentDetailTypeNotificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Notification property can only contain items of type \App\Delivery\Dhl\StructType\DocTypeRef_NotificationType2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Notification value
     * @throws \InvalidArgumentException
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_NotificationType2[] $notification
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentDetailType
     */
    public function setNotification(array $notification = array())
    {
        // validation for constraint: array
        if ('' !== ($notificationArrayErrorMessage = self::validateNotificationForArrayConstraintsFromSetNotification($notification))) {
            throw new \InvalidArgumentException($notificationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($notification) && count($notification) > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 999', count($notification)), __LINE__);
        }
        $this->Notification = $notification;
        return $this;
    }
    /**
     * Add item to Notification value
     * @throws \InvalidArgumentException
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_NotificationType2 $item
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentDetailType
     */
    public function addToNotification(\App\Delivery\Dhl\StructType\DocTypeRef_NotificationType2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Delivery\Dhl\StructType\DocTypeRef_NotificationType2) {
            throw new \InvalidArgumentException(sprintf('The Notification property can only contain items of type \App\Delivery\Dhl\StructType\DocTypeRef_NotificationType2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($this->Notification) && count($this->Notification) >= 999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 999', count($this->Notification)), __LINE__);
        }
        $this->Notification[] = $item;
        return $this;
    }
    /**
     * Get Warning value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_WarningType[]|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * This method is responsible for validating the values passed to the setWarning method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarning method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningForArrayConstraintsFromSetWarning(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docTypeRef_ShipmentDetailTypeWarningItem) {
            // validation for constraint: itemType
            if (!$docTypeRef_ShipmentDetailTypeWarningItem instanceof \App\Delivery\Dhl\StructType\DocTypeRef_WarningType) {
                $invalidValues[] = is_object($docTypeRef_ShipmentDetailTypeWarningItem) ? get_class($docTypeRef_ShipmentDetailTypeWarningItem) : sprintf('%s(%s)', gettype($docTypeRef_ShipmentDetailTypeWarningItem), var_export($docTypeRef_ShipmentDetailTypeWarningItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Warning property can only contain items of type \App\Delivery\Dhl\StructType\DocTypeRef_WarningType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Warning value
     * @throws \InvalidArgumentException
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_WarningType[] $warning
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentDetailType
     */
    public function setWarning(array $warning = array())
    {
        // validation for constraint: array
        if ('' !== ($warningArrayErrorMessage = self::validateWarningForArrayConstraintsFromSetWarning($warning))) {
            throw new \InvalidArgumentException($warningArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($warning) && count($warning) > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 999', count($warning)), __LINE__);
        }
        $this->Warning = $warning;
        return $this;
    }
    /**
     * Add item to Warning value
     * @throws \InvalidArgumentException
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_WarningType $item
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentDetailType
     */
    public function addToWarning(\App\Delivery\Dhl\StructType\DocTypeRef_WarningType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Delivery\Dhl\StructType\DocTypeRef_WarningType) {
            throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of type \App\Delivery\Dhl\StructType\DocTypeRef_WarningType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(999)
        if (is_array($this->Warning) && count($this->Warning) >= 999) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 999', count($this->Warning)), __LINE__);
        }
        $this->Warning[] = $item;
        return $this;
    }
    /**
     * Get PackagesResult value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_PackagesResultsType|null
     */
    public function getPackagesResult()
    {
        return $this->PackagesResult;
    }
    /**
     * Set PackagesResult value
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_PackagesResultsType $packagesResult
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentDetailType
     */
    public function setPackagesResult(\App\Delivery\Dhl\StructType\DocTypeRef_PackagesResultsType $packagesResult = null)
    {
        $this->PackagesResult = $packagesResult;
        return $this;
    }
    /**
     * Get LabelImage value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_LabelImageType[]|null
     */
    public function getLabelImage()
    {
        return $this->LabelImage;
    }
    /**
     * This method is responsible for validating the values passed to the setLabelImage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLabelImage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLabelImageForArrayConstraintsFromSetLabelImage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docTypeRef_ShipmentDetailTypeLabelImageItem) {
            // validation for constraint: itemType
            if (!$docTypeRef_ShipmentDetailTypeLabelImageItem instanceof \App\Delivery\Dhl\StructType\DocTypeRef_LabelImageType) {
                $invalidValues[] = is_object($docTypeRef_ShipmentDetailTypeLabelImageItem) ? get_class($docTypeRef_ShipmentDetailTypeLabelImageItem) : sprintf('%s(%s)', gettype($docTypeRef_ShipmentDetailTypeLabelImageItem), var_export($docTypeRef_ShipmentDetailTypeLabelImageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LabelImage property can only contain items of type \App\Delivery\Dhl\StructType\DocTypeRef_LabelImageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LabelImage value
     * @throws \InvalidArgumentException
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_LabelImageType[] $labelImage
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentDetailType
     */
    public function setLabelImage(array $labelImage = array())
    {
        // validation for constraint: array
        if ('' !== ($labelImageArrayErrorMessage = self::validateLabelImageForArrayConstraintsFromSetLabelImage($labelImage))) {
            throw new \InvalidArgumentException($labelImageArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2000)
        if (is_array($labelImage) && count($labelImage) > 2000) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2000', count($labelImage)), __LINE__);
        }
        $this->LabelImage = $labelImage;
        return $this;
    }
    /**
     * Add item to LabelImage value
     * @throws \InvalidArgumentException
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_LabelImageType $item
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentDetailType
     */
    public function addToLabelImage(\App\Delivery\Dhl\StructType\DocTypeRef_LabelImageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Delivery\Dhl\StructType\DocTypeRef_LabelImageType) {
            throw new \InvalidArgumentException(sprintf('The LabelImage property can only contain items of type \App\Delivery\Dhl\StructType\DocTypeRef_LabelImageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2000)
        if (is_array($this->LabelImage) && count($this->LabelImage) >= 2000) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2000', count($this->LabelImage)), __LINE__);
        }
        $this->LabelImage[] = $item;
        return $this;
    }
    /**
     * Get Documents value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_Documents|null
     */
    public function getDocuments()
    {
        return $this->Documents;
    }
    /**
     * Set Documents value
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_Documents $documents
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentDetailType
     */
    public function setDocuments(\App\Delivery\Dhl\StructType\DocTypeRef_Documents $documents = null)
    {
        $this->Documents = $documents;
        return $this;
    }
    /**
     * Get ShipmentIdentificationNumber value
     * @return string|null
     */
    public function getShipmentIdentificationNumber()
    {
        return $this->ShipmentIdentificationNumber;
    }
    /**
     * Set ShipmentIdentificationNumber value
     * @param string $shipmentIdentificationNumber
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentDetailType
     */
    public function setShipmentIdentificationNumber($shipmentIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentIdentificationNumber) && !is_string($shipmentIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentIdentificationNumber, true), gettype($shipmentIdentificationNumber)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($shipmentIdentificationNumber) && mb_strlen($shipmentIdentificationNumber) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($shipmentIdentificationNumber)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($shipmentIdentificationNumber) && mb_strlen($shipmentIdentificationNumber) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($shipmentIdentificationNumber)), __LINE__);
        }
        $this->ShipmentIdentificationNumber = $shipmentIdentificationNumber;
        return $this;
    }
    /**
     * Get DispatchConfirmationNumber value
     * @return string|null
     */
    public function getDispatchConfirmationNumber()
    {
        return $this->DispatchConfirmationNumber;
    }
    /**
     * Set DispatchConfirmationNumber value
     * @param string $dispatchConfirmationNumber
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentDetailType
     */
    public function setDispatchConfirmationNumber($dispatchConfirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($dispatchConfirmationNumber) && !is_string($dispatchConfirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dispatchConfirmationNumber, true), gettype($dispatchConfirmationNumber)), __LINE__);
        }
        $this->DispatchConfirmationNumber = $dispatchConfirmationNumber;
        return $this;
    }
    /**
     * Get OnDemandDeliveryURL value
     * @return string|null
     */
    public function getOnDemandDeliveryURL()
    {
        return $this->OnDemandDeliveryURL;
    }
    /**
     * Set OnDemandDeliveryURL value
     * @param string $onDemandDeliveryURL
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentDetailType
     */
    public function setOnDemandDeliveryURL($onDemandDeliveryURL = null)
    {
        // validation for constraint: string
        if (!is_null($onDemandDeliveryURL) && !is_string($onDemandDeliveryURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onDemandDeliveryURL, true), gettype($onDemandDeliveryURL)), __LINE__);
        }
        $this->OnDemandDeliveryURL = $onDemandDeliveryURL;
        return $this;
    }
    /**
     * Get TotalNet value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_TotalNet[]|null
     */
    public function getTotalNet()
    {
        return $this->TotalNet;
    }
    /**
     * This method is responsible for validating the values passed to the setTotalNet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTotalNet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTotalNetForArrayConstraintsFromSetTotalNet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docTypeRef_ShipmentDetailTypeTotalNetItem) {
            // validation for constraint: itemType
            if (!$docTypeRef_ShipmentDetailTypeTotalNetItem instanceof \App\Delivery\Dhl\StructType\DocTypeRef_TotalNet) {
                $invalidValues[] = is_object($docTypeRef_ShipmentDetailTypeTotalNetItem) ? get_class($docTypeRef_ShipmentDetailTypeTotalNetItem) : sprintf('%s(%s)', gettype($docTypeRef_ShipmentDetailTypeTotalNetItem), var_export($docTypeRef_ShipmentDetailTypeTotalNetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TotalNet property can only contain items of type \App\Delivery\Dhl\StructType\DocTypeRef_TotalNet, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TotalNet value
     * @throws \InvalidArgumentException
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_TotalNet[] $totalNet
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentDetailType
     */
    public function setTotalNet(array $totalNet = array())
    {
        // validation for constraint: array
        if ('' !== ($totalNetArrayErrorMessage = self::validateTotalNetForArrayConstraintsFromSetTotalNet($totalNet))) {
            throw new \InvalidArgumentException($totalNetArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($totalNet) && count($totalNet) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($totalNet)), __LINE__);
        }
        $this->TotalNet = $totalNet;
        return $this;
    }
    /**
     * Add item to TotalNet value
     * @throws \InvalidArgumentException
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_TotalNet $item
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentDetailType
     */
    public function addToTotalNet(\App\Delivery\Dhl\StructType\DocTypeRef_TotalNet $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Delivery\Dhl\StructType\DocTypeRef_TotalNet) {
            throw new \InvalidArgumentException(sprintf('The TotalNet property can only contain items of type \App\Delivery\Dhl\StructType\DocTypeRef_TotalNet, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->TotalNet) && count($this->TotalNet) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->TotalNet)), __LINE__);
        }
        $this->TotalNet[] = $item;
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * @return \App\Delivery\Dhl\StructType\AdditionalInformation|null
     */
    public function getAdditionalInformation()
    {
        return $this->AdditionalInformation;
    }
    /**
     * Set AdditionalInformation value
     * @param \App\Delivery\Dhl\StructType\AdditionalInformation $additionalInformation
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentDetailType
     */
    public function setAdditionalInformation(\App\Delivery\Dhl\StructType\AdditionalInformation $additionalInformation = null)
    {
        $this->AdditionalInformation = $additionalInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_ShipmentDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
