<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_InternationDetailType StructType
 * @subpackage Structs
 */
class DocTypeRef_InternationDetailType extends AbstractStructBase
{
    /**
     * The Commodities
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_CommoditiesType
     */
    public $Commodities;
    /**
     * The Content
     * Meta information extracted from the WSDL
     * - documentation: Details whether a shipment is non-dutiable (value DOCUMENTS) or dutiable (NON_DOCUMENTS)
     * - minOccurs: 0
     * @var string
     */
    public $Content;
    /**
     * The ExportDeclaration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public $ExportDeclaration;
    /**
     * Constructor method for docTypeRef_InternationDetailType
     * @uses DocTypeRef_InternationDetailType::setCommodities()
     * @uses DocTypeRef_InternationDetailType::setContent()
     * @uses DocTypeRef_InternationDetailType::setExportDeclaration()
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_CommoditiesType $commodities
     * @param string $content
     * @param \App\Delivery\Dhl\StructType\ExportDeclaration $exportDeclaration
     */
    public function __construct(\App\Delivery\Dhl\StructType\DocTypeRef_CommoditiesType $commodities = null, $content = null, \App\Delivery\Dhl\StructType\ExportDeclaration $exportDeclaration = null)
    {
        $this
            ->setCommodities($commodities)
            ->setContent($content)
            ->setExportDeclaration($exportDeclaration);
    }
    /**
     * Get Commodities value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_CommoditiesType|null
     */
    public function getCommodities()
    {
        return $this->Commodities;
    }
    /**
     * Set Commodities value
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_CommoditiesType $commodities
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_InternationDetailType
     */
    public function setCommodities(\App\Delivery\Dhl\StructType\DocTypeRef_CommoditiesType $commodities = null)
    {
        $this->Commodities = $commodities;
        return $this;
    }
    /**
     * Get Content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @uses \App\Delivery\Dhl\EnumType\Content::valueIsValid()
     * @uses \App\Delivery\Dhl\EnumType\Content::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $content
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_InternationDetailType
     */
    public function setContent($content = null)
    {
        // validation for constraint: enumeration
        if (!\App\Delivery\Dhl\EnumType\Content::valueIsValid($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Delivery\Dhl\EnumType\Content', is_array($content) ? implode(', ', $content) : var_export($content, true), implode(', ', \App\Delivery\Dhl\EnumType\Content::getValidValues())), __LINE__);
        }
        $this->Content = $content;
        return $this;
    }
    /**
     * Get ExportDeclaration value
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration|null
     */
    public function getExportDeclaration()
    {
        return $this->ExportDeclaration;
    }
    /**
     * Set ExportDeclaration value
     * @param \App\Delivery\Dhl\StructType\ExportDeclaration $exportDeclaration
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_InternationDetailType
     */
    public function setExportDeclaration(\App\Delivery\Dhl\StructType\ExportDeclaration $exportDeclaration = null)
    {
        $this->ExportDeclaration = $exportDeclaration;
        return $this;
    }
}
