<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceIndicativeCustomsValues StructType
 * Meta information extracted from the WSDL
 * - documentation: Customs Invoice Indicative Customs Values
 * @subpackage Structs
 */
class InvoiceIndicativeCustomsValues extends AbstractStructBase
{
    /**
     * The ImportCustomsDutyValue
     * Meta information extracted from the WSDL
     * - documentation: Customs Invoice Indicative Customs Duty value. Note: Value must be equal or greater than 0 (zero) to be provided in this field.
     * - base: xsd:decimal
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var float
     */
    public $ImportCustomsDutyValue;
    /**
     * The ImportTaxesValue
     * Meta information extracted from the WSDL
     * - documentation: Customs Invoice Indicative Import Taxes value. Note: Value must be equal or greater than 0 (zero) to be provided in this field.
     * - base: xsd:decimal
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var float
     */
    public $ImportTaxesValue;
    /**
     * The TotalWithImportDutiesAndTaxes
     * Meta information extracted from the WSDL
     * - documentation: Customer pre-calculated Total invoice amount calculated as sum of all line item subtotal plus other charges plus ImportCustomsDutyValue plus ImportTaxesValue.
     * - base: xsd:decimal
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var float
     */
    public $TotalWithImportDutiesAndTaxes;
    /**
     * Constructor method for InvoiceIndicativeCustomsValues
     * @uses InvoiceIndicativeCustomsValues::setImportCustomsDutyValue()
     * @uses InvoiceIndicativeCustomsValues::setImportTaxesValue()
     * @uses InvoiceIndicativeCustomsValues::setTotalWithImportDutiesAndTaxes()
     * @param float $importCustomsDutyValue
     * @param float $importTaxesValue
     * @param float $totalWithImportDutiesAndTaxes
     */
    public function __construct($importCustomsDutyValue = null, $importTaxesValue = null, $totalWithImportDutiesAndTaxes = null)
    {
        $this
            ->setImportCustomsDutyValue($importCustomsDutyValue)
            ->setImportTaxesValue($importTaxesValue)
            ->setTotalWithImportDutiesAndTaxes($totalWithImportDutiesAndTaxes);
    }
    /**
     * Get ImportCustomsDutyValue value
     * @return float|null
     */
    public function getImportCustomsDutyValue()
    {
        return $this->ImportCustomsDutyValue;
    }
    /**
     * Set ImportCustomsDutyValue value
     * @param float $importCustomsDutyValue
     * @return \App\Delivery\Dhl\StructType\InvoiceIndicativeCustomsValues
     */
    public function setImportCustomsDutyValue($importCustomsDutyValue = null)
    {
        // validation for constraint: float
        if (!is_null($importCustomsDutyValue) && !(is_float($importCustomsDutyValue) || is_numeric($importCustomsDutyValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importCustomsDutyValue, true), gettype($importCustomsDutyValue)), __LINE__);
        }
        $this->ImportCustomsDutyValue = $importCustomsDutyValue;
        return $this;
    }
    /**
     * Get ImportTaxesValue value
     * @return float|null
     */
    public function getImportTaxesValue()
    {
        return $this->ImportTaxesValue;
    }
    /**
     * Set ImportTaxesValue value
     * @param float $importTaxesValue
     * @return \App\Delivery\Dhl\StructType\InvoiceIndicativeCustomsValues
     */
    public function setImportTaxesValue($importTaxesValue = null)
    {
        // validation for constraint: float
        if (!is_null($importTaxesValue) && !(is_float($importTaxesValue) || is_numeric($importTaxesValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($importTaxesValue, true), gettype($importTaxesValue)), __LINE__);
        }
        $this->ImportTaxesValue = $importTaxesValue;
        return $this;
    }
    /**
     * Get TotalWithImportDutiesAndTaxes value
     * @return float|null
     */
    public function getTotalWithImportDutiesAndTaxes()
    {
        return $this->TotalWithImportDutiesAndTaxes;
    }
    /**
     * Set TotalWithImportDutiesAndTaxes value
     * @param float $totalWithImportDutiesAndTaxes
     * @return \App\Delivery\Dhl\StructType\InvoiceIndicativeCustomsValues
     */
    public function setTotalWithImportDutiesAndTaxes($totalWithImportDutiesAndTaxes = null)
    {
        // validation for constraint: float
        if (!is_null($totalWithImportDutiesAndTaxes) && !(is_float($totalWithImportDutiesAndTaxes) || is_numeric($totalWithImportDutiesAndTaxes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalWithImportDutiesAndTaxes, true), gettype($totalWithImportDutiesAndTaxes)), __LINE__);
        }
        $this->TotalWithImportDutiesAndTaxes = $totalWithImportDutiesAndTaxes;
        return $this;
    }
}
