<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_DependencyRuleGroup StructType
 * @subpackage Structs
 */
class DocTypeRef_DependencyRuleGroup extends AbstractStructBase
{
    /**
     * The DependencyRuleGroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DependencyRuleGroupName;
    /**
     * The DependencyRuleDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DependencyRuleDescription;
    /**
     * The RequiredChargeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var string[]
     */
    public $RequiredChargeCode;
    /**
     * Constructor method for docTypeRef_DependencyRuleGroup
     * @uses DocTypeRef_DependencyRuleGroup::setDependencyRuleGroupName()
     * @uses DocTypeRef_DependencyRuleGroup::setDependencyRuleDescription()
     * @uses DocTypeRef_DependencyRuleGroup::setRequiredChargeCode()
     * @param string $dependencyRuleGroupName
     * @param string $dependencyRuleDescription
     * @param string[] $requiredChargeCode
     */
    public function __construct($dependencyRuleGroupName = null, $dependencyRuleDescription = null, array $requiredChargeCode = array())
    {
        $this
            ->setDependencyRuleGroupName($dependencyRuleGroupName)
            ->setDependencyRuleDescription($dependencyRuleDescription)
            ->setRequiredChargeCode($requiredChargeCode);
    }
    /**
     * Get DependencyRuleGroupName value
     * @return string|null
     */
    public function getDependencyRuleGroupName()
    {
        return $this->DependencyRuleGroupName;
    }
    /**
     * Set DependencyRuleGroupName value
     * @param string $dependencyRuleGroupName
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DependencyRuleGroup
     */
    public function setDependencyRuleGroupName($dependencyRuleGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($dependencyRuleGroupName) && !is_string($dependencyRuleGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dependencyRuleGroupName, true), gettype($dependencyRuleGroupName)), __LINE__);
        }
        $this->DependencyRuleGroupName = $dependencyRuleGroupName;
        return $this;
    }
    /**
     * Get DependencyRuleDescription value
     * @return string|null
     */
    public function getDependencyRuleDescription()
    {
        return $this->DependencyRuleDescription;
    }
    /**
     * Set DependencyRuleDescription value
     * @param string $dependencyRuleDescription
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DependencyRuleGroup
     */
    public function setDependencyRuleDescription($dependencyRuleDescription = null)
    {
        // validation for constraint: string
        if (!is_null($dependencyRuleDescription) && !is_string($dependencyRuleDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dependencyRuleDescription, true), gettype($dependencyRuleDescription)), __LINE__);
        }
        $this->DependencyRuleDescription = $dependencyRuleDescription;
        return $this;
    }
    /**
     * Get RequiredChargeCode value
     * @return string[]|null
     */
    public function getRequiredChargeCode()
    {
        return $this->RequiredChargeCode;
    }
    /**
     * This method is responsible for validating the values passed to the setRequiredChargeCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequiredChargeCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequiredChargeCodeForArrayConstraintsFromSetRequiredChargeCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docTypeRef_DependencyRuleGroupRequiredChargeCodeItem) {
            // validation for constraint: itemType
            if (!is_string($docTypeRef_DependencyRuleGroupRequiredChargeCodeItem)) {
                $invalidValues[] = is_object($docTypeRef_DependencyRuleGroupRequiredChargeCodeItem) ? get_class($docTypeRef_DependencyRuleGroupRequiredChargeCodeItem) : sprintf('%s(%s)', gettype($docTypeRef_DependencyRuleGroupRequiredChargeCodeItem), var_export($docTypeRef_DependencyRuleGroupRequiredChargeCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RequiredChargeCode property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RequiredChargeCode value
     * @throws \InvalidArgumentException
     * @param string[] $requiredChargeCode
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DependencyRuleGroup
     */
    public function setRequiredChargeCode(array $requiredChargeCode = array())
    {
        // validation for constraint: array
        if ('' !== ($requiredChargeCodeArrayErrorMessage = self::validateRequiredChargeCodeForArrayConstraintsFromSetRequiredChargeCode($requiredChargeCode))) {
            throw new \InvalidArgumentException($requiredChargeCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($requiredChargeCode) && count($requiredChargeCode) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($requiredChargeCode)), __LINE__);
        }
        $this->RequiredChargeCode = $requiredChargeCode;
        return $this;
    }
    /**
     * Add item to RequiredChargeCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DependencyRuleGroup
     */
    public function addToRequiredChargeCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The RequiredChargeCode property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->RequiredChargeCode) && count($this->RequiredChargeCode) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->RequiredChargeCode)), __LINE__);
        }
        $this->RequiredChargeCode[] = $item;
        return $this;
    }
}
