<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PreCalculatedTotalValues StructType
 * Meta information extracted from the WSDL
 * - documentation: PreCalculated Total Values
 * @subpackage Structs
 */
class PreCalculatedTotalValues extends AbstractStructBase
{
    /**
     * The PreCalculatedTotalGoodsValue
     * Meta information extracted from the WSDL
     * - documentation: Customer pre-calculated total value of all line items. Customer must provide all pre-calculated fields in request.
     * - base: xsd:decimal
     * - whiteSpace: collapse
     * @var float
     */
    public $PreCalculatedTotalGoodsValue;
    /**
     * The PreCalculatedTotalInvoiceValue
     * Meta information extracted from the WSDL
     * - documentation: Customer pre-calculated total value of all line items plus the additional charges if any. Customer must provide all pre-calculated fields in request.
     * - base: xsd:decimal
     * - whiteSpace: collapse
     * @var float
     */
    public $PreCalculatedTotalInvoiceValue;
    /**
     * Constructor method for PreCalculatedTotalValues
     * @uses PreCalculatedTotalValues::setPreCalculatedTotalGoodsValue()
     * @uses PreCalculatedTotalValues::setPreCalculatedTotalInvoiceValue()
     * @param float $preCalculatedTotalGoodsValue
     * @param float $preCalculatedTotalInvoiceValue
     */
    public function __construct($preCalculatedTotalGoodsValue = null, $preCalculatedTotalInvoiceValue = null)
    {
        $this
            ->setPreCalculatedTotalGoodsValue($preCalculatedTotalGoodsValue)
            ->setPreCalculatedTotalInvoiceValue($preCalculatedTotalInvoiceValue);
    }
    /**
     * Get PreCalculatedTotalGoodsValue value
     * @return float|null
     */
    public function getPreCalculatedTotalGoodsValue()
    {
        return $this->PreCalculatedTotalGoodsValue;
    }
    /**
     * Set PreCalculatedTotalGoodsValue value
     * @param float $preCalculatedTotalGoodsValue
     * @return \App\Delivery\Dhl\StructType\PreCalculatedTotalValues
     */
    public function setPreCalculatedTotalGoodsValue($preCalculatedTotalGoodsValue = null)
    {
        // validation for constraint: float
        if (!is_null($preCalculatedTotalGoodsValue) && !(is_float($preCalculatedTotalGoodsValue) || is_numeric($preCalculatedTotalGoodsValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($preCalculatedTotalGoodsValue, true), gettype($preCalculatedTotalGoodsValue)), __LINE__);
        }
        $this->PreCalculatedTotalGoodsValue = $preCalculatedTotalGoodsValue;
        return $this;
    }
    /**
     * Get PreCalculatedTotalInvoiceValue value
     * @return float|null
     */
    public function getPreCalculatedTotalInvoiceValue()
    {
        return $this->PreCalculatedTotalInvoiceValue;
    }
    /**
     * Set PreCalculatedTotalInvoiceValue value
     * @param float $preCalculatedTotalInvoiceValue
     * @return \App\Delivery\Dhl\StructType\PreCalculatedTotalValues
     */
    public function setPreCalculatedTotalInvoiceValue($preCalculatedTotalInvoiceValue = null)
    {
        // validation for constraint: float
        if (!is_null($preCalculatedTotalInvoiceValue) && !(is_float($preCalculatedTotalInvoiceValue) || is_numeric($preCalculatedTotalInvoiceValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($preCalculatedTotalInvoiceValue, true), gettype($preCalculatedTotalInvoiceValue)), __LINE__);
        }
        $this->PreCalculatedTotalInvoiceValue = $preCalculatedTotalInvoiceValue;
        return $this;
    }
}
