<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceReference StructType
 * Meta information extracted from the WSDL
 * - documentation: Customs Invoice Reference entry
 * @subpackage Structs
 */
class InvoiceReference extends AbstractStructBase
{
    /**
     * The InvoiceReferenceType
     * Meta information extracted from the WSDL
     * - documentation: Customs Invoice Reference entry's Type | Invoice Reference Type code. Possible values: Code Description ACL Parent Shipment ID for BBX CID Customer Identifier CN Contract Number CU Consignor reference number ITN US Export declaration
     * reference ID MRN Movement Reference number UCN Unique reference of a consignment (UCRN) OID Order Number PON Purchase Order Number RMA RMA Number Please refer to the DHL EXPRESS - MyDHL API - SOAP Developer Guide for valid enumeration values. For
     * more information please contact your local DHL Express API representative.
     * - base: xsd:string
     * - maxLength: 3
     * - minLength: 2
     * @var string
     */
    public $InvoiceReferenceType;
    /**
     * The InvoiceReferenceNumber
     * Meta information extracted from the WSDL
     * - documentation: Customs Invoice Reference entry's Number | Invoice Reference Number
     * - base: xsd:string
     * - maxLength: 35
     * @var string
     */
    public $InvoiceReferenceNumber;
    /**
     * Constructor method for InvoiceReference
     * @uses InvoiceReference::setInvoiceReferenceType()
     * @uses InvoiceReference::setInvoiceReferenceNumber()
     * @param string $invoiceReferenceType
     * @param string $invoiceReferenceNumber
     */
    public function __construct($invoiceReferenceType = null, $invoiceReferenceNumber = null)
    {
        $this
            ->setInvoiceReferenceType($invoiceReferenceType)
            ->setInvoiceReferenceNumber($invoiceReferenceNumber);
    }
    /**
     * Get InvoiceReferenceType value
     * @return string|null
     */
    public function getInvoiceReferenceType()
    {
        return $this->InvoiceReferenceType;
    }
    /**
     * Set InvoiceReferenceType value
     * @param string $invoiceReferenceType
     * @return \App\Delivery\Dhl\StructType\InvoiceReference
     */
    public function setInvoiceReferenceType($invoiceReferenceType = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceReferenceType) && !is_string($invoiceReferenceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceReferenceType, true), gettype($invoiceReferenceType)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($invoiceReferenceType) && mb_strlen($invoiceReferenceType) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($invoiceReferenceType)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($invoiceReferenceType) && mb_strlen($invoiceReferenceType) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($invoiceReferenceType)), __LINE__);
        }
        $this->InvoiceReferenceType = $invoiceReferenceType;
        return $this;
    }
    /**
     * Get InvoiceReferenceNumber value
     * @return string|null
     */
    public function getInvoiceReferenceNumber()
    {
        return $this->InvoiceReferenceNumber;
    }
    /**
     * Set InvoiceReferenceNumber value
     * @param string $invoiceReferenceNumber
     * @return \App\Delivery\Dhl\StructType\InvoiceReference
     */
    public function setInvoiceReferenceNumber($invoiceReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceReferenceNumber) && !is_string($invoiceReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceReferenceNumber, true), gettype($invoiceReferenceNumber)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($invoiceReferenceNumber) && mb_strlen($invoiceReferenceNumber) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($invoiceReferenceNumber)), __LINE__);
        }
        $this->InvoiceReferenceNumber = $invoiceReferenceNumber;
        return $this;
    }
}
