<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExportDeclaration StructType
 * @subpackage Structs
 */
class ExportDeclaration extends AbstractStructBase
{
    /**
     * The DestinationPort
     * Meta information extracted from the WSDL
     * - documentation: Destination port details
     * - minOccurs: 0
     * @var string
     */
    public $DestinationPort;
    /**
     * The ExporterCode
     * Meta information extracted from the WSDL
     * - documentation: Exporter Code
     * - minOccurs: 0
     * @var string
     */
    public $ExporterCode;
    /**
     * The ExporterID
     * Meta information extracted from the WSDL
     * - documentation: Exporter ID
     * - minOccurs: 0
     * @var string
     */
    public $ExporterID;
    /**
     * The ExportLicense
     * Meta information extracted from the WSDL
     * - documentation: Export license info | Export License
     * - base: xsd:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $ExportLicense;
    /**
     * The ExportLineItems
     * Meta information extracted from the WSDL
     * - documentation: Specifics about each of the export line item
     * @var \App\Delivery\Dhl\StructType\ExportLineItems
     */
    public $ExportLineItems;
    /**
     * The ExportReasonType
     * Meta information extracted from the WSDL
     * - documentation: Reason for Export. Possible values: PERMANENT TEMPORARY RETURN USED_EXHIBITION_GOODS_TO_ORIGIN INTERCOMPANY_USE COMMERCIAL_PURPOSE_OR_SALE PERSONAL_BELONGINGS_OR_PERSONAL_USE SAMPLE GIFT RETURN_TO_ORIGIN WARRANTY_REPLACEMENT
     * DIPLOMATIC_GOODS DEFENCE_MATERIAL | Export reason code (Permanent, Temporary,Return)
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $ExportReasonType;
    /**
     * The ExportReason
     * Meta information extracted from the WSDL
     * - documentation: Export Reason
     * - base: xsd:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $ExportReason;
    /**
     * The ImportLicense
     * Meta information extracted from the WSDL
     * - documentation: Consignee import license | "Import License"
     * - base: xsd:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $ImportLicense;
    /**
     * The InvoiceDate
     * Meta information extracted from the WSDL
     * - documentation: The date component must be in the format: YYYY-MM-DD. This field is mandatory when RequestDHLCustomsInvoice = Y
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceDate;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - documentation: Invoice number. This field is mandatory when RequestDHLCustomsInvoice = Y.
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The InvoiceDeclarationTexts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\InvoiceDeclarationTexts
     */
    public $InvoiceDeclarationTexts;
    /**
     * The PlaceOfIncoterm
     * Meta information extracted from the WSDL
     * - documentation: Name of port of departure, shipment or destination, as required under the applicable delivery term.
     * - base: xsd:string
     * - maxLength: 256
     * - minOccurs: 0
     * @var string
     */
    public $PlaceOfIncoterm;
    /**
     * The ShipmentPurpose
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the shipment was sent for PERSONAL (e.g. Gift) or COMMERCIAL (e.g. Sale) reasons
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentPurpose;
    /**
     * The DocumentFunction
     * Meta information extracted from the WSDL
     * - documentation: Document function describes for what purpose was the document details captured and are planned to be used. IMPORT EXPORT BOTH
     * - minOccurs: 0
     * @var string
     */
    public $DocumentFunction;
    /**
     * The CustomsDocuments
     * Meta information extracted from the WSDL
     * - documentation: Associated documents for Customs
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\CustomsDocuments
     */
    public $CustomsDocuments;
    /**
     * The InvoiceSignatureDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\InvoiceSignatureDetails
     */
    public $InvoiceSignatureDetails;
    /**
     * The OtherCharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\OtherCharges
     */
    public $OtherCharges;
    /**
     * The PackageMarks
     * Meta information extracted from the WSDL
     * - documentation: Package marks
     * - minOccurs: 0
     * @var string
     */
    public $PackageMarks;
    /**
     * The PayerGSTVAT
     * Meta information extracted from the WSDL
     * - documentation: Payer GST VAT details
     * - minOccurs: 0
     * @var string
     */
    public $PayerGSTVAT;
    /**
     * The RecipientReference
     * Meta information extracted from the WSDL
     * - documentation: Recipient reference
     * - minOccurs: 0
     * @var string
     */
    public $RecipientReference;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\Remarks
     */
    public $Remarks;
    /**
     * The TermsOfPayment
     * Meta information extracted from the WSDL
     * - documentation: Terms of payment
     * - minOccurs: 0
     * @var string
     */
    public $TermsOfPayment;
    /**
     * The InvoiceTotalNetWeight
     * Meta information extracted from the WSDL
     * - documentation: Total of line item Net Weight. Note: Value must be greater than 0 (zero) to be provided in this field.
     * - base: xsd:decimal
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var float
     */
    public $InvoiceTotalNetWeight;
    /**
     * The InvoiceTotalGrossWeight
     * Meta information extracted from the WSDL
     * - documentation: Total of line item Gross Weight. Note: Value must be greater than 0 (zero) to be provided in this field.
     * - base: xsd:decimal
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var float
     */
    public $InvoiceTotalGrossWeight;
    /**
     * The InvoiceInstructions
     * Meta information extracted from the WSDL
     * - documentation: Customs Invoice's Instruction. This will be printed in Customs Invoice's template COMMERCIAL_INVOICE_04 | Shipment Instructions for Customs Invoice printing purposes in COMMERCIAL_INVOICE_04 template
     * - base: xsd:string
     * - maxLength: 300
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceInstructions;
    /**
     * The CustomerDataTextEntries
     * Meta information extracted from the WSDL
     * - documentation: Customs Invoice's Customer Data Text Entries. This will be printed in Customs Invoice's template COMMERCIAL_INVOICE_04 (note: only to be used for preparing Loose BBX shipments)
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\CustomerDataTextEntries
     */
    public $CustomerDataTextEntries;
    /**
     * The InvoiceReferences
     * Meta information extracted from the WSDL
     * - documentation: Customs Invoice Reference Numbers and their type codes.
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\InvoiceReferences
     */
    public $InvoiceReferences;
    /**
     * The InvoiceIndicativeCustomsValues
     * Meta information extracted from the WSDL
     * - documentation: Invoice Indicative Customs Duty value and Import Taxes value for Perfect Invoice
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\InvoiceIndicativeCustomsValues
     */
    public $InvoiceIndicativeCustomsValues;
    /**
     * The PreCalculatedTotalValues
     * Meta information extracted from the WSDL
     * - documentation: Customer pre-calculated Invoice values. Customer must provide all pre-calculated fields in request if this element is used.
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\PreCalculatedTotalValues
     */
    public $PreCalculatedTotalValues;
    /**
     * Constructor method for ExportDeclaration
     * @uses ExportDeclaration::setDestinationPort()
     * @uses ExportDeclaration::setExporterCode()
     * @uses ExportDeclaration::setExporterID()
     * @uses ExportDeclaration::setExportLicense()
     * @uses ExportDeclaration::setExportLineItems()
     * @uses ExportDeclaration::setExportReasonType()
     * @uses ExportDeclaration::setExportReason()
     * @uses ExportDeclaration::setImportLicense()
     * @uses ExportDeclaration::setInvoiceDate()
     * @uses ExportDeclaration::setInvoiceNumber()
     * @uses ExportDeclaration::setInvoiceDeclarationTexts()
     * @uses ExportDeclaration::setPlaceOfIncoterm()
     * @uses ExportDeclaration::setShipmentPurpose()
     * @uses ExportDeclaration::setDocumentFunction()
     * @uses ExportDeclaration::setCustomsDocuments()
     * @uses ExportDeclaration::setInvoiceSignatureDetails()
     * @uses ExportDeclaration::setOtherCharges()
     * @uses ExportDeclaration::setPackageMarks()
     * @uses ExportDeclaration::setPayerGSTVAT()
     * @uses ExportDeclaration::setRecipientReference()
     * @uses ExportDeclaration::setRemarks()
     * @uses ExportDeclaration::setTermsOfPayment()
     * @uses ExportDeclaration::setInvoiceTotalNetWeight()
     * @uses ExportDeclaration::setInvoiceTotalGrossWeight()
     * @uses ExportDeclaration::setInvoiceInstructions()
     * @uses ExportDeclaration::setCustomerDataTextEntries()
     * @uses ExportDeclaration::setInvoiceReferences()
     * @uses ExportDeclaration::setInvoiceIndicativeCustomsValues()
     * @uses ExportDeclaration::setPreCalculatedTotalValues()
     * @param string $destinationPort
     * @param string $exporterCode
     * @param string $exporterID
     * @param string $exportLicense
     * @param \App\Delivery\Dhl\StructType\ExportLineItems $exportLineItems
     * @param string $exportReasonType
     * @param string $exportReason
     * @param string $importLicense
     * @param string $invoiceDate
     * @param string $invoiceNumber
     * @param \App\Delivery\Dhl\StructType\InvoiceDeclarationTexts $invoiceDeclarationTexts
     * @param string $placeOfIncoterm
     * @param string $shipmentPurpose
     * @param string $documentFunction
     * @param \App\Delivery\Dhl\StructType\CustomsDocuments $customsDocuments
     * @param \App\Delivery\Dhl\StructType\InvoiceSignatureDetails $invoiceSignatureDetails
     * @param \App\Delivery\Dhl\StructType\OtherCharges $otherCharges
     * @param string $packageMarks
     * @param string $payerGSTVAT
     * @param string $recipientReference
     * @param \App\Delivery\Dhl\StructType\Remarks $remarks
     * @param string $termsOfPayment
     * @param float $invoiceTotalNetWeight
     * @param float $invoiceTotalGrossWeight
     * @param string $invoiceInstructions
     * @param \App\Delivery\Dhl\StructType\CustomerDataTextEntries $customerDataTextEntries
     * @param \App\Delivery\Dhl\StructType\InvoiceReferences $invoiceReferences
     * @param \App\Delivery\Dhl\StructType\InvoiceIndicativeCustomsValues $invoiceIndicativeCustomsValues
     * @param \App\Delivery\Dhl\StructType\PreCalculatedTotalValues $preCalculatedTotalValues
     */
    public function __construct($destinationPort = null, $exporterCode = null, $exporterID = null, $exportLicense = null, \App\Delivery\Dhl\StructType\ExportLineItems $exportLineItems = null, $exportReasonType = null, $exportReason = null, $importLicense = null, $invoiceDate = null, $invoiceNumber = null, \App\Delivery\Dhl\StructType\InvoiceDeclarationTexts $invoiceDeclarationTexts = null, $placeOfIncoterm = null, $shipmentPurpose = null, $documentFunction = null, \App\Delivery\Dhl\StructType\CustomsDocuments $customsDocuments = null, \App\Delivery\Dhl\StructType\InvoiceSignatureDetails $invoiceSignatureDetails = null, \App\Delivery\Dhl\StructType\OtherCharges $otherCharges = null, $packageMarks = null, $payerGSTVAT = null, $recipientReference = null, \App\Delivery\Dhl\StructType\Remarks $remarks = null, $termsOfPayment = null, $invoiceTotalNetWeight = null, $invoiceTotalGrossWeight = null, $invoiceInstructions = null, \App\Delivery\Dhl\StructType\CustomerDataTextEntries $customerDataTextEntries = null, \App\Delivery\Dhl\StructType\InvoiceReferences $invoiceReferences = null, \App\Delivery\Dhl\StructType\InvoiceIndicativeCustomsValues $invoiceIndicativeCustomsValues = null, \App\Delivery\Dhl\StructType\PreCalculatedTotalValues $preCalculatedTotalValues = null)
    {
        $this
            ->setDestinationPort($destinationPort)
            ->setExporterCode($exporterCode)
            ->setExporterID($exporterID)
            ->setExportLicense($exportLicense)
            ->setExportLineItems($exportLineItems)
            ->setExportReasonType($exportReasonType)
            ->setExportReason($exportReason)
            ->setImportLicense($importLicense)
            ->setInvoiceDate($invoiceDate)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceDeclarationTexts($invoiceDeclarationTexts)
            ->setPlaceOfIncoterm($placeOfIncoterm)
            ->setShipmentPurpose($shipmentPurpose)
            ->setDocumentFunction($documentFunction)
            ->setCustomsDocuments($customsDocuments)
            ->setInvoiceSignatureDetails($invoiceSignatureDetails)
            ->setOtherCharges($otherCharges)
            ->setPackageMarks($packageMarks)
            ->setPayerGSTVAT($payerGSTVAT)
            ->setRecipientReference($recipientReference)
            ->setRemarks($remarks)
            ->setTermsOfPayment($termsOfPayment)
            ->setInvoiceTotalNetWeight($invoiceTotalNetWeight)
            ->setInvoiceTotalGrossWeight($invoiceTotalGrossWeight)
            ->setInvoiceInstructions($invoiceInstructions)
            ->setCustomerDataTextEntries($customerDataTextEntries)
            ->setInvoiceReferences($invoiceReferences)
            ->setInvoiceIndicativeCustomsValues($invoiceIndicativeCustomsValues)
            ->setPreCalculatedTotalValues($preCalculatedTotalValues);
    }
    /**
     * Get DestinationPort value
     * @return string|null
     */
    public function getDestinationPort()
    {
        return $this->DestinationPort;
    }
    /**
     * Set DestinationPort value
     * @param string $destinationPort
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setDestinationPort($destinationPort = null)
    {
        // validation for constraint: string
        if (!is_null($destinationPort) && !is_string($destinationPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationPort, true), gettype($destinationPort)), __LINE__);
        }
        $this->DestinationPort = $destinationPort;
        return $this;
    }
    /**
     * Get ExporterCode value
     * @return string|null
     */
    public function getExporterCode()
    {
        return $this->ExporterCode;
    }
    /**
     * Set ExporterCode value
     * @param string $exporterCode
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setExporterCode($exporterCode = null)
    {
        // validation for constraint: string
        if (!is_null($exporterCode) && !is_string($exporterCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exporterCode, true), gettype($exporterCode)), __LINE__);
        }
        $this->ExporterCode = $exporterCode;
        return $this;
    }
    /**
     * Get ExporterID value
     * @return string|null
     */
    public function getExporterID()
    {
        return $this->ExporterID;
    }
    /**
     * Set ExporterID value
     * @param string $exporterID
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setExporterID($exporterID = null)
    {
        // validation for constraint: string
        if (!is_null($exporterID) && !is_string($exporterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exporterID, true), gettype($exporterID)), __LINE__);
        }
        $this->ExporterID = $exporterID;
        return $this;
    }
    /**
     * Get ExportLicense value
     * @return string|null
     */
    public function getExportLicense()
    {
        return $this->ExportLicense;
    }
    /**
     * Set ExportLicense value
     * @param string $exportLicense
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setExportLicense($exportLicense = null)
    {
        // validation for constraint: string
        if (!is_null($exportLicense) && !is_string($exportLicense)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportLicense, true), gettype($exportLicense)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($exportLicense) && mb_strlen($exportLicense) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($exportLicense)), __LINE__);
        }
        $this->ExportLicense = $exportLicense;
        return $this;
    }
    /**
     * Get ExportLineItems value
     * @return \App\Delivery\Dhl\StructType\ExportLineItems|null
     */
    public function getExportLineItems()
    {
        return $this->ExportLineItems;
    }
    /**
     * Set ExportLineItems value
     * @param \App\Delivery\Dhl\StructType\ExportLineItems $exportLineItems
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setExportLineItems(\App\Delivery\Dhl\StructType\ExportLineItems $exportLineItems = null)
    {
        $this->ExportLineItems = $exportLineItems;
        return $this;
    }
    /**
     * Get ExportReasonType value
     * @return string|null
     */
    public function getExportReasonType()
    {
        return $this->ExportReasonType;
    }
    /**
     * Set ExportReasonType value
     * @param string $exportReasonType
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setExportReasonType($exportReasonType = null)
    {
        // validation for constraint: string
        if (!is_null($exportReasonType) && !is_string($exportReasonType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportReasonType, true), gettype($exportReasonType)), __LINE__);
        }
        $this->ExportReasonType = $exportReasonType;
        return $this;
    }
    /**
     * Get ExportReason value
     * @return string|null
     */
    public function getExportReason()
    {
        return $this->ExportReason;
    }
    /**
     * Set ExportReason value
     * @param string $exportReason
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setExportReason($exportReason = null)
    {
        // validation for constraint: string
        if (!is_null($exportReason) && !is_string($exportReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exportReason, true), gettype($exportReason)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($exportReason) && mb_strlen($exportReason) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($exportReason)), __LINE__);
        }
        $this->ExportReason = $exportReason;
        return $this;
    }
    /**
     * Get ImportLicense value
     * @return string|null
     */
    public function getImportLicense()
    {
        return $this->ImportLicense;
    }
    /**
     * Set ImportLicense value
     * @param string $importLicense
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setImportLicense($importLicense = null)
    {
        // validation for constraint: string
        if (!is_null($importLicense) && !is_string($importLicense)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importLicense, true), gettype($importLicense)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($importLicense) && mb_strlen($importLicense) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($importLicense)), __LINE__);
        }
        $this->ImportLicense = $importLicense;
        return $this;
    }
    /**
     * Get InvoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get InvoiceDeclarationTexts value
     * @return \App\Delivery\Dhl\StructType\InvoiceDeclarationTexts|null
     */
    public function getInvoiceDeclarationTexts()
    {
        return $this->InvoiceDeclarationTexts;
    }
    /**
     * Set InvoiceDeclarationTexts value
     * @param \App\Delivery\Dhl\StructType\InvoiceDeclarationTexts $invoiceDeclarationTexts
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setInvoiceDeclarationTexts(\App\Delivery\Dhl\StructType\InvoiceDeclarationTexts $invoiceDeclarationTexts = null)
    {
        $this->InvoiceDeclarationTexts = $invoiceDeclarationTexts;
        return $this;
    }
    /**
     * Get PlaceOfIncoterm value
     * @return string|null
     */
    public function getPlaceOfIncoterm()
    {
        return $this->PlaceOfIncoterm;
    }
    /**
     * Set PlaceOfIncoterm value
     * @param string $placeOfIncoterm
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setPlaceOfIncoterm($placeOfIncoterm = null)
    {
        // validation for constraint: string
        if (!is_null($placeOfIncoterm) && !is_string($placeOfIncoterm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placeOfIncoterm, true), gettype($placeOfIncoterm)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($placeOfIncoterm) && mb_strlen($placeOfIncoterm) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($placeOfIncoterm)), __LINE__);
        }
        $this->PlaceOfIncoterm = $placeOfIncoterm;
        return $this;
    }
    /**
     * Get ShipmentPurpose value
     * @return string|null
     */
    public function getShipmentPurpose()
    {
        return $this->ShipmentPurpose;
    }
    /**
     * Set ShipmentPurpose value
     * @uses \App\Delivery\Dhl\EnumType\ShipmentPurpose::valueIsValid()
     * @uses \App\Delivery\Dhl\EnumType\ShipmentPurpose::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shipmentPurpose
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setShipmentPurpose($shipmentPurpose = null)
    {
        // validation for constraint: enumeration
        if (!\App\Delivery\Dhl\EnumType\ShipmentPurpose::valueIsValid($shipmentPurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Delivery\Dhl\EnumType\ShipmentPurpose', is_array($shipmentPurpose) ? implode(', ', $shipmentPurpose) : var_export($shipmentPurpose, true), implode(', ', \App\Delivery\Dhl\EnumType\ShipmentPurpose::getValidValues())), __LINE__);
        }
        $this->ShipmentPurpose = $shipmentPurpose;
        return $this;
    }
    /**
     * Get DocumentFunction value
     * @return string|null
     */
    public function getDocumentFunction()
    {
        return $this->DocumentFunction;
    }
    /**
     * Set DocumentFunction value
     * @uses \App\Delivery\Dhl\EnumType\DocumentFunction::valueIsValid()
     * @uses \App\Delivery\Dhl\EnumType\DocumentFunction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentFunction
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setDocumentFunction($documentFunction = null)
    {
        // validation for constraint: enumeration
        if (!\App\Delivery\Dhl\EnumType\DocumentFunction::valueIsValid($documentFunction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Delivery\Dhl\EnumType\DocumentFunction', is_array($documentFunction) ? implode(', ', $documentFunction) : var_export($documentFunction, true), implode(', ', \App\Delivery\Dhl\EnumType\DocumentFunction::getValidValues())), __LINE__);
        }
        $this->DocumentFunction = $documentFunction;
        return $this;
    }
    /**
     * Get CustomsDocuments value
     * @return \App\Delivery\Dhl\StructType\CustomsDocuments|null
     */
    public function getCustomsDocuments()
    {
        return $this->CustomsDocuments;
    }
    /**
     * Set CustomsDocuments value
     * @param \App\Delivery\Dhl\StructType\CustomsDocuments $customsDocuments
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setCustomsDocuments(\App\Delivery\Dhl\StructType\CustomsDocuments $customsDocuments = null)
    {
        $this->CustomsDocuments = $customsDocuments;
        return $this;
    }
    /**
     * Get InvoiceSignatureDetails value
     * @return \App\Delivery\Dhl\StructType\InvoiceSignatureDetails|null
     */
    public function getInvoiceSignatureDetails()
    {
        return $this->InvoiceSignatureDetails;
    }
    /**
     * Set InvoiceSignatureDetails value
     * @param \App\Delivery\Dhl\StructType\InvoiceSignatureDetails $invoiceSignatureDetails
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setInvoiceSignatureDetails(\App\Delivery\Dhl\StructType\InvoiceSignatureDetails $invoiceSignatureDetails = null)
    {
        $this->InvoiceSignatureDetails = $invoiceSignatureDetails;
        return $this;
    }
    /**
     * Get OtherCharges value
     * @return \App\Delivery\Dhl\StructType\OtherCharges|null
     */
    public function getOtherCharges()
    {
        return $this->OtherCharges;
    }
    /**
     * Set OtherCharges value
     * @param \App\Delivery\Dhl\StructType\OtherCharges $otherCharges
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setOtherCharges(\App\Delivery\Dhl\StructType\OtherCharges $otherCharges = null)
    {
        $this->OtherCharges = $otherCharges;
        return $this;
    }
    /**
     * Get PackageMarks value
     * @return string|null
     */
    public function getPackageMarks()
    {
        return $this->PackageMarks;
    }
    /**
     * Set PackageMarks value
     * @param string $packageMarks
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setPackageMarks($packageMarks = null)
    {
        // validation for constraint: string
        if (!is_null($packageMarks) && !is_string($packageMarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageMarks, true), gettype($packageMarks)), __LINE__);
        }
        $this->PackageMarks = $packageMarks;
        return $this;
    }
    /**
     * Get PayerGSTVAT value
     * @return string|null
     */
    public function getPayerGSTVAT()
    {
        return $this->PayerGSTVAT;
    }
    /**
     * Set PayerGSTVAT value
     * @param string $payerGSTVAT
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setPayerGSTVAT($payerGSTVAT = null)
    {
        // validation for constraint: string
        if (!is_null($payerGSTVAT) && !is_string($payerGSTVAT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerGSTVAT, true), gettype($payerGSTVAT)), __LINE__);
        }
        $this->PayerGSTVAT = $payerGSTVAT;
        return $this;
    }
    /**
     * Get RecipientReference value
     * @return string|null
     */
    public function getRecipientReference()
    {
        return $this->RecipientReference;
    }
    /**
     * Set RecipientReference value
     * @param string $recipientReference
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setRecipientReference($recipientReference = null)
    {
        // validation for constraint: string
        if (!is_null($recipientReference) && !is_string($recipientReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipientReference, true), gettype($recipientReference)), __LINE__);
        }
        $this->RecipientReference = $recipientReference;
        return $this;
    }
    /**
     * Get Remarks value
     * @return \App\Delivery\Dhl\StructType\Remarks|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param \App\Delivery\Dhl\StructType\Remarks $remarks
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setRemarks(\App\Delivery\Dhl\StructType\Remarks $remarks = null)
    {
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get TermsOfPayment value
     * @return string|null
     */
    public function getTermsOfPayment()
    {
        return $this->TermsOfPayment;
    }
    /**
     * Set TermsOfPayment value
     * @param string $termsOfPayment
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setTermsOfPayment($termsOfPayment = null)
    {
        // validation for constraint: string
        if (!is_null($termsOfPayment) && !is_string($termsOfPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($termsOfPayment, true), gettype($termsOfPayment)), __LINE__);
        }
        $this->TermsOfPayment = $termsOfPayment;
        return $this;
    }
    /**
     * Get InvoiceTotalNetWeight value
     * @return float|null
     */
    public function getInvoiceTotalNetWeight()
    {
        return $this->InvoiceTotalNetWeight;
    }
    /**
     * Set InvoiceTotalNetWeight value
     * @param float $invoiceTotalNetWeight
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setInvoiceTotalNetWeight($invoiceTotalNetWeight = null)
    {
        // validation for constraint: float
        if (!is_null($invoiceTotalNetWeight) && !(is_float($invoiceTotalNetWeight) || is_numeric($invoiceTotalNetWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($invoiceTotalNetWeight, true), gettype($invoiceTotalNetWeight)), __LINE__);
        }
        $this->InvoiceTotalNetWeight = $invoiceTotalNetWeight;
        return $this;
    }
    /**
     * Get InvoiceTotalGrossWeight value
     * @return float|null
     */
    public function getInvoiceTotalGrossWeight()
    {
        return $this->InvoiceTotalGrossWeight;
    }
    /**
     * Set InvoiceTotalGrossWeight value
     * @param float $invoiceTotalGrossWeight
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setInvoiceTotalGrossWeight($invoiceTotalGrossWeight = null)
    {
        // validation for constraint: float
        if (!is_null($invoiceTotalGrossWeight) && !(is_float($invoiceTotalGrossWeight) || is_numeric($invoiceTotalGrossWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($invoiceTotalGrossWeight, true), gettype($invoiceTotalGrossWeight)), __LINE__);
        }
        $this->InvoiceTotalGrossWeight = $invoiceTotalGrossWeight;
        return $this;
    }
    /**
     * Get InvoiceInstructions value
     * @return string|null
     */
    public function getInvoiceInstructions()
    {
        return $this->InvoiceInstructions;
    }
    /**
     * Set InvoiceInstructions value
     * @param string $invoiceInstructions
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setInvoiceInstructions($invoiceInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceInstructions) && !is_string($invoiceInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceInstructions, true), gettype($invoiceInstructions)), __LINE__);
        }
        // validation for constraint: maxLength(300)
        if (!is_null($invoiceInstructions) && mb_strlen($invoiceInstructions) > 300) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 300', mb_strlen($invoiceInstructions)), __LINE__);
        }
        $this->InvoiceInstructions = $invoiceInstructions;
        return $this;
    }
    /**
     * Get CustomerDataTextEntries value
     * @return \App\Delivery\Dhl\StructType\CustomerDataTextEntries|null
     */
    public function getCustomerDataTextEntries()
    {
        return $this->CustomerDataTextEntries;
    }
    /**
     * Set CustomerDataTextEntries value
     * @param \App\Delivery\Dhl\StructType\CustomerDataTextEntries $customerDataTextEntries
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setCustomerDataTextEntries(\App\Delivery\Dhl\StructType\CustomerDataTextEntries $customerDataTextEntries = null)
    {
        $this->CustomerDataTextEntries = $customerDataTextEntries;
        return $this;
    }
    /**
     * Get InvoiceReferences value
     * @return \App\Delivery\Dhl\StructType\InvoiceReferences|null
     */
    public function getInvoiceReferences()
    {
        return $this->InvoiceReferences;
    }
    /**
     * Set InvoiceReferences value
     * @param \App\Delivery\Dhl\StructType\InvoiceReferences $invoiceReferences
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setInvoiceReferences(\App\Delivery\Dhl\StructType\InvoiceReferences $invoiceReferences = null)
    {
        $this->InvoiceReferences = $invoiceReferences;
        return $this;
    }
    /**
     * Get InvoiceIndicativeCustomsValues value
     * @return \App\Delivery\Dhl\StructType\InvoiceIndicativeCustomsValues|null
     */
    public function getInvoiceIndicativeCustomsValues()
    {
        return $this->InvoiceIndicativeCustomsValues;
    }
    /**
     * Set InvoiceIndicativeCustomsValues value
     * @param \App\Delivery\Dhl\StructType\InvoiceIndicativeCustomsValues $invoiceIndicativeCustomsValues
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setInvoiceIndicativeCustomsValues(\App\Delivery\Dhl\StructType\InvoiceIndicativeCustomsValues $invoiceIndicativeCustomsValues = null)
    {
        $this->InvoiceIndicativeCustomsValues = $invoiceIndicativeCustomsValues;
        return $this;
    }
    /**
     * Get PreCalculatedTotalValues value
     * @return \App\Delivery\Dhl\StructType\PreCalculatedTotalValues|null
     */
    public function getPreCalculatedTotalValues()
    {
        return $this->PreCalculatedTotalValues;
    }
    /**
     * Set PreCalculatedTotalValues value
     * @param \App\Delivery\Dhl\StructType\PreCalculatedTotalValues $preCalculatedTotalValues
     * @return \App\Delivery\Dhl\StructType\ExportDeclaration
     */
    public function setPreCalculatedTotalValues(\App\Delivery\Dhl\StructType\PreCalculatedTotalValues $preCalculatedTotalValues = null)
    {
        $this->PreCalculatedTotalValues = $preCalculatedTotalValues;
        return $this;
    }
}
