<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemReference StructType
 * Meta information extracted from the WSDL
 * - documentation: Customs Invoice Reference entry
 * @subpackage Structs
 */
class ItemReference extends AbstractStructBase
{
    /**
     * The ItemReferenceType
     * Meta information extracted from the WSDL
     * - documentation: Customs Invoice Reference entry's Type | Export Declaration line items's Reference Type code. Possible values: Code Description AAJ Delivery Order ABW Stock Keeping Unit AFE Export Control Commodity number (ECCN) ALX Model BRD Brand
     * DGC Dangerous Goods Content Identifier DTC DDTC Eligibility Indicator DTM DDTC UOM DTQ DDTC Quantity DTR DDTC Registration No ECN Export Clearance Number INB In Bond shipment ITR DDTC ITAR Exemption No MAK Make MID Manufacturers Identification Code
     * OED Original Export Date OET Original Export OB Tracking ID OID Order ID OOR Original Outbound Carrier PAN Part No PON Purchase Order Number SE Serial number SON Sales order No SME DDTC SME Indicator USM DDTC USML Category Code Please refer to the
     * DHL EXPRESS - MyDHL API - SOAP Developer Guide for valid enumeration values. For more information please contact your local DHL Express API representative.
     * - base: xsd:string
     * - maxLength: 3
     * - minLength: 2
     * @var string
     */
    public $ItemReferenceType;
    /**
     * The ItemReferenceNumber
     * Meta information extracted from the WSDL
     * - documentation: Customs Invoice Reference entry's Number | Export Declaration line items's Reference Number
     * - base: xsd:string
     * - maxLength: 35
     * @var string
     */
    public $ItemReferenceNumber;
    /**
     * Constructor method for ItemReference
     * @uses ItemReference::setItemReferenceType()
     * @uses ItemReference::setItemReferenceNumber()
     * @param string $itemReferenceType
     * @param string $itemReferenceNumber
     */
    public function __construct($itemReferenceType = null, $itemReferenceNumber = null)
    {
        $this
            ->setItemReferenceType($itemReferenceType)
            ->setItemReferenceNumber($itemReferenceNumber);
    }
    /**
     * Get ItemReferenceType value
     * @return string|null
     */
    public function getItemReferenceType()
    {
        return $this->ItemReferenceType;
    }
    /**
     * Set ItemReferenceType value
     * @param string $itemReferenceType
     * @return \App\Delivery\Dhl\StructType\ItemReference
     */
    public function setItemReferenceType($itemReferenceType = null)
    {
        // validation for constraint: string
        if (!is_null($itemReferenceType) && !is_string($itemReferenceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemReferenceType, true), gettype($itemReferenceType)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($itemReferenceType) && mb_strlen($itemReferenceType) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($itemReferenceType)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($itemReferenceType) && mb_strlen($itemReferenceType) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($itemReferenceType)), __LINE__);
        }
        $this->ItemReferenceType = $itemReferenceType;
        return $this;
    }
    /**
     * Get ItemReferenceNumber value
     * @return string|null
     */
    public function getItemReferenceNumber()
    {
        return $this->ItemReferenceNumber;
    }
    /**
     * Set ItemReferenceNumber value
     * @param string $itemReferenceNumber
     * @return \App\Delivery\Dhl\StructType\ItemReference
     */
    public function setItemReferenceNumber($itemReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($itemReferenceNumber) && !is_string($itemReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemReferenceNumber, true), gettype($itemReferenceNumber)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($itemReferenceNumber) && mb_strlen($itemReferenceNumber) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($itemReferenceNumber)), __LINE__);
        }
        $this->ItemReferenceNumber = $itemReferenceNumber;
        return $this;
    }
}
