<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Remark StructType
 * Meta information extracted from the WSDL
 * - documentation: Remark details
 * @subpackage Structs
 */
class Remark extends AbstractStructBase
{
    /**
     * The RemarkDescription
     * Meta information extracted from the WSDL
     * - documentation: Custom Invoice Remarks Description
     * - base: xsd:string
     * @var string
     */
    public $RemarkDescription;
    /**
     * Constructor method for Remark
     * @uses Remark::setRemarkDescription()
     * @param string $remarkDescription
     */
    public function __construct($remarkDescription = null)
    {
        $this
            ->setRemarkDescription($remarkDescription);
    }
    /**
     * Get RemarkDescription value
     * @return string|null
     */
    public function getRemarkDescription()
    {
        return $this->RemarkDescription;
    }
    /**
     * Set RemarkDescription value
     * @param string $remarkDescription
     * @return \App\Delivery\Dhl\StructType\Remark
     */
    public function setRemarkDescription($remarkDescription = null)
    {
        // validation for constraint: string
        if (!is_null($remarkDescription) && !is_string($remarkDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarkDescription, true), gettype($remarkDescription)), __LINE__);
        }
        $this->RemarkDescription = $remarkDescription;
        return $this;
    }
}
