<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_UNCodes StructType
 * Meta information extracted from the WSDL
 * - documentation: List of UN codes
 * @subpackage Structs
 */
class DocTypeRef_UNCodes extends AbstractStructBase
{
    /**
     * The UNCode
     * Meta information extracted from the WSDL
     * - documentation: This is a legacy tag | Individual UN code
     * - base: xsd:string
     * - maxLength: 10
     * - minLength: 1
     * - whiteSpace: collapse
     * @var string
     */
    public $UNCode;
    /**
     * Constructor method for docTypeRef_UNCodes
     * @uses DocTypeRef_UNCodes::setUNCode()
     * @param string $uNCode
     */
    public function __construct($uNCode = null)
    {
        $this
            ->setUNCode($uNCode);
    }
    /**
     * Get UNCode value
     * @return string|null
     */
    public function getUNCode()
    {
        return $this->UNCode;
    }
    /**
     * Set UNCode value
     * @param string $uNCode
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_UNCodes
     */
    public function setUNCode($uNCode = null)
    {
        // validation for constraint: string
        if (!is_null($uNCode) && !is_string($uNCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uNCode, true), gettype($uNCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($uNCode) && mb_strlen($uNCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($uNCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($uNCode) && mb_strlen($uNCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($uNCode)), __LINE__);
        }
        $this->UNCode = $uNCode;
        return $this;
    }
}
