<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_MutuallyExclusiveChargesGroups StructType
 * @subpackage Structs
 */
class DocTypeRef_MutuallyExclusiveChargesGroups extends AbstractStructBase
{
    /**
     * The RuleGroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RuleGroupName;
    /**
     * The RuleGroupDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RuleGroupDescription;
    /**
     * The ChargeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var string[]
     */
    public $ChargeCode;
    /**
     * Constructor method for docTypeRef_MutuallyExclusiveChargesGroups
     * @uses DocTypeRef_MutuallyExclusiveChargesGroups::setRuleGroupName()
     * @uses DocTypeRef_MutuallyExclusiveChargesGroups::setRuleGroupDescription()
     * @uses DocTypeRef_MutuallyExclusiveChargesGroups::setChargeCode()
     * @param string $ruleGroupName
     * @param string $ruleGroupDescription
     * @param string[] $chargeCode
     */
    public function __construct($ruleGroupName = null, $ruleGroupDescription = null, array $chargeCode = array())
    {
        $this
            ->setRuleGroupName($ruleGroupName)
            ->setRuleGroupDescription($ruleGroupDescription)
            ->setChargeCode($chargeCode);
    }
    /**
     * Get RuleGroupName value
     * @return string|null
     */
    public function getRuleGroupName()
    {
        return $this->RuleGroupName;
    }
    /**
     * Set RuleGroupName value
     * @param string $ruleGroupName
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_MutuallyExclusiveChargesGroups
     */
    public function setRuleGroupName($ruleGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($ruleGroupName) && !is_string($ruleGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleGroupName, true), gettype($ruleGroupName)), __LINE__);
        }
        $this->RuleGroupName = $ruleGroupName;
        return $this;
    }
    /**
     * Get RuleGroupDescription value
     * @return string|null
     */
    public function getRuleGroupDescription()
    {
        return $this->RuleGroupDescription;
    }
    /**
     * Set RuleGroupDescription value
     * @param string $ruleGroupDescription
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_MutuallyExclusiveChargesGroups
     */
    public function setRuleGroupDescription($ruleGroupDescription = null)
    {
        // validation for constraint: string
        if (!is_null($ruleGroupDescription) && !is_string($ruleGroupDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleGroupDescription, true), gettype($ruleGroupDescription)), __LINE__);
        }
        $this->RuleGroupDescription = $ruleGroupDescription;
        return $this;
    }
    /**
     * Get ChargeCode value
     * @return string[]|null
     */
    public function getChargeCode()
    {
        return $this->ChargeCode;
    }
    /**
     * This method is responsible for validating the values passed to the setChargeCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChargeCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChargeCodeForArrayConstraintsFromSetChargeCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docTypeRef_MutuallyExclusiveChargesGroupsChargeCodeItem) {
            // validation for constraint: itemType
            if (!is_string($docTypeRef_MutuallyExclusiveChargesGroupsChargeCodeItem)) {
                $invalidValues[] = is_object($docTypeRef_MutuallyExclusiveChargesGroupsChargeCodeItem) ? get_class($docTypeRef_MutuallyExclusiveChargesGroupsChargeCodeItem) : sprintf('%s(%s)', gettype($docTypeRef_MutuallyExclusiveChargesGroupsChargeCodeItem), var_export($docTypeRef_MutuallyExclusiveChargesGroupsChargeCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ChargeCode property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChargeCode value
     * @throws \InvalidArgumentException
     * @param string[] $chargeCode
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_MutuallyExclusiveChargesGroups
     */
    public function setChargeCode(array $chargeCode = array())
    {
        // validation for constraint: array
        if ('' !== ($chargeCodeArrayErrorMessage = self::validateChargeCodeForArrayConstraintsFromSetChargeCode($chargeCode))) {
            throw new \InvalidArgumentException($chargeCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($chargeCode) && count($chargeCode) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($chargeCode)), __LINE__);
        }
        $this->ChargeCode = $chargeCode;
        return $this;
    }
    /**
     * Add item to ChargeCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_MutuallyExclusiveChargesGroups
     */
    public function addToChargeCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ChargeCode property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->ChargeCode) && count($this->ChargeCode) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->ChargeCode)), __LINE__);
        }
        $this->ChargeCode[] = $item;
        return $this;
    }
}
