<?php

namespace App\Delivery\Dhl\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for docTypeRef_DependencyRuleGroups StructType
 * @subpackage Structs
 */
class DocTypeRef_DependencyRuleGroups extends AbstractStructBase
{
    /**
     * The DependentChargeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DependentChargeCode;
    /**
     * The DependencyRuleGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \App\Delivery\Dhl\StructType\DocTypeRef_DependencyRuleGroup[]
     */
    public $DependencyRuleGroup;
    /**
     * Constructor method for docTypeRef_DependencyRuleGroups
     * @uses DocTypeRef_DependencyRuleGroups::setDependentChargeCode()
     * @uses DocTypeRef_DependencyRuleGroups::setDependencyRuleGroup()
     * @param string $dependentChargeCode
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_DependencyRuleGroup[] $dependencyRuleGroup
     */
    public function __construct($dependentChargeCode = null, array $dependencyRuleGroup = array())
    {
        $this
            ->setDependentChargeCode($dependentChargeCode)
            ->setDependencyRuleGroup($dependencyRuleGroup);
    }
    /**
     * Get DependentChargeCode value
     * @return string|null
     */
    public function getDependentChargeCode()
    {
        return $this->DependentChargeCode;
    }
    /**
     * Set DependentChargeCode value
     * @param string $dependentChargeCode
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DependencyRuleGroups
     */
    public function setDependentChargeCode($dependentChargeCode = null)
    {
        // validation for constraint: string
        if (!is_null($dependentChargeCode) && !is_string($dependentChargeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dependentChargeCode, true), gettype($dependentChargeCode)), __LINE__);
        }
        $this->DependentChargeCode = $dependentChargeCode;
        return $this;
    }
    /**
     * Get DependencyRuleGroup value
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DependencyRuleGroup[]|null
     */
    public function getDependencyRuleGroup()
    {
        return $this->DependencyRuleGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setDependencyRuleGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDependencyRuleGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDependencyRuleGroupForArrayConstraintsFromSetDependencyRuleGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docTypeRef_DependencyRuleGroupsDependencyRuleGroupItem) {
            // validation for constraint: itemType
            if (!$docTypeRef_DependencyRuleGroupsDependencyRuleGroupItem instanceof \App\Delivery\Dhl\StructType\DocTypeRef_DependencyRuleGroup) {
                $invalidValues[] = is_object($docTypeRef_DependencyRuleGroupsDependencyRuleGroupItem) ? get_class($docTypeRef_DependencyRuleGroupsDependencyRuleGroupItem) : sprintf('%s(%s)', gettype($docTypeRef_DependencyRuleGroupsDependencyRuleGroupItem), var_export($docTypeRef_DependencyRuleGroupsDependencyRuleGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DependencyRuleGroup property can only contain items of type \App\Delivery\Dhl\StructType\DocTypeRef_DependencyRuleGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DependencyRuleGroup value
     * @throws \InvalidArgumentException
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_DependencyRuleGroup[] $dependencyRuleGroup
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DependencyRuleGroups
     */
    public function setDependencyRuleGroup(array $dependencyRuleGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($dependencyRuleGroupArrayErrorMessage = self::validateDependencyRuleGroupForArrayConstraintsFromSetDependencyRuleGroup($dependencyRuleGroup))) {
            throw new \InvalidArgumentException($dependencyRuleGroupArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($dependencyRuleGroup) && count($dependencyRuleGroup) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($dependencyRuleGroup)), __LINE__);
        }
        $this->DependencyRuleGroup = $dependencyRuleGroup;
        return $this;
    }
    /**
     * Add item to DependencyRuleGroup value
     * @throws \InvalidArgumentException
     * @param \App\Delivery\Dhl\StructType\DocTypeRef_DependencyRuleGroup $item
     * @return \App\Delivery\Dhl\StructType\DocTypeRef_DependencyRuleGroups
     */
    public function addToDependencyRuleGroup(\App\Delivery\Dhl\StructType\DocTypeRef_DependencyRuleGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Delivery\Dhl\StructType\DocTypeRef_DependencyRuleGroup) {
            throw new \InvalidArgumentException(sprintf('The DependencyRuleGroup property can only contain items of type \App\Delivery\Dhl\StructType\DocTypeRef_DependencyRuleGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->DependencyRuleGroup) && count($this->DependencyRuleGroup) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->DependencyRuleGroup)), __LINE__);
        }
        $this->DependencyRuleGroup[] = $item;
        return $this;
    }
}
