<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VideoItemsType StructType
 * @subpackage Structs
 */
class VideoItemsType extends AbstractStructBase
{
    /**
     * The VideoItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VideoItem[]
     */
    public $VideoItem;
    /**
     * Constructor method for VideoItemsType
     * @uses VideoItemsType::setVideoItem()
     * @param \StructType\VideoItem[] $videoItem
     */
    public function __construct(array $videoItem = array())
    {
        $this
            ->setVideoItem($videoItem);
    }
    /**
     * Get VideoItem value
     * @return \StructType\VideoItem[]|null
     */
    public function getVideoItem()
    {
        return $this->VideoItem;
    }
    /**
     * This method is responsible for validating the values passed to the setVideoItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVideoItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVideoItemForArrayConstraintsFromSetVideoItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $videoItemsTypeVideoItemItem) {
            // validation for constraint: itemType
            if (!$videoItemsTypeVideoItemItem instanceof \StructType\VideoItem) {
                $invalidValues[] = is_object($videoItemsTypeVideoItemItem) ? get_class($videoItemsTypeVideoItemItem) : sprintf('%s(%s)', gettype($videoItemsTypeVideoItemItem), var_export($videoItemsTypeVideoItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VideoItem property can only contain items of type \StructType\VideoItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VideoItem value
     * @throws \InvalidArgumentException
     * @param \StructType\VideoItem[] $videoItem
     * @return \StructType\VideoItemsType
     */
    public function setVideoItem(array $videoItem = array())
    {
        // validation for constraint: array
        if ('' !== ($videoItemArrayErrorMessage = self::validateVideoItemForArrayConstraintsFromSetVideoItem($videoItem))) {
            throw new \InvalidArgumentException($videoItemArrayErrorMessage, __LINE__);
        }
        $this->VideoItem = $videoItem;
        return $this;
    }
    /**
     * Add item to VideoItem value
     * @throws \InvalidArgumentException
     * @param \StructType\VideoItem $item
     * @return \StructType\VideoItemsType
     */
    public function addToVideoItem(\StructType\VideoItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VideoItem) {
            throw new \InvalidArgumentException(sprintf('The VideoItem property can only contain items of type \StructType\VideoItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VideoItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VideoItemsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
