<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleProfileRentalPrefType StructType
 * @subpackage Structs
 */
class VehicleProfileRentalPrefType extends AbstractStructBase
{
    /**
     * The LoyaltyPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LoyaltyPref[]
     */
    public $LoyaltyPref;
    /**
     * The VendorPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CompanyNamePrefType[]
     */
    public $VendorPref;
    /**
     * The PaymentFormPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentFormPref[]
     */
    public $PaymentFormPref;
    /**
     * The CoveragePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CoveragePref[]
     */
    public $CoveragePref;
    /**
     * The SpecialReqPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VehicleSpecialReqPrefType[]
     */
    public $SpecialReqPref;
    /**
     * The VehTypePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VehiclePrefType[]
     */
    public $VehTypePref;
    /**
     * The SpecialEquipPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SpecialEquipPref[]
     */
    public $SpecialEquipPref;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The SmokingAllowed
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The GasPrePay
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $GasPrePay;
    /**
     * Constructor method for VehicleProfileRentalPrefType
     * @uses VehicleProfileRentalPrefType::setLoyaltyPref()
     * @uses VehicleProfileRentalPrefType::setVendorPref()
     * @uses VehicleProfileRentalPrefType::setPaymentFormPref()
     * @uses VehicleProfileRentalPrefType::setCoveragePref()
     * @uses VehicleProfileRentalPrefType::setSpecialReqPref()
     * @uses VehicleProfileRentalPrefType::setVehTypePref()
     * @uses VehicleProfileRentalPrefType::setSpecialEquipPref()
     * @uses VehicleProfileRentalPrefType::setPreferLevel()
     * @uses VehicleProfileRentalPrefType::setShareSynchInd()
     * @uses VehicleProfileRentalPrefType::setShareMarketInd()
     * @uses VehicleProfileRentalPrefType::setSmokingAllowed()
     * @uses VehicleProfileRentalPrefType::setGasPrePay()
     * @param \StructType\LoyaltyPref[] $loyaltyPref
     * @param \StructType\CompanyNamePrefType[] $vendorPref
     * @param \StructType\PaymentFormPref[] $paymentFormPref
     * @param \StructType\CoveragePref[] $coveragePref
     * @param \StructType\VehicleSpecialReqPrefType[] $specialReqPref
     * @param \StructType\VehiclePrefType[] $vehTypePref
     * @param \StructType\SpecialEquipPref[] $specialEquipPref
     * @param string $preferLevel
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param bool $smokingAllowed
     * @param bool $gasPrePay
     */
    public function __construct(array $loyaltyPref = array(), array $vendorPref = array(), array $paymentFormPref = array(), array $coveragePref = array(), array $specialReqPref = array(), array $vehTypePref = array(), array $specialEquipPref = array(), $preferLevel = 'Preferred', $shareSynchInd = null, $shareMarketInd = null, $smokingAllowed = false, $gasPrePay = false)
    {
        $this
            ->setLoyaltyPref($loyaltyPref)
            ->setVendorPref($vendorPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setCoveragePref($coveragePref)
            ->setSpecialReqPref($specialReqPref)
            ->setVehTypePref($vehTypePref)
            ->setSpecialEquipPref($specialEquipPref)
            ->setPreferLevel($preferLevel)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setSmokingAllowed($smokingAllowed)
            ->setGasPrePay($gasPrePay);
    }
    /**
     * Get LoyaltyPref value
     * @return \StructType\LoyaltyPref[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyPrefForArrayConstraintsFromSetLoyaltyPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleProfileRentalPrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeLoyaltyPrefItem instanceof \StructType\LoyaltyPref) {
                $invalidValues[] = is_object($vehicleProfileRentalPrefTypeLoyaltyPrefItem) ? get_class($vehicleProfileRentalPrefTypeLoyaltyPrefItem) : sprintf('%s(%s)', gettype($vehicleProfileRentalPrefTypeLoyaltyPrefItem), var_export($vehicleProfileRentalPrefTypeLoyaltyPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyPref property can only contain items of type \StructType\LoyaltyPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyPref[] $loyaltyPref
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyPrefArrayErrorMessage = self::validateLoyaltyPrefForArrayConstraintsFromSetLoyaltyPref($loyaltyPref))) {
            throw new \InvalidArgumentException($loyaltyPrefArrayErrorMessage, __LINE__);
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyPref $item
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function addToLoyaltyPref(\StructType\LoyaltyPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LoyaltyPref) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of type \StructType\LoyaltyPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get VendorPref value
     * @return \StructType\CompanyNamePrefType[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * This method is responsible for validating the values passed to the setVendorPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendorPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorPrefForArrayConstraintsFromSetVendorPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleProfileRentalPrefTypeVendorPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeVendorPrefItem instanceof \StructType\CompanyNamePrefType) {
                $invalidValues[] = is_object($vehicleProfileRentalPrefTypeVendorPrefItem) ? get_class($vehicleProfileRentalPrefTypeVendorPrefItem) : sprintf('%s(%s)', gettype($vehicleProfileRentalPrefTypeVendorPrefItem), var_export($vehicleProfileRentalPrefTypeVendorPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VendorPref property can only contain items of type \StructType\CompanyNamePrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNamePrefType[] $vendorPref
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setVendorPref(array $vendorPref = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorPrefArrayErrorMessage = self::validateVendorPrefForArrayConstraintsFromSetVendorPref($vendorPref))) {
            throw new \InvalidArgumentException($vendorPrefArrayErrorMessage, __LINE__);
        }
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNamePrefType $item
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function addToVendorPref(\StructType\CompanyNamePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyNamePrefType) {
            throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of type \StructType\CompanyNamePrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return \StructType\PaymentFormPref[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFormPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFormPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFormPrefForArrayConstraintsFromSetPaymentFormPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleProfileRentalPrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypePaymentFormPrefItem instanceof \StructType\PaymentFormPref) {
                $invalidValues[] = is_object($vehicleProfileRentalPrefTypePaymentFormPrefItem) ? get_class($vehicleProfileRentalPrefTypePaymentFormPrefItem) : sprintf('%s(%s)', gettype($vehicleProfileRentalPrefTypePaymentFormPrefItem), var_export($vehicleProfileRentalPrefTypePaymentFormPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFormPref property can only contain items of type \StructType\PaymentFormPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFormPref[] $paymentFormPref
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFormPrefArrayErrorMessage = self::validatePaymentFormPrefForArrayConstraintsFromSetPaymentFormPref($paymentFormPref))) {
            throw new \InvalidArgumentException($paymentFormPrefArrayErrorMessage, __LINE__);
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFormPref $item
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function addToPaymentFormPref(\StructType\PaymentFormPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentFormPref) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of type \StructType\PaymentFormPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get CoveragePref value
     * @return \StructType\CoveragePref[]|null
     */
    public function getCoveragePref()
    {
        return $this->CoveragePref;
    }
    /**
     * This method is responsible for validating the values passed to the setCoveragePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCoveragePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCoveragePrefForArrayConstraintsFromSetCoveragePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleProfileRentalPrefTypeCoveragePrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeCoveragePrefItem instanceof \StructType\CoveragePref) {
                $invalidValues[] = is_object($vehicleProfileRentalPrefTypeCoveragePrefItem) ? get_class($vehicleProfileRentalPrefTypeCoveragePrefItem) : sprintf('%s(%s)', gettype($vehicleProfileRentalPrefTypeCoveragePrefItem), var_export($vehicleProfileRentalPrefTypeCoveragePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CoveragePref property can only contain items of type \StructType\CoveragePref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CoveragePref value
     * @throws \InvalidArgumentException
     * @param \StructType\CoveragePref[] $coveragePref
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setCoveragePref(array $coveragePref = array())
    {
        // validation for constraint: array
        if ('' !== ($coveragePrefArrayErrorMessage = self::validateCoveragePrefForArrayConstraintsFromSetCoveragePref($coveragePref))) {
            throw new \InvalidArgumentException($coveragePrefArrayErrorMessage, __LINE__);
        }
        $this->CoveragePref = $coveragePref;
        return $this;
    }
    /**
     * Add item to CoveragePref value
     * @throws \InvalidArgumentException
     * @param \StructType\CoveragePref $item
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function addToCoveragePref(\StructType\CoveragePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CoveragePref) {
            throw new \InvalidArgumentException(sprintf('The CoveragePref property can only contain items of type \StructType\CoveragePref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CoveragePref[] = $item;
        return $this;
    }
    /**
     * Get SpecialReqPref value
     * @return \StructType\VehicleSpecialReqPrefType[]|null
     */
    public function getSpecialReqPref()
    {
        return $this->SpecialReqPref;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialReqPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialReqPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialReqPrefForArrayConstraintsFromSetSpecialReqPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleProfileRentalPrefTypeSpecialReqPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeSpecialReqPrefItem instanceof \StructType\VehicleSpecialReqPrefType) {
                $invalidValues[] = is_object($vehicleProfileRentalPrefTypeSpecialReqPrefItem) ? get_class($vehicleProfileRentalPrefTypeSpecialReqPrefItem) : sprintf('%s(%s)', gettype($vehicleProfileRentalPrefTypeSpecialReqPrefItem), var_export($vehicleProfileRentalPrefTypeSpecialReqPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialReqPref property can only contain items of type \StructType\VehicleSpecialReqPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialReqPref value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleSpecialReqPrefType[] $specialReqPref
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setSpecialReqPref(array $specialReqPref = array())
    {
        // validation for constraint: array
        if ('' !== ($specialReqPrefArrayErrorMessage = self::validateSpecialReqPrefForArrayConstraintsFromSetSpecialReqPref($specialReqPref))) {
            throw new \InvalidArgumentException($specialReqPrefArrayErrorMessage, __LINE__);
        }
        $this->SpecialReqPref = $specialReqPref;
        return $this;
    }
    /**
     * Add item to SpecialReqPref value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleSpecialReqPrefType $item
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function addToSpecialReqPref(\StructType\VehicleSpecialReqPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleSpecialReqPrefType) {
            throw new \InvalidArgumentException(sprintf('The SpecialReqPref property can only contain items of type \StructType\VehicleSpecialReqPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecialReqPref[] = $item;
        return $this;
    }
    /**
     * Get VehTypePref value
     * @return \StructType\VehiclePrefType[]|null
     */
    public function getVehTypePref()
    {
        return $this->VehTypePref;
    }
    /**
     * This method is responsible for validating the values passed to the setVehTypePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehTypePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVehTypePrefForArrayConstraintsFromSetVehTypePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleProfileRentalPrefTypeVehTypePrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeVehTypePrefItem instanceof \StructType\VehiclePrefType) {
                $invalidValues[] = is_object($vehicleProfileRentalPrefTypeVehTypePrefItem) ? get_class($vehicleProfileRentalPrefTypeVehTypePrefItem) : sprintf('%s(%s)', gettype($vehicleProfileRentalPrefTypeVehTypePrefItem), var_export($vehicleProfileRentalPrefTypeVehTypePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VehTypePref property can only contain items of type \StructType\VehiclePrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VehTypePref value
     * @throws \InvalidArgumentException
     * @param \StructType\VehiclePrefType[] $vehTypePref
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setVehTypePref(array $vehTypePref = array())
    {
        // validation for constraint: array
        if ('' !== ($vehTypePrefArrayErrorMessage = self::validateVehTypePrefForArrayConstraintsFromSetVehTypePref($vehTypePref))) {
            throw new \InvalidArgumentException($vehTypePrefArrayErrorMessage, __LINE__);
        }
        $this->VehTypePref = $vehTypePref;
        return $this;
    }
    /**
     * Add item to VehTypePref value
     * @throws \InvalidArgumentException
     * @param \StructType\VehiclePrefType $item
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function addToVehTypePref(\StructType\VehiclePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehiclePrefType) {
            throw new \InvalidArgumentException(sprintf('The VehTypePref property can only contain items of type \StructType\VehiclePrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VehTypePref[] = $item;
        return $this;
    }
    /**
     * Get SpecialEquipPref value
     * @return \StructType\SpecialEquipPref[]|null
     */
    public function getSpecialEquipPref()
    {
        return $this->SpecialEquipPref;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialEquipPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialEquipPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialEquipPrefForArrayConstraintsFromSetSpecialEquipPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleProfileRentalPrefTypeSpecialEquipPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleProfileRentalPrefTypeSpecialEquipPrefItem instanceof \StructType\SpecialEquipPref) {
                $invalidValues[] = is_object($vehicleProfileRentalPrefTypeSpecialEquipPrefItem) ? get_class($vehicleProfileRentalPrefTypeSpecialEquipPrefItem) : sprintf('%s(%s)', gettype($vehicleProfileRentalPrefTypeSpecialEquipPrefItem), var_export($vehicleProfileRentalPrefTypeSpecialEquipPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialEquipPref property can only contain items of type \StructType\SpecialEquipPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialEquipPref value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialEquipPref[] $specialEquipPref
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setSpecialEquipPref(array $specialEquipPref = array())
    {
        // validation for constraint: array
        if ('' !== ($specialEquipPrefArrayErrorMessage = self::validateSpecialEquipPrefForArrayConstraintsFromSetSpecialEquipPref($specialEquipPref))) {
            throw new \InvalidArgumentException($specialEquipPrefArrayErrorMessage, __LINE__);
        }
        $this->SpecialEquipPref = $specialEquipPref;
        return $this;
    }
    /**
     * Add item to SpecialEquipPref value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialEquipPref $item
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function addToSpecialEquipPref(\StructType\SpecialEquipPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecialEquipPref) {
            throw new \InvalidArgumentException(sprintf('The SpecialEquipPref property can only contain items of type \StructType\SpecialEquipPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecialEquipPref[] = $item;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setSmokingAllowed($smokingAllowed = false)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($smokingAllowed, true), gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get GasPrePay value
     * @return bool|null
     */
    public function getGasPrePay()
    {
        return $this->GasPrePay;
    }
    /**
     * Set GasPrePay value
     * @param bool $gasPrePay
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public function setGasPrePay($gasPrePay = false)
    {
        // validation for constraint: boolean
        if (!is_null($gasPrePay) && !is_bool($gasPrePay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($gasPrePay, true), gettype($gasPrePay)), __LINE__);
        }
        $this->GasPrePay = $gasPrePay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleProfileRentalPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
