<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitDescriptiveContents StructType
 * @subpackage Structs
 */
class UnitDescriptiveContents extends AbstractStructBase
{
    /**
     * The UnitDescriptiveContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UnitDescriptiveContentType[]
     */
    public $UnitDescriptiveContent;
    /**
     * The CachedData
     * @var bool
     */
    public $CachedData;
    /**
     * Constructor method for UnitDescriptiveContents
     * @uses UnitDescriptiveContents::setUnitDescriptiveContent()
     * @uses UnitDescriptiveContents::setCachedData()
     * @param \StructType\UnitDescriptiveContentType[] $unitDescriptiveContent
     * @param bool $cachedData
     */
    public function __construct(array $unitDescriptiveContent = array(), $cachedData = null)
    {
        $this
            ->setUnitDescriptiveContent($unitDescriptiveContent)
            ->setCachedData($cachedData);
    }
    /**
     * Get UnitDescriptiveContent value
     * @return \StructType\UnitDescriptiveContentType[]|null
     */
    public function getUnitDescriptiveContent()
    {
        return $this->UnitDescriptiveContent;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitDescriptiveContent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitDescriptiveContent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitDescriptiveContentForArrayConstraintsFromSetUnitDescriptiveContent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $unitDescriptiveContentsUnitDescriptiveContentItem) {
            // validation for constraint: itemType
            if (!$unitDescriptiveContentsUnitDescriptiveContentItem instanceof \StructType\UnitDescriptiveContentType) {
                $invalidValues[] = is_object($unitDescriptiveContentsUnitDescriptiveContentItem) ? get_class($unitDescriptiveContentsUnitDescriptiveContentItem) : sprintf('%s(%s)', gettype($unitDescriptiveContentsUnitDescriptiveContentItem), var_export($unitDescriptiveContentsUnitDescriptiveContentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UnitDescriptiveContent property can only contain items of type \StructType\UnitDescriptiveContentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UnitDescriptiveContent value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitDescriptiveContentType[] $unitDescriptiveContent
     * @return \StructType\UnitDescriptiveContents
     */
    public function setUnitDescriptiveContent(array $unitDescriptiveContent = array())
    {
        // validation for constraint: array
        if ('' !== ($unitDescriptiveContentArrayErrorMessage = self::validateUnitDescriptiveContentForArrayConstraintsFromSetUnitDescriptiveContent($unitDescriptiveContent))) {
            throw new \InvalidArgumentException($unitDescriptiveContentArrayErrorMessage, __LINE__);
        }
        $this->UnitDescriptiveContent = $unitDescriptiveContent;
        return $this;
    }
    /**
     * Add item to UnitDescriptiveContent value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitDescriptiveContentType $item
     * @return \StructType\UnitDescriptiveContents
     */
    public function addToUnitDescriptiveContent(\StructType\UnitDescriptiveContentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnitDescriptiveContentType) {
            throw new \InvalidArgumentException(sprintf('The UnitDescriptiveContent property can only contain items of type \StructType\UnitDescriptiveContentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UnitDescriptiveContent[] = $item;
        return $this;
    }
    /**
     * Get CachedData value
     * @return bool|null
     */
    public function getCachedData()
    {
        return $this->CachedData;
    }
    /**
     * Set CachedData value
     * @param bool $cachedData
     * @return \StructType\UnitDescriptiveContents
     */
    public function setCachedData($cachedData = null)
    {
        // validation for constraint: boolean
        if (!is_null($cachedData) && !is_bool($cachedData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cachedData, true), gettype($cachedData)), __LINE__);
        }
        $this->CachedData = $cachedData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnitDescriptiveContents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
