<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OverriddenUnitStayRateType StructType
 * @subpackage Structs
 */
class OverriddenUnitStayRateType extends AbstractStructBase
{
    /**
     * The BaseRentAmount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $BaseRentAmount;
    /**
     * The TravelerOrderInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TravelerOrderInfo;
    /**
     * Constructor method for OverriddenUnitStayRateType
     * @uses OverriddenUnitStayRateType::setBaseRentAmount()
     * @uses OverriddenUnitStayRateType::setTravelerOrderInfo()
     * @param float $baseRentAmount
     * @param string $travelerOrderInfo
     */
    public function __construct($baseRentAmount = null, $travelerOrderInfo = null)
    {
        $this
            ->setBaseRentAmount($baseRentAmount)
            ->setTravelerOrderInfo($travelerOrderInfo);
    }
    /**
     * Get BaseRentAmount value
     * @return float
     */
    public function getBaseRentAmount()
    {
        return $this->BaseRentAmount;
    }
    /**
     * Set BaseRentAmount value
     * @param float $baseRentAmount
     * @return \StructType\OverriddenUnitStayRateType
     */
    public function setBaseRentAmount($baseRentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($baseRentAmount) && !(is_float($baseRentAmount) || is_numeric($baseRentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseRentAmount, true), gettype($baseRentAmount)), __LINE__);
        }
        $this->BaseRentAmount = $baseRentAmount;
        return $this;
    }
    /**
     * Get TravelerOrderInfo value
     * @return string|null
     */
    public function getTravelerOrderInfo()
    {
        return $this->TravelerOrderInfo;
    }
    /**
     * Set TravelerOrderInfo value
     * @param string $travelerOrderInfo
     * @return \StructType\OverriddenUnitStayRateType
     */
    public function setTravelerOrderInfo($travelerOrderInfo = null)
    {
        // validation for constraint: string
        if (!is_null($travelerOrderInfo) && !is_string($travelerOrderInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelerOrderInfo, true), gettype($travelerOrderInfo)), __LINE__);
        }
        $this->TravelerOrderInfo = $travelerOrderInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OverriddenUnitStayRateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
