<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FoodSrvcPrefType StructType
 * @subpackage Structs
 */
class FoodSrvcPrefType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The FoodSrvcType
     * @var string
     */
    public $FoodSrvcType;
    /**
     * Constructor method for FoodSrvcPrefType
     * @uses FoodSrvcPrefType::set_()
     * @uses FoodSrvcPrefType::setPreferLevel()
     * @uses FoodSrvcPrefType::setFoodSrvcType()
     * @param string $_
     * @param string $preferLevel
     * @param string $foodSrvcType
     */
    public function __construct($_ = null, $preferLevel = 'Preferred', $foodSrvcType = null)
    {
        $this
            ->set_($_)
            ->setPreferLevel($preferLevel)
            ->setFoodSrvcType($foodSrvcType);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\FoodSrvcPrefType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\FoodSrvcPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get FoodSrvcType value
     * @return string|null
     */
    public function getFoodSrvcType()
    {
        return $this->FoodSrvcType;
    }
    /**
     * Set FoodSrvcType value
     * @param string $foodSrvcType
     * @return \StructType\FoodSrvcPrefType
     */
    public function setFoodSrvcType($foodSrvcType = null)
    {
        // validation for constraint: string
        if (!is_null($foodSrvcType) && !is_string($foodSrvcType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foodSrvcType, true), gettype($foodSrvcType)), __LINE__);
        }
        $this->FoodSrvcType = $foodSrvcType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FoodSrvcPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
