<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeeType StructType
 * @subpackage Structs
 */
class FeeType extends AbstractStructBase
{
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TaxesType
     */
    public $Taxes;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ParagraphType[]
     */
    public $Description;
    /**
     * The TaxInclusive
     * @var bool
     */
    public $TaxInclusive;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Percent
     * @var float
     */
    public $Percent;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The MandatoryIndicator
     * @var bool
     */
    public $MandatoryIndicator;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The ChargeUnit
     * @var string
     */
    public $ChargeUnit;
    /**
     * The ChargeFrequency
     * @var string
     */
    public $ChargeFrequency;
    /**
     * The ChargeUnitExempt
     * @var int
     */
    public $ChargeUnitExempt;
    /**
     * The ChargeFrequencyExempt
     * @var int
     */
    public $ChargeFrequencyExempt;
    /**
     * The MaxChargeUnitApplies
     * @var int
     */
    public $MaxChargeUnitApplies;
    /**
     * The MaxChargeFrequencyApplies
     * @var int
     */
    public $MaxChargeFrequencyApplies;
    /**
     * The TaxableIndicator
     * @var bool
     */
    public $TaxableIndicator;
    /**
     * Constructor method for FeeType
     * @uses FeeType::setTaxes()
     * @uses FeeType::setDescription()
     * @uses FeeType::setTaxInclusive()
     * @uses FeeType::setType()
     * @uses FeeType::setCode()
     * @uses FeeType::setPercent()
     * @uses FeeType::setAmount()
     * @uses FeeType::setCurrencyCode()
     * @uses FeeType::setDecimalPlaces()
     * @uses FeeType::setEffectiveDate()
     * @uses FeeType::setExpireDate()
     * @uses FeeType::setMandatoryIndicator()
     * @uses FeeType::setRPH()
     * @uses FeeType::setChargeUnit()
     * @uses FeeType::setChargeFrequency()
     * @uses FeeType::setChargeUnitExempt()
     * @uses FeeType::setChargeFrequencyExempt()
     * @uses FeeType::setMaxChargeUnitApplies()
     * @uses FeeType::setMaxChargeFrequencyApplies()
     * @uses FeeType::setTaxableIndicator()
     * @param \StructType\TaxesType $taxes
     * @param \StructType\ParagraphType[] $description
     * @param bool $taxInclusive
     * @param string $type
     * @param string $code
     * @param float $percent
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $mandatoryIndicator
     * @param string $rPH
     * @param string $chargeUnit
     * @param string $chargeFrequency
     * @param int $chargeUnitExempt
     * @param int $chargeFrequencyExempt
     * @param int $maxChargeUnitApplies
     * @param int $maxChargeFrequencyApplies
     * @param bool $taxableIndicator
     */
    public function __construct(\StructType\TaxesType $taxes = null, array $description = array(), $taxInclusive = null, $type = null, $code = null, $percent = null, $amount = null, $currencyCode = null, $decimalPlaces = null, $effectiveDate = null, $expireDate = null, $mandatoryIndicator = null, $rPH = null, $chargeUnit = null, $chargeFrequency = null, $chargeUnitExempt = null, $chargeFrequencyExempt = null, $maxChargeUnitApplies = null, $maxChargeFrequencyApplies = null, $taxableIndicator = null)
    {
        $this
            ->setTaxes($taxes)
            ->setDescription($description)
            ->setTaxInclusive($taxInclusive)
            ->setType($type)
            ->setCode($code)
            ->setPercent($percent)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setMandatoryIndicator($mandatoryIndicator)
            ->setRPH($rPH)
            ->setChargeUnit($chargeUnit)
            ->setChargeFrequency($chargeFrequency)
            ->setChargeUnitExempt($chargeUnitExempt)
            ->setChargeFrequencyExempt($chargeFrequencyExempt)
            ->setMaxChargeUnitApplies($maxChargeUnitApplies)
            ->setMaxChargeFrequencyApplies($maxChargeFrequencyApplies)
            ->setTaxableIndicator($taxableIndicator);
    }
    /**
     * Get Taxes value
     * @return \StructType\TaxesType|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \StructType\TaxesType $taxes
     * @return \StructType\FeeType
     */
    public function setTaxes(\StructType\TaxesType $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\ParagraphType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $feeTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$feeTypeDescriptionItem instanceof \StructType\ParagraphType) {
                $invalidValues[] = is_object($feeTypeDescriptionItem) ? get_class($feeTypeDescriptionItem) : sprintf('%s(%s)', gettype($feeTypeDescriptionItem), var_export($feeTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \StructType\ParagraphType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType[] $description
     * @return \StructType\FeeType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType $item
     * @return \StructType\FeeType
     */
    public function addToDescription(\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \StructType\ParagraphType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get TaxInclusive value
     * @return bool|null
     */
    public function getTaxInclusive()
    {
        return $this->TaxInclusive;
    }
    /**
     * Set TaxInclusive value
     * @param bool $taxInclusive
     * @return \StructType\FeeType
     */
    public function setTaxInclusive($taxInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusive) && !is_bool($taxInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxInclusive, true), gettype($taxInclusive)), __LINE__);
        }
        $this->TaxInclusive = $taxInclusive;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\AmountDeterminationType::valueIsValid()
     * @uses \EnumType\AmountDeterminationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\FeeType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AmountDeterminationType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AmountDeterminationType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\AmountDeterminationType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\FeeType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\FeeType
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\FeeType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\FeeType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\FeeType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\FeeType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\FeeType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get MandatoryIndicator value
     * @return bool|null
     */
    public function getMandatoryIndicator()
    {
        return $this->MandatoryIndicator;
    }
    /**
     * Set MandatoryIndicator value
     * @param bool $mandatoryIndicator
     * @return \StructType\FeeType
     */
    public function setMandatoryIndicator($mandatoryIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatoryIndicator) && !is_bool($mandatoryIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatoryIndicator, true), gettype($mandatoryIndicator)), __LINE__);
        }
        $this->MandatoryIndicator = $mandatoryIndicator;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\FeeType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get ChargeUnit value
     * @return string|null
     */
    public function getChargeUnit()
    {
        return $this->ChargeUnit;
    }
    /**
     * Set ChargeUnit value
     * @param string $chargeUnit
     * @return \StructType\FeeType
     */
    public function setChargeUnit($chargeUnit = null)
    {
        // validation for constraint: string
        if (!is_null($chargeUnit) && !is_string($chargeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeUnit, true), gettype($chargeUnit)), __LINE__);
        }
        $this->ChargeUnit = $chargeUnit;
        return $this;
    }
    /**
     * Get ChargeFrequency value
     * @return string|null
     */
    public function getChargeFrequency()
    {
        return $this->ChargeFrequency;
    }
    /**
     * Set ChargeFrequency value
     * @param string $chargeFrequency
     * @return \StructType\FeeType
     */
    public function setChargeFrequency($chargeFrequency = null)
    {
        // validation for constraint: string
        if (!is_null($chargeFrequency) && !is_string($chargeFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeFrequency, true), gettype($chargeFrequency)), __LINE__);
        }
        $this->ChargeFrequency = $chargeFrequency;
        return $this;
    }
    /**
     * Get ChargeUnitExempt value
     * @return int|null
     */
    public function getChargeUnitExempt()
    {
        return $this->ChargeUnitExempt;
    }
    /**
     * Set ChargeUnitExempt value
     * @param int $chargeUnitExempt
     * @return \StructType\FeeType
     */
    public function setChargeUnitExempt($chargeUnitExempt = null)
    {
        // validation for constraint: int
        if (!is_null($chargeUnitExempt) && !(is_int($chargeUnitExempt) || ctype_digit($chargeUnitExempt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chargeUnitExempt, true), gettype($chargeUnitExempt)), __LINE__);
        }
        $this->ChargeUnitExempt = $chargeUnitExempt;
        return $this;
    }
    /**
     * Get ChargeFrequencyExempt value
     * @return int|null
     */
    public function getChargeFrequencyExempt()
    {
        return $this->ChargeFrequencyExempt;
    }
    /**
     * Set ChargeFrequencyExempt value
     * @param int $chargeFrequencyExempt
     * @return \StructType\FeeType
     */
    public function setChargeFrequencyExempt($chargeFrequencyExempt = null)
    {
        // validation for constraint: int
        if (!is_null($chargeFrequencyExempt) && !(is_int($chargeFrequencyExempt) || ctype_digit($chargeFrequencyExempt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chargeFrequencyExempt, true), gettype($chargeFrequencyExempt)), __LINE__);
        }
        $this->ChargeFrequencyExempt = $chargeFrequencyExempt;
        return $this;
    }
    /**
     * Get MaxChargeUnitApplies value
     * @return int|null
     */
    public function getMaxChargeUnitApplies()
    {
        return $this->MaxChargeUnitApplies;
    }
    /**
     * Set MaxChargeUnitApplies value
     * @param int $maxChargeUnitApplies
     * @return \StructType\FeeType
     */
    public function setMaxChargeUnitApplies($maxChargeUnitApplies = null)
    {
        // validation for constraint: int
        if (!is_null($maxChargeUnitApplies) && !(is_int($maxChargeUnitApplies) || ctype_digit($maxChargeUnitApplies))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxChargeUnitApplies, true), gettype($maxChargeUnitApplies)), __LINE__);
        }
        $this->MaxChargeUnitApplies = $maxChargeUnitApplies;
        return $this;
    }
    /**
     * Get MaxChargeFrequencyApplies value
     * @return int|null
     */
    public function getMaxChargeFrequencyApplies()
    {
        return $this->MaxChargeFrequencyApplies;
    }
    /**
     * Set MaxChargeFrequencyApplies value
     * @param int $maxChargeFrequencyApplies
     * @return \StructType\FeeType
     */
    public function setMaxChargeFrequencyApplies($maxChargeFrequencyApplies = null)
    {
        // validation for constraint: int
        if (!is_null($maxChargeFrequencyApplies) && !(is_int($maxChargeFrequencyApplies) || ctype_digit($maxChargeFrequencyApplies))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxChargeFrequencyApplies, true), gettype($maxChargeFrequencyApplies)), __LINE__);
        }
        $this->MaxChargeFrequencyApplies = $maxChargeFrequencyApplies;
        return $this;
    }
    /**
     * Get TaxableIndicator value
     * @return bool|null
     */
    public function getTaxableIndicator()
    {
        return $this->TaxableIndicator;
    }
    /**
     * Set TaxableIndicator value
     * @param bool $taxableIndicator
     * @return \StructType\FeeType
     */
    public function setTaxableIndicator($taxableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxableIndicator) && !is_bool($taxableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxableIndicator, true), gettype($taxableIndicator)), __LINE__);
        }
        $this->TaxableIndicator = $taxableIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FeeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
