<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EVRN_UnitHoldRS StructType
 * @subpackage Structs
 */
class EVRN_UnitHoldRS extends EVRN_BaseRSType
{
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - choice: Success | Warnings | UnitHolds | Errors | TPA_Extensions
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SuccessType
     */
    public $Success;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - choice: Success | Warnings | UnitHolds | Errors | TPA_Extensions
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WarningsType
     */
    public $Warnings;
    /**
     * The UnitHolds
     * Meta informations extracted from the WSDL
     * - choice: Success | Warnings | UnitHolds | Errors | TPA_Extensions
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UnitHolds
     */
    public $UnitHolds;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - choice: Success | Warnings | UnitHolds | Errors | TPA_Extensions
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ErrorsType
     */
    public $Errors;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - choice: Success | Warnings | UnitHolds | Errors | TPA_Extensions
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * Constructor method for EVRN_UnitHoldRS
     * @uses EVRN_UnitHoldRS::setSuccess()
     * @uses EVRN_UnitHoldRS::setWarnings()
     * @uses EVRN_UnitHoldRS::setUnitHolds()
     * @uses EVRN_UnitHoldRS::setErrors()
     * @uses EVRN_UnitHoldRS::setTPA_Extensions()
     * @param \StructType\SuccessType $success
     * @param \StructType\WarningsType $warnings
     * @param \StructType\UnitHolds $unitHolds
     * @param \StructType\ErrorsType $errors
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     */
    public function __construct(\StructType\SuccessType $success = null, \StructType\WarningsType $warnings = null, \StructType\UnitHolds $unitHolds = null, \StructType\ErrorsType $errors = null, \StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this
            ->setSuccess($success)
            ->setWarnings($warnings)
            ->setUnitHolds($unitHolds)
            ->setErrors($errors)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get Success value
     * @return \StructType\SuccessType|null
     */
    public function getSuccess()
    {
        return isset($this->Success) ? $this->Success : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSuccess method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSuccess method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSuccessForChoiceConstraintsFromSetSuccess($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Warnings',
            'UnitHolds',
            'Errors',
            'TPA_Extensions',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Success can\'t be set as the property %s is already set. Only one property must be set among these properties: Success, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Success value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SuccessType $success
     * @return \StructType\EVRN_UnitHoldRS
     */
    public function setSuccess(\StructType\SuccessType $success = null)
    {
        // validation for constraint: choice(Success, Warnings, UnitHolds, Errors, TPA_Extensions)
        if ('' !== ($successChoiceErrorMessage = self::validateSuccessForChoiceConstraintsFromSetSuccess($success))) {
            throw new \InvalidArgumentException($successChoiceErrorMessage, __LINE__);
        }
        if (is_null($success) || (is_array($success) && empty($success))) {
            unset($this->Success);
        } else {
            $this->Success = $success;
        }
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\WarningsType|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWarnings method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarnings method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWarningsForChoiceConstraintsFromSetWarnings($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'UnitHolds',
            'Errors',
            'TPA_Extensions',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Warnings can\'t be set as the property %s is already set. Only one property must be set among these properties: Warnings, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Warnings value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WarningsType $warnings
     * @return \StructType\EVRN_UnitHoldRS
     */
    public function setWarnings(\StructType\WarningsType $warnings = null)
    {
        // validation for constraint: choice(Success, Warnings, UnitHolds, Errors, TPA_Extensions)
        if ('' !== ($warningsChoiceErrorMessage = self::validateWarningsForChoiceConstraintsFromSetWarnings($warnings))) {
            throw new \InvalidArgumentException($warningsChoiceErrorMessage, __LINE__);
        }
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
    /**
     * Get UnitHolds value
     * @return \StructType\UnitHolds|null
     */
    public function getUnitHolds()
    {
        return isset($this->UnitHolds) ? $this->UnitHolds : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUnitHolds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitHolds method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUnitHoldsForChoiceConstraintsFromSetUnitHolds($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
            'Errors',
            'TPA_Extensions',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property UnitHolds can\'t be set as the property %s is already set. Only one property must be set among these properties: UnitHolds, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set UnitHolds value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UnitHolds $unitHolds
     * @return \StructType\EVRN_UnitHoldRS
     */
    public function setUnitHolds(\StructType\UnitHolds $unitHolds = null)
    {
        // validation for constraint: choice(Success, Warnings, UnitHolds, Errors, TPA_Extensions)
        if ('' !== ($unitHoldsChoiceErrorMessage = self::validateUnitHoldsForChoiceConstraintsFromSetUnitHolds($unitHolds))) {
            throw new \InvalidArgumentException($unitHoldsChoiceErrorMessage, __LINE__);
        }
        if (is_null($unitHolds) || (is_array($unitHolds) && empty($unitHolds))) {
            unset($this->UnitHolds);
        } else {
            $this->UnitHolds = $unitHolds;
        }
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\ErrorsType|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * This method is responsible for validating the value passed to the setErrors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrors method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErrorsForChoiceConstraintsFromSetErrors($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
            'UnitHolds',
            'TPA_Extensions',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Errors can\'t be set as the property %s is already set. Only one property must be set among these properties: Errors, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Errors value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorsType $errors
     * @return \StructType\EVRN_UnitHoldRS
     */
    public function setErrors(\StructType\ErrorsType $errors = null)
    {
        // validation for constraint: choice(Success, Warnings, UnitHolds, Errors, TPA_Extensions)
        if ('' !== ($errorsChoiceErrorMessage = self::validateErrorsForChoiceConstraintsFromSetErrors($errors))) {
            throw new \InvalidArgumentException($errorsChoiceErrorMessage, __LINE__);
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return isset($this->TPA_Extensions) ? $this->TPA_Extensions : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTPA_Extensions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTPA_Extensions method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTPA_ExtensionsForChoiceConstraintsFromSetTPA_Extensions($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Success',
            'Warnings',
            'UnitHolds',
            'Errors',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TPA_Extensions can\'t be set as the property %s is already set. Only one property must be set among these properties: TPA_Extensions, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TPA_Extensions value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \StructType\EVRN_UnitHoldRS
     */
    public function setTPA_Extensions(\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        // validation for constraint: choice(Success, Warnings, UnitHolds, Errors, TPA_Extensions)
        if ('' !== ($tPA_ExtensionsChoiceErrorMessage = self::validateTPA_ExtensionsForChoiceConstraintsFromSetTPA_Extensions($tPA_Extensions))) {
            throw new \InvalidArgumentException($tPA_ExtensionsChoiceErrorMessage, __LINE__);
        }
        if (is_null($tPA_Extensions) || (is_array($tPA_Extensions) && empty($tPA_Extensions))) {
            unset($this->TPA_Extensions);
        } else {
            $this->TPA_Extensions = $tPA_Extensions;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EVRN_UnitHoldRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
