<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EVRN_ReservationUpdateRQ StructType
 * @subpackage Structs
 */
class EVRN_ReservationUpdateRQ extends EVRN_BaseRQType
{
    /**
     * The BookingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BookingNumber;
    /**
     * The AgentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgentID;
    /**
     * The UnitCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitCode;
    /**
     * The NewUnitCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewUnitCode;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EndDate;
    /**
     * The RecalculateRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RecalculateRate;
    /**
     * The Preview
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Preview;
    /**
     * Constructor method for EVRN_ReservationUpdateRQ
     * @uses EVRN_ReservationUpdateRQ::setBookingNumber()
     * @uses EVRN_ReservationUpdateRQ::setAgentID()
     * @uses EVRN_ReservationUpdateRQ::setUnitCode()
     * @uses EVRN_ReservationUpdateRQ::setNewUnitCode()
     * @uses EVRN_ReservationUpdateRQ::setStartDate()
     * @uses EVRN_ReservationUpdateRQ::setEndDate()
     * @uses EVRN_ReservationUpdateRQ::setRecalculateRate()
     * @uses EVRN_ReservationUpdateRQ::setPreview()
     * @param string $bookingNumber
     * @param string $agentID
     * @param string $unitCode
     * @param string $newUnitCode
     * @param string $startDate
     * @param string $endDate
     * @param string $recalculateRate
     * @param string $preview
     */
    public function __construct($bookingNumber = null, $agentID = null, $unitCode = null, $newUnitCode = null, $startDate = null, $endDate = null, $recalculateRate = null, $preview = null)
    {
        $this
            ->setBookingNumber($bookingNumber)
            ->setAgentID($agentID)
            ->setUnitCode($unitCode)
            ->setNewUnitCode($newUnitCode)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setRecalculateRate($recalculateRate)
            ->setPreview($preview);
    }
    /**
     * Get BookingNumber value
     * @return string|null
     */
    public function getBookingNumber()
    {
        return $this->BookingNumber;
    }
    /**
     * Set BookingNumber value
     * @param string $bookingNumber
     * @return \StructType\EVRN_ReservationUpdateRQ
     */
    public function setBookingNumber($bookingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bookingNumber) && !is_string($bookingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingNumber, true), gettype($bookingNumber)), __LINE__);
        }
        $this->BookingNumber = $bookingNumber;
        return $this;
    }
    /**
     * Get AgentID value
     * @return string|null
     */
    public function getAgentID()
    {
        return $this->AgentID;
    }
    /**
     * Set AgentID value
     * @param string $agentID
     * @return \StructType\EVRN_ReservationUpdateRQ
     */
    public function setAgentID($agentID = null)
    {
        // validation for constraint: string
        if (!is_null($agentID) && !is_string($agentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentID, true), gettype($agentID)), __LINE__);
        }
        $this->AgentID = $agentID;
        return $this;
    }
    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }
    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return \StructType\EVRN_ReservationUpdateRQ
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCode, true), gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }
    /**
     * Get NewUnitCode value
     * @return string|null
     */
    public function getNewUnitCode()
    {
        return $this->NewUnitCode;
    }
    /**
     * Set NewUnitCode value
     * @param string $newUnitCode
     * @return \StructType\EVRN_ReservationUpdateRQ
     */
    public function setNewUnitCode($newUnitCode = null)
    {
        // validation for constraint: string
        if (!is_null($newUnitCode) && !is_string($newUnitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newUnitCode, true), gettype($newUnitCode)), __LINE__);
        }
        $this->NewUnitCode = $newUnitCode;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\EVRN_ReservationUpdateRQ
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\EVRN_ReservationUpdateRQ
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get RecalculateRate value
     * @return string|null
     */
    public function getRecalculateRate()
    {
        return $this->RecalculateRate;
    }
    /**
     * Set RecalculateRate value
     * @param string $recalculateRate
     * @return \StructType\EVRN_ReservationUpdateRQ
     */
    public function setRecalculateRate($recalculateRate = null)
    {
        // validation for constraint: string
        if (!is_null($recalculateRate) && !is_string($recalculateRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recalculateRate, true), gettype($recalculateRate)), __LINE__);
        }
        $this->RecalculateRate = $recalculateRate;
        return $this;
    }
    /**
     * Get Preview value
     * @return string|null
     */
    public function getPreview()
    {
        return $this->Preview;
    }
    /**
     * Set Preview value
     * @param string $preview
     * @return \StructType\EVRN_ReservationUpdateRQ
     */
    public function setPreview($preview = null)
    {
        // validation for constraint: string
        if (!is_null($preview) && !is_string($preview)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preview, true), gettype($preview)), __LINE__);
        }
        $this->Preview = $preview;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EVRN_ReservationUpdateRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
