<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasicUnitInfoType StructType
 * @subpackage Structs
 */
class BasicUnitInfoType extends AbstractStructBase
{
    /**
     * The VendorMessages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfVendorMessageType
     */
    public $VendorMessages;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Position
     */
    public $Position;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressInfoType
     */
    public $Address;
    /**
     * The ContactNumbers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfBasicUnitInfoTypeContactNumber
     */
    public $ContactNumbers;
    /**
     * The Award
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Award[]
     */
    public $Award;
    /**
     * The UnitAmenity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UnitAmenityType[]
     */
    public $UnitAmenity;
    /**
     * The UnitSummary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UnitStayCandidateType
     */
    public $UnitSummary;
    /**
     * The PropertyManagerCode
     * @var string
     */
    public $PropertyManagerCode;
    /**
     * The UnitCode
     * @var string
     */
    public $UnitCode;
    /**
     * The UnitName
     * @var string
     */
    public $UnitName;
    /**
     * The InfoSource
     * @var string
     */
    public $InfoSource;
    /**
     * The InternalUnitCode
     * @var string
     */
    public $InternalUnitCode;
    /**
     * The UnitHeadline
     * @var string
     */
    public $UnitHeadline;
    /**
     * The PropertyURL
     * @var string
     */
    public $PropertyURL;
    /**
     * The UnitClassCode
     * @var string
     */
    public $UnitClassCode;
    /**
     * Constructor method for BasicUnitInfoType
     * @uses BasicUnitInfoType::setVendorMessages()
     * @uses BasicUnitInfoType::setPosition()
     * @uses BasicUnitInfoType::setAddress()
     * @uses BasicUnitInfoType::setContactNumbers()
     * @uses BasicUnitInfoType::setAward()
     * @uses BasicUnitInfoType::setUnitAmenity()
     * @uses BasicUnitInfoType::setUnitSummary()
     * @uses BasicUnitInfoType::setPropertyManagerCode()
     * @uses BasicUnitInfoType::setUnitCode()
     * @uses BasicUnitInfoType::setUnitName()
     * @uses BasicUnitInfoType::setInfoSource()
     * @uses BasicUnitInfoType::setInternalUnitCode()
     * @uses BasicUnitInfoType::setUnitHeadline()
     * @uses BasicUnitInfoType::setPropertyURL()
     * @uses BasicUnitInfoType::setUnitClassCode()
     * @param \ArrayType\ArrayOfVendorMessageType $vendorMessages
     * @param \StructType\Position $position
     * @param \StructType\AddressInfoType $address
     * @param \ArrayType\ArrayOfBasicUnitInfoTypeContactNumber $contactNumbers
     * @param \StructType\Award[] $award
     * @param \StructType\UnitAmenityType[] $unitAmenity
     * @param \StructType\UnitStayCandidateType $unitSummary
     * @param string $propertyManagerCode
     * @param string $unitCode
     * @param string $unitName
     * @param string $infoSource
     * @param string $internalUnitCode
     * @param string $unitHeadline
     * @param string $propertyURL
     * @param string $unitClassCode
     */
    public function __construct(\ArrayType\ArrayOfVendorMessageType $vendorMessages = null, \StructType\Position $position = null, \StructType\AddressInfoType $address = null, \ArrayType\ArrayOfBasicUnitInfoTypeContactNumber $contactNumbers = null, array $award = array(), array $unitAmenity = array(), \StructType\UnitStayCandidateType $unitSummary = null, $propertyManagerCode = null, $unitCode = null, $unitName = null, $infoSource = null, $internalUnitCode = null, $unitHeadline = null, $propertyURL = null, $unitClassCode = null)
    {
        $this
            ->setVendorMessages($vendorMessages)
            ->setPosition($position)
            ->setAddress($address)
            ->setContactNumbers($contactNumbers)
            ->setAward($award)
            ->setUnitAmenity($unitAmenity)
            ->setUnitSummary($unitSummary)
            ->setPropertyManagerCode($propertyManagerCode)
            ->setUnitCode($unitCode)
            ->setUnitName($unitName)
            ->setInfoSource($infoSource)
            ->setInternalUnitCode($internalUnitCode)
            ->setUnitHeadline($unitHeadline)
            ->setPropertyURL($propertyURL)
            ->setUnitClassCode($unitClassCode);
    }
    /**
     * Get VendorMessages value
     * @return \ArrayType\ArrayOfVendorMessageType|null
     */
    public function getVendorMessages()
    {
        return $this->VendorMessages;
    }
    /**
     * Set VendorMessages value
     * @param \ArrayType\ArrayOfVendorMessageType $vendorMessages
     * @return \StructType\BasicUnitInfoType
     */
    public function setVendorMessages(\ArrayType\ArrayOfVendorMessageType $vendorMessages = null)
    {
        $this->VendorMessages = $vendorMessages;
        return $this;
    }
    /**
     * Get Position value
     * @return \StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \StructType\Position $position
     * @return \StructType\BasicUnitInfoType
     */
    public function setPosition(\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressInfoType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressInfoType $address
     * @return \StructType\BasicUnitInfoType
     */
    public function setAddress(\StructType\AddressInfoType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ContactNumbers value
     * @return \ArrayType\ArrayOfBasicUnitInfoTypeContactNumber|null
     */
    public function getContactNumbers()
    {
        return $this->ContactNumbers;
    }
    /**
     * Set ContactNumbers value
     * @param \ArrayType\ArrayOfBasicUnitInfoTypeContactNumber $contactNumbers
     * @return \StructType\BasicUnitInfoType
     */
    public function setContactNumbers(\ArrayType\ArrayOfBasicUnitInfoTypeContactNumber $contactNumbers = null)
    {
        $this->ContactNumbers = $contactNumbers;
        return $this;
    }
    /**
     * Get Award value
     * @return \StructType\Award[]|null
     */
    public function getAward()
    {
        return $this->Award;
    }
    /**
     * This method is responsible for validating the values passed to the setAward method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAward method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAwardForArrayConstraintsFromSetAward(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $basicUnitInfoTypeAwardItem) {
            // validation for constraint: itemType
            if (!$basicUnitInfoTypeAwardItem instanceof \StructType\Award) {
                $invalidValues[] = is_object($basicUnitInfoTypeAwardItem) ? get_class($basicUnitInfoTypeAwardItem) : sprintf('%s(%s)', gettype($basicUnitInfoTypeAwardItem), var_export($basicUnitInfoTypeAwardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Award property can only contain items of type \StructType\Award, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Award value
     * @throws \InvalidArgumentException
     * @param \StructType\Award[] $award
     * @return \StructType\BasicUnitInfoType
     */
    public function setAward(array $award = array())
    {
        // validation for constraint: array
        if ('' !== ($awardArrayErrorMessage = self::validateAwardForArrayConstraintsFromSetAward($award))) {
            throw new \InvalidArgumentException($awardArrayErrorMessage, __LINE__);
        }
        $this->Award = $award;
        return $this;
    }
    /**
     * Add item to Award value
     * @throws \InvalidArgumentException
     * @param \StructType\Award $item
     * @return \StructType\BasicUnitInfoType
     */
    public function addToAward(\StructType\Award $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Award) {
            throw new \InvalidArgumentException(sprintf('The Award property can only contain items of type \StructType\Award, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Award[] = $item;
        return $this;
    }
    /**
     * Get UnitAmenity value
     * @return \StructType\UnitAmenityType[]|null
     */
    public function getUnitAmenity()
    {
        return $this->UnitAmenity;
    }
    /**
     * This method is responsible for validating the values passed to the setUnitAmenity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnitAmenity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnitAmenityForArrayConstraintsFromSetUnitAmenity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $basicUnitInfoTypeUnitAmenityItem) {
            // validation for constraint: itemType
            if (!$basicUnitInfoTypeUnitAmenityItem instanceof \StructType\UnitAmenityType) {
                $invalidValues[] = is_object($basicUnitInfoTypeUnitAmenityItem) ? get_class($basicUnitInfoTypeUnitAmenityItem) : sprintf('%s(%s)', gettype($basicUnitInfoTypeUnitAmenityItem), var_export($basicUnitInfoTypeUnitAmenityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UnitAmenity property can only contain items of type \StructType\UnitAmenityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UnitAmenity value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitAmenityType[] $unitAmenity
     * @return \StructType\BasicUnitInfoType
     */
    public function setUnitAmenity(array $unitAmenity = array())
    {
        // validation for constraint: array
        if ('' !== ($unitAmenityArrayErrorMessage = self::validateUnitAmenityForArrayConstraintsFromSetUnitAmenity($unitAmenity))) {
            throw new \InvalidArgumentException($unitAmenityArrayErrorMessage, __LINE__);
        }
        $this->UnitAmenity = $unitAmenity;
        return $this;
    }
    /**
     * Add item to UnitAmenity value
     * @throws \InvalidArgumentException
     * @param \StructType\UnitAmenityType $item
     * @return \StructType\BasicUnitInfoType
     */
    public function addToUnitAmenity(\StructType\UnitAmenityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnitAmenityType) {
            throw new \InvalidArgumentException(sprintf('The UnitAmenity property can only contain items of type \StructType\UnitAmenityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UnitAmenity[] = $item;
        return $this;
    }
    /**
     * Get UnitSummary value
     * @return \StructType\UnitStayCandidateType|null
     */
    public function getUnitSummary()
    {
        return $this->UnitSummary;
    }
    /**
     * Set UnitSummary value
     * @param \StructType\UnitStayCandidateType $unitSummary
     * @return \StructType\BasicUnitInfoType
     */
    public function setUnitSummary(\StructType\UnitStayCandidateType $unitSummary = null)
    {
        $this->UnitSummary = $unitSummary;
        return $this;
    }
    /**
     * Get PropertyManagerCode value
     * @return string|null
     */
    public function getPropertyManagerCode()
    {
        return $this->PropertyManagerCode;
    }
    /**
     * Set PropertyManagerCode value
     * @param string $propertyManagerCode
     * @return \StructType\BasicUnitInfoType
     */
    public function setPropertyManagerCode($propertyManagerCode = null)
    {
        // validation for constraint: string
        if (!is_null($propertyManagerCode) && !is_string($propertyManagerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyManagerCode, true), gettype($propertyManagerCode)), __LINE__);
        }
        $this->PropertyManagerCode = $propertyManagerCode;
        return $this;
    }
    /**
     * Get UnitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->UnitCode;
    }
    /**
     * Set UnitCode value
     * @param string $unitCode
     * @return \StructType\BasicUnitInfoType
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCode, true), gettype($unitCode)), __LINE__);
        }
        $this->UnitCode = $unitCode;
        return $this;
    }
    /**
     * Get UnitName value
     * @return string|null
     */
    public function getUnitName()
    {
        return $this->UnitName;
    }
    /**
     * Set UnitName value
     * @param string $unitName
     * @return \StructType\BasicUnitInfoType
     */
    public function setUnitName($unitName = null)
    {
        // validation for constraint: string
        if (!is_null($unitName) && !is_string($unitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitName, true), gettype($unitName)), __LINE__);
        }
        $this->UnitName = $unitName;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \StructType\BasicUnitInfoType
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoSource, true), gettype($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get InternalUnitCode value
     * @return string|null
     */
    public function getInternalUnitCode()
    {
        return $this->InternalUnitCode;
    }
    /**
     * Set InternalUnitCode value
     * @param string $internalUnitCode
     * @return \StructType\BasicUnitInfoType
     */
    public function setInternalUnitCode($internalUnitCode = null)
    {
        // validation for constraint: string
        if (!is_null($internalUnitCode) && !is_string($internalUnitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalUnitCode, true), gettype($internalUnitCode)), __LINE__);
        }
        $this->InternalUnitCode = $internalUnitCode;
        return $this;
    }
    /**
     * Get UnitHeadline value
     * @return string|null
     */
    public function getUnitHeadline()
    {
        return $this->UnitHeadline;
    }
    /**
     * Set UnitHeadline value
     * @param string $unitHeadline
     * @return \StructType\BasicUnitInfoType
     */
    public function setUnitHeadline($unitHeadline = null)
    {
        // validation for constraint: string
        if (!is_null($unitHeadline) && !is_string($unitHeadline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitHeadline, true), gettype($unitHeadline)), __LINE__);
        }
        $this->UnitHeadline = $unitHeadline;
        return $this;
    }
    /**
     * Get PropertyURL value
     * @return string|null
     */
    public function getPropertyURL()
    {
        return $this->PropertyURL;
    }
    /**
     * Set PropertyURL value
     * @param string $propertyURL
     * @return \StructType\BasicUnitInfoType
     */
    public function setPropertyURL($propertyURL = null)
    {
        // validation for constraint: string
        if (!is_null($propertyURL) && !is_string($propertyURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyURL, true), gettype($propertyURL)), __LINE__);
        }
        $this->PropertyURL = $propertyURL;
        return $this;
    }
    /**
     * Get UnitClassCode value
     * @return string|null
     */
    public function getUnitClassCode()
    {
        return $this->UnitClassCode;
    }
    /**
     * Set UnitClassCode value
     * @param string $unitClassCode
     * @return \StructType\BasicUnitInfoType
     */
    public function setUnitClassCode($unitClassCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitClassCode) && !is_string($unitClassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitClassCode, true), gettype($unitClassCode)), __LINE__);
        }
        $this->UnitClassCode = $unitClassCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BasicUnitInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
