<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AllianceConsortiumType StructType
 * @subpackage Structs
 */
class AllianceConsortiumType extends AbstractStructBase
{
    /**
     * The AllianceMember
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AllianceMember[]
     */
    public $AllianceMember;
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * Constructor method for AllianceConsortiumType
     * @uses AllianceConsortiumType::setAllianceMember()
     * @uses AllianceConsortiumType::setID()
     * @uses AllianceConsortiumType::setEffectiveDate()
     * @uses AllianceConsortiumType::setExpireDate()
     * @param \StructType\AllianceMember[] $allianceMember
     * @param string $iD
     * @param string $effectiveDate
     * @param string $expireDate
     */
    public function __construct(array $allianceMember = array(), $iD = null, $effectiveDate = null, $expireDate = null)
    {
        $this
            ->setAllianceMember($allianceMember)
            ->setID($iD)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate);
    }
    /**
     * Get AllianceMember value
     * @return \StructType\AllianceMember[]|null
     */
    public function getAllianceMember()
    {
        return $this->AllianceMember;
    }
    /**
     * This method is responsible for validating the values passed to the setAllianceMember method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllianceMember method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllianceMemberForArrayConstraintsFromSetAllianceMember(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $allianceConsortiumTypeAllianceMemberItem) {
            // validation for constraint: itemType
            if (!$allianceConsortiumTypeAllianceMemberItem instanceof \StructType\AllianceMember) {
                $invalidValues[] = is_object($allianceConsortiumTypeAllianceMemberItem) ? get_class($allianceConsortiumTypeAllianceMemberItem) : sprintf('%s(%s)', gettype($allianceConsortiumTypeAllianceMemberItem), var_export($allianceConsortiumTypeAllianceMemberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AllianceMember property can only contain items of type \StructType\AllianceMember, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AllianceMember value
     * @throws \InvalidArgumentException
     * @param \StructType\AllianceMember[] $allianceMember
     * @return \StructType\AllianceConsortiumType
     */
    public function setAllianceMember(array $allianceMember = array())
    {
        // validation for constraint: array
        if ('' !== ($allianceMemberArrayErrorMessage = self::validateAllianceMemberForArrayConstraintsFromSetAllianceMember($allianceMember))) {
            throw new \InvalidArgumentException($allianceMemberArrayErrorMessage, __LINE__);
        }
        $this->AllianceMember = $allianceMember;
        return $this;
    }
    /**
     * Add item to AllianceMember value
     * @throws \InvalidArgumentException
     * @param \StructType\AllianceMember $item
     * @return \StructType\AllianceConsortiumType
     */
    public function addToAllianceMember(\StructType\AllianceMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AllianceMember) {
            throw new \InvalidArgumentException(sprintf('The AllianceMember property can only contain items of type \StructType\AllianceMember, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AllianceMember[] = $item;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\AllianceConsortiumType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\AllianceConsortiumType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\AllianceConsortiumType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AllianceConsortiumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
