<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalChargeType StructType
 * @subpackage Structs
 */
class AdditionalChargeType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TotalType
     */
    public $Amount;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ParagraphType[]
     */
    public $Description;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The ChargeTemplateID
     * @var int
     */
    public $ChargeTemplateID;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for AdditionalChargeType
     * @uses AdditionalChargeType::setAmount()
     * @uses AdditionalChargeType::setDescription()
     * @uses AdditionalChargeType::setCode()
     * @uses AdditionalChargeType::setChargeTemplateID()
     * @uses AdditionalChargeType::setQuantity()
     * @param \StructType\TotalType $amount
     * @param \StructType\ParagraphType[] $description
     * @param string $code
     * @param int $chargeTemplateID
     * @param int $quantity
     */
    public function __construct(\StructType\TotalType $amount = null, array $description = array(), $code = null, $chargeTemplateID = null, $quantity = null)
    {
        $this
            ->setAmount($amount)
            ->setDescription($description)
            ->setCode($code)
            ->setChargeTemplateID($chargeTemplateID)
            ->setQuantity($quantity);
    }
    /**
     * Get Amount value
     * @return \StructType\TotalType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\TotalType $amount
     * @return \StructType\AdditionalChargeType
     */
    public function setAmount(\StructType\TotalType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\ParagraphType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $additionalChargeTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$additionalChargeTypeDescriptionItem instanceof \StructType\ParagraphType) {
                $invalidValues[] = is_object($additionalChargeTypeDescriptionItem) ? get_class($additionalChargeTypeDescriptionItem) : sprintf('%s(%s)', gettype($additionalChargeTypeDescriptionItem), var_export($additionalChargeTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \StructType\ParagraphType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType[] $description
     * @return \StructType\AdditionalChargeType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType $item
     * @return \StructType\AdditionalChargeType
     */
    public function addToDescription(\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \StructType\ParagraphType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\AdditionalChargeType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get ChargeTemplateID value
     * @return int|null
     */
    public function getChargeTemplateID()
    {
        return $this->ChargeTemplateID;
    }
    /**
     * Set ChargeTemplateID value
     * @param int $chargeTemplateID
     * @return \StructType\AdditionalChargeType
     */
    public function setChargeTemplateID($chargeTemplateID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeTemplateID) && !(is_int($chargeTemplateID) || ctype_digit($chargeTemplateID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chargeTemplateID, true), gettype($chargeTemplateID)), __LINE__);
        }
        $this->ChargeTemplateID = $chargeTemplateID;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\AdditionalChargeType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalChargeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
