<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Service StructType
 * @subpackage Structs
 */
class Service extends AbstractStructBase
{
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AmountType[]
     */
    public $Price;
    /**
     * The ServiceDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResCommonDetailType
     */
    public $ServiceDetails;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TPA_Extensions_Type
     */
    public $TPA_Extensions;
    /**
     * The ServicePricingType
     * @var string
     */
    public $ServicePricingType;
    /**
     * The ReservationStatusType
     * @var string
     */
    public $ReservationStatusType;
    /**
     * The ServiceRPH
     * @var string
     */
    public $ServiceRPH;
    /**
     * The ServiceInventoryCode
     * @var string
     */
    public $ServiceInventoryCode;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The InventoryBlockCode
     * @var string
     */
    public $InventoryBlockCode;
    /**
     * The PriceGuaranteed
     * @var bool
     */
    public $PriceGuaranteed;
    /**
     * The Inclusive
     * @var bool
     */
    public $Inclusive;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The RelativePosition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RelativePositionType
     */
    public $RelativePosition;
    /**
     * The OperationSchedules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOperationSchedulesPlusChargeTypeOperationSchedule
     */
    public $OperationSchedules;
    /**
     * The MultimediaDescriptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultimediaDescriptionsType
     */
    public $MultimediaDescriptions;
    /**
     * The Features
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfFeaturesTypeFeature
     */
    public $Features;
    /**
     * The DescriptiveText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DescriptiveText
     */
    public $DescriptiveText;
    /**
     * The TextValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TextValue
     */
    public $TextValue;
    /**
     * The Included
     * @var bool
     */
    public $Included;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The BusinessServiceCode
     * @var string
     */
    public $BusinessServiceCode;
    /**
     * The ExistsCode
     * @var string
     */
    public $ExistsCode;
    /**
     * The CodeDetail
     * @var string
     */
    public $CodeDetail;
    /**
     * The AvailableToAnyGuest
     * @var bool
     */
    public $AvailableToAnyGuest;
    /**
     * The InvCode
     * @var string
     */
    public $InvCode;
    /**
     * The ProximityCode
     * @var string
     */
    public $ProximityCode;
    /**
     * The MealPlanCode
     * @var string
     */
    public $MealPlanCode;
    /**
     * The Sort
     * @var int
     */
    public $Sort;
    /**
     * The MeetingRoomCode
     * @var string
     */
    public $MeetingRoomCode;
    /**
     * Constructor method for Service
     * @uses Service::setPrice()
     * @uses Service::setServiceDetails()
     * @uses Service::setTPA_Extensions()
     * @uses Service::setServicePricingType()
     * @uses Service::setReservationStatusType()
     * @uses Service::setServiceRPH()
     * @uses Service::setServiceInventoryCode()
     * @uses Service::setRatePlanCode()
     * @uses Service::setInventoryBlockCode()
     * @uses Service::setPriceGuaranteed()
     * @uses Service::setInclusive()
     * @uses Service::setQuantity()
     * @uses Service::setRelativePosition()
     * @uses Service::setOperationSchedules()
     * @uses Service::setMultimediaDescriptions()
     * @uses Service::setFeatures()
     * @uses Service::setDescriptiveText()
     * @uses Service::setTextValue()
     * @uses Service::setIncluded()
     * @uses Service::setCode()
     * @uses Service::setBusinessServiceCode()
     * @uses Service::setExistsCode()
     * @uses Service::setCodeDetail()
     * @uses Service::setAvailableToAnyGuest()
     * @uses Service::setInvCode()
     * @uses Service::setProximityCode()
     * @uses Service::setMealPlanCode()
     * @uses Service::setSort()
     * @uses Service::setMeetingRoomCode()
     * @param \StructType\AmountType[] $price
     * @param \StructType\ResCommonDetailType $serviceDetails
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     * @param string $servicePricingType
     * @param string $reservationStatusType
     * @param string $serviceRPH
     * @param string $serviceInventoryCode
     * @param string $ratePlanCode
     * @param string $inventoryBlockCode
     * @param bool $priceGuaranteed
     * @param bool $inclusive
     * @param int $quantity
     * @param \StructType\RelativePositionType $relativePosition
     * @param \ArrayType\ArrayOfOperationSchedulesPlusChargeTypeOperationSchedule $operationSchedules
     * @param \StructType\MultimediaDescriptionsType $multimediaDescriptions
     * @param \ArrayType\ArrayOfFeaturesTypeFeature $features
     * @param \StructType\DescriptiveText $descriptiveText
     * @param \StructType\TextValue $textValue
     * @param bool $included
     * @param string $code
     * @param string $businessServiceCode
     * @param string $existsCode
     * @param string $codeDetail
     * @param bool $availableToAnyGuest
     * @param string $invCode
     * @param string $proximityCode
     * @param string $mealPlanCode
     * @param int $sort
     * @param string $meetingRoomCode
     */
    public function __construct(array $price = array(), \StructType\ResCommonDetailType $serviceDetails = null, \StructType\TPA_Extensions_Type $tPA_Extensions = null, $servicePricingType = null, $reservationStatusType = null, $serviceRPH = null, $serviceInventoryCode = null, $ratePlanCode = null, $inventoryBlockCode = null, $priceGuaranteed = null, $inclusive = null, $quantity = null, \StructType\RelativePositionType $relativePosition = null, \ArrayType\ArrayOfOperationSchedulesPlusChargeTypeOperationSchedule $operationSchedules = null, \StructType\MultimediaDescriptionsType $multimediaDescriptions = null, \ArrayType\ArrayOfFeaturesTypeFeature $features = null, \StructType\DescriptiveText $descriptiveText = null, \StructType\TextValue $textValue = null, $included = null, $code = null, $businessServiceCode = null, $existsCode = null, $codeDetail = null, $availableToAnyGuest = null, $invCode = null, $proximityCode = null, $mealPlanCode = null, $sort = null, $meetingRoomCode = null)
    {
        $this
            ->setPrice($price)
            ->setServiceDetails($serviceDetails)
            ->setTPA_Extensions($tPA_Extensions)
            ->setServicePricingType($servicePricingType)
            ->setReservationStatusType($reservationStatusType)
            ->setServiceRPH($serviceRPH)
            ->setServiceInventoryCode($serviceInventoryCode)
            ->setRatePlanCode($ratePlanCode)
            ->setInventoryBlockCode($inventoryBlockCode)
            ->setPriceGuaranteed($priceGuaranteed)
            ->setInclusive($inclusive)
            ->setQuantity($quantity)
            ->setRelativePosition($relativePosition)
            ->setOperationSchedules($operationSchedules)
            ->setMultimediaDescriptions($multimediaDescriptions)
            ->setFeatures($features)
            ->setDescriptiveText($descriptiveText)
            ->setTextValue($textValue)
            ->setIncluded($included)
            ->setCode($code)
            ->setBusinessServiceCode($businessServiceCode)
            ->setExistsCode($existsCode)
            ->setCodeDetail($codeDetail)
            ->setAvailableToAnyGuest($availableToAnyGuest)
            ->setInvCode($invCode)
            ->setProximityCode($proximityCode)
            ->setMealPlanCode($mealPlanCode)
            ->setSort($sort)
            ->setMeetingRoomCode($meetingRoomCode);
    }
    /**
     * Get Price value
     * @return \StructType\AmountType[]|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * This method is responsible for validating the values passed to the setPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceForArrayConstraintsFromSetPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $servicePriceItem) {
            // validation for constraint: itemType
            if (!$servicePriceItem instanceof \StructType\AmountType) {
                $invalidValues[] = is_object($servicePriceItem) ? get_class($servicePriceItem) : sprintf('%s(%s)', gettype($servicePriceItem), var_export($servicePriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Price property can only contain items of type \StructType\AmountType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Price value
     * @throws \InvalidArgumentException
     * @param \StructType\AmountType[] $price
     * @return \StructType\Service
     */
    public function setPrice(array $price = array())
    {
        // validation for constraint: array
        if ('' !== ($priceArrayErrorMessage = self::validatePriceForArrayConstraintsFromSetPrice($price))) {
            throw new \InvalidArgumentException($priceArrayErrorMessage, __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Add item to Price value
     * @throws \InvalidArgumentException
     * @param \StructType\AmountType $item
     * @return \StructType\Service
     */
    public function addToPrice(\StructType\AmountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AmountType) {
            throw new \InvalidArgumentException(sprintf('The Price property can only contain items of type \StructType\AmountType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Price[] = $item;
        return $this;
    }
    /**
     * Get ServiceDetails value
     * @return \StructType\ResCommonDetailType|null
     */
    public function getServiceDetails()
    {
        return $this->ServiceDetails;
    }
    /**
     * Set ServiceDetails value
     * @param \StructType\ResCommonDetailType $serviceDetails
     * @return \StructType\Service
     */
    public function setServiceDetails(\StructType\ResCommonDetailType $serviceDetails = null)
    {
        $this->ServiceDetails = $serviceDetails;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_Extensions_Type|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_Extensions_Type $tPA_Extensions
     * @return \StructType\Service
     */
    public function setTPA_Extensions(\StructType\TPA_Extensions_Type $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ServicePricingType value
     * @return string|null
     */
    public function getServicePricingType()
    {
        return $this->ServicePricingType;
    }
    /**
     * Set ServicePricingType value
     * @uses \EnumType\PricingType::valueIsValid()
     * @uses \EnumType\PricingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $servicePricingType
     * @return \StructType\Service
     */
    public function setServicePricingType($servicePricingType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PricingType::valueIsValid($servicePricingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PricingType', is_array($servicePricingType) ? implode(', ', $servicePricingType) : var_export($servicePricingType, true), implode(', ', \EnumType\PricingType::getValidValues())), __LINE__);
        }
        $this->ServicePricingType = $servicePricingType;
        return $this;
    }
    /**
     * Get ReservationStatusType value
     * @return string|null
     */
    public function getReservationStatusType()
    {
        return $this->ReservationStatusType;
    }
    /**
     * Set ReservationStatusType value
     * @uses \EnumType\PMS_ResStatusType::valueIsValid()
     * @uses \EnumType\PMS_ResStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reservationStatusType
     * @return \StructType\Service
     */
    public function setReservationStatusType($reservationStatusType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PMS_ResStatusType::valueIsValid($reservationStatusType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PMS_ResStatusType', is_array($reservationStatusType) ? implode(', ', $reservationStatusType) : var_export($reservationStatusType, true), implode(', ', \EnumType\PMS_ResStatusType::getValidValues())), __LINE__);
        }
        $this->ReservationStatusType = $reservationStatusType;
        return $this;
    }
    /**
     * Get ServiceRPH value
     * @return string|null
     */
    public function getServiceRPH()
    {
        return $this->ServiceRPH;
    }
    /**
     * Set ServiceRPH value
     * @param string $serviceRPH
     * @return \StructType\Service
     */
    public function setServiceRPH($serviceRPH = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRPH) && !is_string($serviceRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRPH, true), gettype($serviceRPH)), __LINE__);
        }
        $this->ServiceRPH = $serviceRPH;
        return $this;
    }
    /**
     * Get ServiceInventoryCode value
     * @return string|null
     */
    public function getServiceInventoryCode()
    {
        return $this->ServiceInventoryCode;
    }
    /**
     * Set ServiceInventoryCode value
     * @param string $serviceInventoryCode
     * @return \StructType\Service
     */
    public function setServiceInventoryCode($serviceInventoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceInventoryCode) && !is_string($serviceInventoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceInventoryCode, true), gettype($serviceInventoryCode)), __LINE__);
        }
        $this->ServiceInventoryCode = $serviceInventoryCode;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\Service
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get InventoryBlockCode value
     * @return string|null
     */
    public function getInventoryBlockCode()
    {
        return $this->InventoryBlockCode;
    }
    /**
     * Set InventoryBlockCode value
     * @param string $inventoryBlockCode
     * @return \StructType\Service
     */
    public function setInventoryBlockCode($inventoryBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryBlockCode) && !is_string($inventoryBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryBlockCode, true), gettype($inventoryBlockCode)), __LINE__);
        }
        $this->InventoryBlockCode = $inventoryBlockCode;
        return $this;
    }
    /**
     * Get PriceGuaranteed value
     * @return bool|null
     */
    public function getPriceGuaranteed()
    {
        return $this->PriceGuaranteed;
    }
    /**
     * Set PriceGuaranteed value
     * @param bool $priceGuaranteed
     * @return \StructType\Service
     */
    public function setPriceGuaranteed($priceGuaranteed = null)
    {
        // validation for constraint: boolean
        if (!is_null($priceGuaranteed) && !is_bool($priceGuaranteed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($priceGuaranteed, true), gettype($priceGuaranteed)), __LINE__);
        }
        $this->PriceGuaranteed = $priceGuaranteed;
        return $this;
    }
    /**
     * Get Inclusive value
     * @return bool|null
     */
    public function getInclusive()
    {
        return $this->Inclusive;
    }
    /**
     * Set Inclusive value
     * @param bool $inclusive
     * @return \StructType\Service
     */
    public function setInclusive($inclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inclusive) && !is_bool($inclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inclusive, true), gettype($inclusive)), __LINE__);
        }
        $this->Inclusive = $inclusive;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\Service
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get RelativePosition value
     * @return \StructType\RelativePositionType|null
     */
    public function getRelativePosition()
    {
        return $this->RelativePosition;
    }
    /**
     * Set RelativePosition value
     * @param \StructType\RelativePositionType $relativePosition
     * @return \StructType\Service
     */
    public function setRelativePosition(\StructType\RelativePositionType $relativePosition = null)
    {
        $this->RelativePosition = $relativePosition;
        return $this;
    }
    /**
     * Get OperationSchedules value
     * @return \ArrayType\ArrayOfOperationSchedulesPlusChargeTypeOperationSchedule|null
     */
    public function getOperationSchedules()
    {
        return $this->OperationSchedules;
    }
    /**
     * Set OperationSchedules value
     * @param \ArrayType\ArrayOfOperationSchedulesPlusChargeTypeOperationSchedule $operationSchedules
     * @return \StructType\Service
     */
    public function setOperationSchedules(\ArrayType\ArrayOfOperationSchedulesPlusChargeTypeOperationSchedule $operationSchedules = null)
    {
        $this->OperationSchedules = $operationSchedules;
        return $this;
    }
    /**
     * Get MultimediaDescriptions value
     * @return \StructType\MultimediaDescriptionsType|null
     */
    public function getMultimediaDescriptions()
    {
        return $this->MultimediaDescriptions;
    }
    /**
     * Set MultimediaDescriptions value
     * @param \StructType\MultimediaDescriptionsType $multimediaDescriptions
     * @return \StructType\Service
     */
    public function setMultimediaDescriptions(\StructType\MultimediaDescriptionsType $multimediaDescriptions = null)
    {
        $this->MultimediaDescriptions = $multimediaDescriptions;
        return $this;
    }
    /**
     * Get Features value
     * @return \ArrayType\ArrayOfFeaturesTypeFeature|null
     */
    public function getFeatures()
    {
        return $this->Features;
    }
    /**
     * Set Features value
     * @param \ArrayType\ArrayOfFeaturesTypeFeature $features
     * @return \StructType\Service
     */
    public function setFeatures(\ArrayType\ArrayOfFeaturesTypeFeature $features = null)
    {
        $this->Features = $features;
        return $this;
    }
    /**
     * Get DescriptiveText value
     * @return \StructType\DescriptiveText|null
     */
    public function getDescriptiveText()
    {
        return $this->DescriptiveText;
    }
    /**
     * Set DescriptiveText value
     * @param \StructType\DescriptiveText $descriptiveText
     * @return \StructType\Service
     */
    public function setDescriptiveText(\StructType\DescriptiveText $descriptiveText = null)
    {
        $this->DescriptiveText = $descriptiveText;
        return $this;
    }
    /**
     * Get TextValue value
     * @return \StructType\TextValue|null
     */
    public function getTextValue()
    {
        return $this->TextValue;
    }
    /**
     * Set TextValue value
     * @param \StructType\TextValue $textValue
     * @return \StructType\Service
     */
    public function setTextValue(\StructType\TextValue $textValue = null)
    {
        $this->TextValue = $textValue;
        return $this;
    }
    /**
     * Get Included value
     * @return bool|null
     */
    public function getIncluded()
    {
        return $this->Included;
    }
    /**
     * Set Included value
     * @param bool $included
     * @return \StructType\Service
     */
    public function setIncluded($included = null)
    {
        // validation for constraint: boolean
        if (!is_null($included) && !is_bool($included)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($included, true), gettype($included)), __LINE__);
        }
        $this->Included = $included;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Service
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get BusinessServiceCode value
     * @return string|null
     */
    public function getBusinessServiceCode()
    {
        return $this->BusinessServiceCode;
    }
    /**
     * Set BusinessServiceCode value
     * @param string $businessServiceCode
     * @return \StructType\Service
     */
    public function setBusinessServiceCode($businessServiceCode = null)
    {
        // validation for constraint: string
        if (!is_null($businessServiceCode) && !is_string($businessServiceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessServiceCode, true), gettype($businessServiceCode)), __LINE__);
        }
        $this->BusinessServiceCode = $businessServiceCode;
        return $this;
    }
    /**
     * Get ExistsCode value
     * @return string|null
     */
    public function getExistsCode()
    {
        return $this->ExistsCode;
    }
    /**
     * Set ExistsCode value
     * @param string $existsCode
     * @return \StructType\Service
     */
    public function setExistsCode($existsCode = null)
    {
        // validation for constraint: string
        if (!is_null($existsCode) && !is_string($existsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($existsCode, true), gettype($existsCode)), __LINE__);
        }
        $this->ExistsCode = $existsCode;
        return $this;
    }
    /**
     * Get CodeDetail value
     * @return string|null
     */
    public function getCodeDetail()
    {
        return $this->CodeDetail;
    }
    /**
     * Set CodeDetail value
     * @param string $codeDetail
     * @return \StructType\Service
     */
    public function setCodeDetail($codeDetail = null)
    {
        // validation for constraint: string
        if (!is_null($codeDetail) && !is_string($codeDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeDetail, true), gettype($codeDetail)), __LINE__);
        }
        $this->CodeDetail = $codeDetail;
        return $this;
    }
    /**
     * Get AvailableToAnyGuest value
     * @return bool|null
     */
    public function getAvailableToAnyGuest()
    {
        return $this->AvailableToAnyGuest;
    }
    /**
     * Set AvailableToAnyGuest value
     * @param bool $availableToAnyGuest
     * @return \StructType\Service
     */
    public function setAvailableToAnyGuest($availableToAnyGuest = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableToAnyGuest) && !is_bool($availableToAnyGuest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableToAnyGuest, true), gettype($availableToAnyGuest)), __LINE__);
        }
        $this->AvailableToAnyGuest = $availableToAnyGuest;
        return $this;
    }
    /**
     * Get InvCode value
     * @return string|null
     */
    public function getInvCode()
    {
        return $this->InvCode;
    }
    /**
     * Set InvCode value
     * @param string $invCode
     * @return \StructType\Service
     */
    public function setInvCode($invCode = null)
    {
        // validation for constraint: string
        if (!is_null($invCode) && !is_string($invCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invCode, true), gettype($invCode)), __LINE__);
        }
        $this->InvCode = $invCode;
        return $this;
    }
    /**
     * Get ProximityCode value
     * @return string|null
     */
    public function getProximityCode()
    {
        return $this->ProximityCode;
    }
    /**
     * Set ProximityCode value
     * @param string $proximityCode
     * @return \StructType\Service
     */
    public function setProximityCode($proximityCode = null)
    {
        // validation for constraint: string
        if (!is_null($proximityCode) && !is_string($proximityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proximityCode, true), gettype($proximityCode)), __LINE__);
        }
        $this->ProximityCode = $proximityCode;
        return $this;
    }
    /**
     * Get MealPlanCode value
     * @return string|null
     */
    public function getMealPlanCode()
    {
        return $this->MealPlanCode;
    }
    /**
     * Set MealPlanCode value
     * @param string $mealPlanCode
     * @return \StructType\Service
     */
    public function setMealPlanCode($mealPlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($mealPlanCode) && !is_string($mealPlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mealPlanCode, true), gettype($mealPlanCode)), __LINE__);
        }
        $this->MealPlanCode = $mealPlanCode;
        return $this;
    }
    /**
     * Get Sort value
     * @return int|null
     */
    public function getSort()
    {
        return $this->Sort;
    }
    /**
     * Set Sort value
     * @param int $sort
     * @return \StructType\Service
     */
    public function setSort($sort = null)
    {
        // validation for constraint: int
        if (!is_null($sort) && !(is_int($sort) || ctype_digit($sort))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sort, true), gettype($sort)), __LINE__);
        }
        $this->Sort = $sort;
        return $this;
    }
    /**
     * Get MeetingRoomCode value
     * @return string|null
     */
    public function getMeetingRoomCode()
    {
        return $this->MeetingRoomCode;
    }
    /**
     * Set MeetingRoomCode value
     * @param string $meetingRoomCode
     * @return \StructType\Service
     */
    public function setMeetingRoomCode($meetingRoomCode = null)
    {
        // validation for constraint: string
        if (!is_null($meetingRoomCode) && !is_string($meetingRoomCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetingRoomCode, true), gettype($meetingRoomCode)), __LINE__);
        }
        $this->MeetingRoomCode = $meetingRoomCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Service
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
