<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadRequest StructType
 * @subpackage Structs
 */
class ReadRequest extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The Verification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VerificationType
     */
    public $Verification;
    /**
     * The HistoryRequestedInd
     * @var bool
     */
    public $HistoryRequestedInd;
    /**
     * The startDate
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * @var string
     */
    public $endDate;
    /**
     * The requestDateType
     * @var string
     */
    public $requestDateType;
    /**
     * The summaryOnly
     * @var bool
     */
    public $summaryOnly;
    /**
     * The maxResults
     * @var int
     */
    public $maxResults;
    /**
     * Constructor method for ReadRequest
     * @uses ReadRequest::setUniqueID()
     * @uses ReadRequest::setVerification()
     * @uses ReadRequest::setHistoryRequestedInd()
     * @uses ReadRequest::setStartDate()
     * @uses ReadRequest::setEndDate()
     * @uses ReadRequest::setRequestDateType()
     * @uses ReadRequest::setSummaryOnly()
     * @uses ReadRequest::setMaxResults()
     * @param \StructType\UniqueID_Type $uniqueID
     * @param \StructType\VerificationType $verification
     * @param bool $historyRequestedInd
     * @param string $startDate
     * @param string $endDate
     * @param string $requestDateType
     * @param bool $summaryOnly
     * @param int $maxResults
     */
    public function __construct(\StructType\UniqueID_Type $uniqueID = null, \StructType\VerificationType $verification = null, $historyRequestedInd = null, $startDate = null, $endDate = null, $requestDateType = null, $summaryOnly = null, $maxResults = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setVerification($verification)
            ->setHistoryRequestedInd($historyRequestedInd)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setRequestDateType($requestDateType)
            ->setSummaryOnly($summaryOnly)
            ->setMaxResults($maxResults);
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID_Type $uniqueID
     * @return \StructType\ReadRequest
     */
    public function setUniqueID(\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get Verification value
     * @return \StructType\VerificationType|null
     */
    public function getVerification()
    {
        return $this->Verification;
    }
    /**
     * Set Verification value
     * @param \StructType\VerificationType $verification
     * @return \StructType\ReadRequest
     */
    public function setVerification(\StructType\VerificationType $verification = null)
    {
        $this->Verification = $verification;
        return $this;
    }
    /**
     * Get HistoryRequestedInd value
     * @return bool|null
     */
    public function getHistoryRequestedInd()
    {
        return $this->HistoryRequestedInd;
    }
    /**
     * Set HistoryRequestedInd value
     * @param bool $historyRequestedInd
     * @return \StructType\ReadRequest
     */
    public function setHistoryRequestedInd($historyRequestedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($historyRequestedInd) && !is_bool($historyRequestedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($historyRequestedInd, true), gettype($historyRequestedInd)), __LINE__);
        }
        $this->HistoryRequestedInd = $historyRequestedInd;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\ReadRequest
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\ReadRequest
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get requestDateType value
     * @return string|null
     */
    public function getRequestDateType()
    {
        return $this->requestDateType;
    }
    /**
     * Set requestDateType value
     * @param string $requestDateType
     * @return \StructType\ReadRequest
     */
    public function setRequestDateType($requestDateType = null)
    {
        // validation for constraint: string
        if (!is_null($requestDateType) && !is_string($requestDateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestDateType, true), gettype($requestDateType)), __LINE__);
        }
        $this->requestDateType = $requestDateType;
        return $this;
    }
    /**
     * Get summaryOnly value
     * @return bool|null
     */
    public function getSummaryOnly()
    {
        return $this->summaryOnly;
    }
    /**
     * Set summaryOnly value
     * @param bool $summaryOnly
     * @return \StructType\ReadRequest
     */
    public function setSummaryOnly($summaryOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($summaryOnly) && !is_bool($summaryOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($summaryOnly, true), gettype($summaryOnly)), __LINE__);
        }
        $this->summaryOnly = $summaryOnly;
        return $this;
    }
    /**
     * Get maxResults value
     * @return int|null
     */
    public function getMaxResults()
    {
        return $this->maxResults;
    }
    /**
     * Set maxResults value
     * @param int $maxResults
     * @return \StructType\ReadRequest
     */
    public function setMaxResults($maxResults = null)
    {
        // validation for constraint: int
        if (!is_null($maxResults) && !(is_int($maxResults) || ctype_digit($maxResults))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxResults, true), gettype($maxResults)), __LINE__);
        }
        $this->maxResults = $maxResults;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
